// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticinference

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticinference.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.elasticinference.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.elasticinference.model.*
import aws.sdk.kotlin.services.elasticinference.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Elastic Inference"
public const val ServiceApiVersion: String = "2017-07-25"
public const val SdkVersion: String = "0.18.0-beta"

internal class DefaultElasticInferenceClient(override val config: ElasticInferenceClient.Config) : ElasticInferenceClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Describes the locations in which a given accelerator type or set of types is present in a given region.
     */
    override suspend fun describeAcceleratorOfferings(input: DescribeAcceleratorOfferingsRequest): DescribeAcceleratorOfferingsResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorOfferingsRequest, DescribeAcceleratorOfferingsResponse> {
            serializer = DescribeAcceleratorOfferingsOperationSerializer()
            deserializer = DescribeAcceleratorOfferingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAcceleratorOfferings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeAcceleratorOfferings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
     */
    override suspend fun describeAcceleratorTypes(input: DescribeAcceleratorTypesRequest): DescribeAcceleratorTypesResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorTypesRequest, DescribeAcceleratorTypesResponse> {
            serializer = DescribeAcceleratorTypesOperationSerializer()
            deserializer = DescribeAcceleratorTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAcceleratorTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeAcceleratorTypes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes information over a provided set of accelerators belonging to an account.
     */
    override suspend fun describeAccelerators(input: DescribeAcceleratorsRequest): DescribeAcceleratorsResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorsRequest, DescribeAcceleratorsResponse> {
            serializer = DescribeAcceleratorsOperationSerializer()
            deserializer = DescribeAcceleratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccelerators"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeAccelerators-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns all tags of an Elastic Inference Accelerator.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds the specified tags to an Elastic Inference Accelerator.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified tags from an Elastic Inference Accelerator.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastic-inference"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elastic-inference")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
