// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticinference

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticinference.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.elasticinference.endpoints.EndpointProvider
import aws.sdk.kotlin.services.elasticinference.model.*
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorOfferingsResponse
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorTypesRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorTypesResponse
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorsRequest
import aws.sdk.kotlin.services.elasticinference.model.DescribeAcceleratorsResponse
import aws.sdk.kotlin.services.elasticinference.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.elasticinference.model.TagResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.TagResourceResponse
import aws.sdk.kotlin.services.elasticinference.model.UntagResourceRequest
import aws.sdk.kotlin.services.elasticinference.model.UntagResourceResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Elastic Inference public APIs.
 */
public interface ElasticInferenceClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Inference"
    /**
     * ElasticInferenceClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ElasticInferenceClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticInferenceClient(config)
        }

        public operator fun invoke(config: Config): ElasticInferenceClient = DefaultElasticInferenceClient(config)

        /**
         * Construct a [ElasticInferenceClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticInferenceClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultElasticInferenceClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Elastic Inference")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Describes the locations in which a given accelerator type or set of types is present in a given region.
     */
    public suspend fun describeAcceleratorOfferings(input: DescribeAcceleratorOfferingsRequest): DescribeAcceleratorOfferingsResponse

    /**
     * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
     */
    public suspend fun describeAcceleratorTypes(input: DescribeAcceleratorTypesRequest = DescribeAcceleratorTypesRequest {}): DescribeAcceleratorTypesResponse

    /**
     * Describes information over a provided set of accelerators belonging to an account.
     */
    public suspend fun describeAccelerators(input: DescribeAcceleratorsRequest = DescribeAcceleratorsRequest {}): DescribeAcceleratorsResponse

    /**
     * Returns all tags of an Elastic Inference Accelerator.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds the specified tags to an Elastic Inference Accelerator.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags from an Elastic Inference Accelerator.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse
}

/**
 * Describes the locations in which a given accelerator type or set of types is present in a given region.
 */
public suspend inline fun ElasticInferenceClient.describeAcceleratorOfferings(crossinline block: DescribeAcceleratorOfferingsRequest.Builder.() -> Unit): DescribeAcceleratorOfferingsResponse = describeAcceleratorOfferings(DescribeAcceleratorOfferingsRequest.Builder().apply(block).build())

/**
 * Describes the accelerator types available in a given region, as well as their characteristics, such as memory and throughput.
 */
public suspend inline fun ElasticInferenceClient.describeAcceleratorTypes(crossinline block: DescribeAcceleratorTypesRequest.Builder.() -> Unit): DescribeAcceleratorTypesResponse = describeAcceleratorTypes(DescribeAcceleratorTypesRequest.Builder().apply(block).build())

/**
 * Describes information over a provided set of accelerators belonging to an account.
 */
public suspend inline fun ElasticInferenceClient.describeAccelerators(crossinline block: DescribeAcceleratorsRequest.Builder.() -> Unit): DescribeAcceleratorsResponse = describeAccelerators(DescribeAcceleratorsRequest.Builder().apply(block).build())

/**
 * Returns all tags of an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from an Elastic Inference Accelerator.
 */
public suspend inline fun ElasticInferenceClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())
