// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing

import aws.sdk.kotlin.runtime.auth.signing.AwsSigV4SigningMiddleware
import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elasticloadbalancing.model.*
import aws.sdk.kotlin.services.elasticloadbalancing.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.middleware.MutateHeaders
import aws.smithy.kotlin.runtime.http.middleware.Retry
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "Elastic Load Balancing"
const val ServiceApiVersion: String = "2012-06-01"
const val SdkVersion: String = "0.13.1-beta"

internal class DefaultElasticLoadBalancingClient(override val config: ElasticLoadBalancingClient.Config) : ElasticLoadBalancingClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated
     * with the load balancer, AddTags updates its value.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun addTags(input: AddTagsRequest): AddTagsResponse {
        val op = SdkHttpOperation.build<AddTagsRequest, AddTagsResponse> {
            serializer = AddTagsOperationSerializer()
            deserializer = AddTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC
     * in the Classic Load Balancers Guide.
     */
    override suspend fun applySecurityGroupsToLoadBalancer(input: ApplySecurityGroupsToLoadBalancerRequest): ApplySecurityGroupsToLoadBalancerResponse {
        val op = SdkHttpOperation.build<ApplySecurityGroupsToLoadBalancerRequest, ApplySecurityGroupsToLoadBalancerResponse> {
            serializer = ApplySecurityGroupsToLoadBalancerOperationSerializer()
            deserializer = ApplySecurityGroupsToLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ApplySecurityGroupsToLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more subnets to the set of configured subnets for the specified load balancer.
     * The load balancer evenly distributes requests across all registered subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC
     * in the Classic Load Balancers Guide.
     */
    override suspend fun attachLoadBalancerToSubnets(input: AttachLoadBalancerToSubnetsRequest): AttachLoadBalancerToSubnetsResponse {
        val op = SdkHttpOperation.build<AttachLoadBalancerToSubnetsRequest, AttachLoadBalancerToSubnetsResponse> {
            serializer = AttachLoadBalancerToSubnetsOperationSerializer()
            deserializer = AttachLoadBalancerToSubnetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachLoadBalancerToSubnets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html">Configure Health Checks for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun configureHealthCheck(input: ConfigureHealthCheckRequest): ConfigureHealthCheckResponse {
        val op = SdkHttpOperation.build<ConfigureHealthCheckRequest, ConfigureHealthCheckResponse> {
            serializer = ConfigureHealthCheckOperationSerializer()
            deserializer = ConfigureHealthCheckOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ConfigureHealthCheck"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
     * This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
     * except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
     * follows the lifetime of the application-generated cookie specified in the policy configuration.
     * The load balancer only inserts a new stickiness cookie when the application response
     * includes a new application cookie.
     * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    override suspend fun createAppCookieStickinessPolicy(input: CreateAppCookieStickinessPolicyRequest): CreateAppCookieStickinessPolicyResponse {
        val op = SdkHttpOperation.build<CreateAppCookieStickinessPolicyRequest, CreateAppCookieStickinessPolicyResponse> {
            serializer = CreateAppCookieStickinessPolicyOperationSerializer()
            deserializer = CreateAppCookieStickinessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAppCookieStickinessPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
     * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request.
     * If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
     * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    override suspend fun createLbCookieStickinessPolicy(input: CreateLbCookieStickinessPolicyRequest): CreateLbCookieStickinessPolicyResponse {
        val op = SdkHttpOperation.build<CreateLbCookieStickinessPolicyRequest, CreateLbCookieStickinessPolicyResponse> {
            serializer = CreateLBCookieStickinessPolicyOperationSerializer()
            deserializer = CreateLBCookieStickinessPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLBCookieStickinessPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a Classic Load Balancer.
     *
     * You can add listeners, security groups, subnets, and tags when you create your load balancer,
     * or you can add them later using CreateLoadBalancerListeners,
     * ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets,
     * and AddTags.
     * To describe your current load balancers, see DescribeLoadBalancers.
     * When you are finished with a load balancer, you can delete it using
     * DeleteLoadBalancer.
     *
     * You can create up to 20 load balancers per region per account.
     * You can request an increase for the number of load balancers for your account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerRequest, CreateLoadBalancerResponse> {
            serializer = CreateLoadBalancerOperationSerializer()
            deserializer = CreateLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun createLoadBalancerListeners(input: CreateLoadBalancerListenersRequest): CreateLoadBalancerListenersResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerListenersRequest, CreateLoadBalancerListenersResponse> {
            serializer = CreateLoadBalancerListenersOperationSerializer()
            deserializer = CreateLoadBalancerListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLoadBalancerListeners"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a policy with the specified attributes for the specified load balancer.
     * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
     */
    override suspend fun createLoadBalancerPolicy(input: CreateLoadBalancerPolicyRequest): CreateLoadBalancerPolicyResponse {
        val op = SdkHttpOperation.build<CreateLoadBalancerPolicyRequest, CreateLoadBalancerPolicyResponse> {
            serializer = CreateLoadBalancerPolicyOperationSerializer()
            deserializer = CreateLoadBalancerPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLoadBalancerPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified load balancer.
     * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
     * If the load balancer does not exist or has already been deleted, the call to
     * DeleteLoadBalancer still succeeds.
     */
    override suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse> {
            serializer = DeleteLoadBalancerOperationSerializer()
            deserializer = DeleteLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified listeners from the specified load balancer.
     */
    override suspend fun deleteLoadBalancerListeners(input: DeleteLoadBalancerListenersRequest): DeleteLoadBalancerListenersResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerListenersRequest, DeleteLoadBalancerListenersResponse> {
            serializer = DeleteLoadBalancerListenersOperationSerializer()
            deserializer = DeleteLoadBalancerListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLoadBalancerListeners"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     */
    override suspend fun deleteLoadBalancerPolicy(input: DeleteLoadBalancerPolicyRequest): DeleteLoadBalancerPolicyResponse {
        val op = SdkHttpOperation.build<DeleteLoadBalancerPolicyRequest, DeleteLoadBalancerPolicyResponse> {
            serializer = DeleteLoadBalancerPolicyOperationSerializer()
            deserializer = DeleteLoadBalancerPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLoadBalancerPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
     *
     * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    override suspend fun deregisterInstancesFromLoadBalancer(input: DeregisterInstancesFromLoadBalancerRequest): DeregisterInstancesFromLoadBalancerResponse {
        val op = SdkHttpOperation.build<DeregisterInstancesFromLoadBalancerRequest, DeregisterInstancesFromLoadBalancerResponse> {
            serializer = DeregisterInstancesFromLoadBalancerOperationSerializer()
            deserializer = DeregisterInstancesFromLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterInstancesFromLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse {
        val op = SdkHttpOperation.build<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse> {
            serializer = DescribeAccountLimitsOperationSerializer()
            deserializer = DescribeAccountLimitsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountLimits"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
     */
    override suspend fun describeInstanceHealth(input: DescribeInstanceHealthRequest): DescribeInstanceHealthResponse {
        val op = SdkHttpOperation.build<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse> {
            serializer = DescribeInstanceHealthOperationSerializer()
            deserializer = DescribeInstanceHealthOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceHealth"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the attributes for the specified load balancer.
     */
    override suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse> {
            serializer = DescribeLoadBalancerAttributesOperationSerializer()
            deserializer = DescribeLoadBalancerAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoadBalancerAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified policies.
     * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer.
     * If you specify a policy name associated with your load balancer, the action returns the description of that policy.
     * If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies.
     * The names of the sample policies have the ELBSample- prefix.
     */
    override suspend fun describeLoadBalancerPolicies(input: DescribeLoadBalancerPoliciesRequest): DescribeLoadBalancerPoliciesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerPoliciesRequest, DescribeLoadBalancerPoliciesResponse> {
            serializer = DescribeLoadBalancerPoliciesOperationSerializer()
            deserializer = DescribeLoadBalancerPoliciesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoadBalancerPolicies"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified load balancer policy types or all load balancer policy types.
     * The description of each type indicates how it can be used. For example,
     * some policies can be used only with layer 7 listeners,
     * some policies can be used only with layer 4 listeners,
     * and some policies can be used only with your EC2 instances.
     * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types.
     * Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or
     * SetLoadBalancerPoliciesForBackendServer to set the policy.
     */
    override suspend fun describeLoadBalancerPolicyTypes(input: DescribeLoadBalancerPolicyTypesRequest): DescribeLoadBalancerPolicyTypesResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancerPolicyTypesRequest, DescribeLoadBalancerPolicyTypesResponse> {
            serializer = DescribeLoadBalancerPolicyTypesOperationSerializer()
            deserializer = DescribeLoadBalancerPolicyTypesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoadBalancerPolicyTypes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
     */
    override suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest): DescribeLoadBalancersResponse {
        val op = SdkHttpOperation.build<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse> {
            serializer = DescribeLoadBalancersOperationSerializer()
            deserializer = DescribeLoadBalancersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLoadBalancers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the tags associated with the specified load balancers.
     */
    override suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse {
        val op = SdkHttpOperation.build<DescribeTagsRequest, DescribeTagsResponse> {
            serializer = DescribeTagsOperationSerializer()
            deserializer = DescribeTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified subnets from the set of configured subnets for the load balancer.
     * After a subnet is removed, all EC2 instances registered with the load balancer
     * in the removed subnet go into the OutOfService state. Then,
     * the load balancer balances the traffic among the remaining routable subnets.
     */
    override suspend fun detachLoadBalancerFromSubnets(input: DetachLoadBalancerFromSubnetsRequest): DetachLoadBalancerFromSubnetsResponse {
        val op = SdkHttpOperation.build<DetachLoadBalancerFromSubnetsRequest, DetachLoadBalancerFromSubnetsResponse> {
            serializer = DetachLoadBalancerFromSubnetsOperationSerializer()
            deserializer = DetachLoadBalancerFromSubnetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachLoadBalancerFromSubnets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
     * There must be at least one Availability Zone registered with a load balancer at all times.
     * After an Availability Zone is removed, all instances registered with the load balancer that are in the removed
     * Availability Zone go into the OutOfService state. Then, the load balancer attempts to equally balance
     * the traffic among its remaining Availability Zones.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    override suspend fun disableAvailabilityZonesForLoadBalancer(input: DisableAvailabilityZonesForLoadBalancerRequest): DisableAvailabilityZonesForLoadBalancerResponse {
        val op = SdkHttpOperation.build<DisableAvailabilityZonesForLoadBalancerRequest, DisableAvailabilityZonesForLoadBalancerResponse> {
            serializer = DisableAvailabilityZonesForLoadBalancerOperationSerializer()
            deserializer = DisableAvailabilityZonesForLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableAvailabilityZonesForLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
     * The load balancer evenly distributes requests across all its registered Availability Zones
     * that contain instances. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    override suspend fun enableAvailabilityZonesForLoadBalancer(input: EnableAvailabilityZonesForLoadBalancerRequest): EnableAvailabilityZonesForLoadBalancerResponse {
        val op = SdkHttpOperation.build<EnableAvailabilityZonesForLoadBalancerRequest, EnableAvailabilityZonesForLoadBalancerResponse> {
            serializer = EnableAvailabilityZonesForLoadBalancerOperationSerializer()
            deserializer = EnableAvailabilityZonesForLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableAvailabilityZonesForLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Modifies the attributes of the specified load balancer.
     * You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining, and
     * CrossZoneLoadBalancing by either enabling or disabling them. Or, you can modify the load balancer attribute
     * ConnectionSettings by specifying an idle connection timeout value for your load balancer.
     * For more information, see the following in the Classic Load Balancers Guide:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Cross-Zone Load Balancing
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Connection Draining
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html">Access Logs
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Idle Connection Timeout
     */
    override suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse {
        val op = SdkHttpOperation.build<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse> {
            serializer = ModifyLoadBalancerAttributesOperationSerializer()
            deserializer = ModifyLoadBalancerAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ModifyLoadBalancerAttributes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds the specified instances to the specified load balancer.
     *
     * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
     *
     * Note that RegisterInstanceWithLoadBalancer completes when the request has been registered.
     * Instance registration takes a little time to complete. To check the state of the registered instances, use
     * DescribeLoadBalancers or DescribeInstanceHealth.
     *
     * After the instance is registered, it starts receiving traffic
     * and requests from the load balancer. Any instance that is not
     * in one of the Availability Zones registered for the load balancer
     * is moved to the OutOfService state. If an Availability Zone
     * is added to the load balancer later, any instances registered with the
     * load balancer move to the InService state.
     *
     * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    override suspend fun registerInstancesWithLoadBalancer(input: RegisterInstancesWithLoadBalancerRequest): RegisterInstancesWithLoadBalancerResponse {
        val op = SdkHttpOperation.build<RegisterInstancesWithLoadBalancerRequest, RegisterInstancesWithLoadBalancerResponse> {
            serializer = RegisterInstancesWithLoadBalancerOperationSerializer()
            deserializer = RegisterInstancesWithLoadBalancerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterInstancesWithLoadBalancer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from the specified load balancer.
     */
    override suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse {
        val op = SdkHttpOperation.build<RemoveTagsRequest, RemoveTagsResponse> {
            serializer = RemoveTagsOperationSerializer()
            deserializer = RemoveTagsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveTags"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
     *
     * For more information about updating your SSL certificate, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html">Replace the SSL Certificate for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    override suspend fun setLoadBalancerListenerSslCertificate(input: SetLoadBalancerListenerSslCertificateRequest): SetLoadBalancerListenerSslCertificateResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerListenerSslCertificateRequest, SetLoadBalancerListenerSslCertificateResponse> {
            serializer = SetLoadBalancerListenerSSLCertificateOperationSerializer()
            deserializer = SetLoadBalancerListenerSSLCertificateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLoadBalancerListenerSSLCertificate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies.
     * At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
     * Each time you use SetLoadBalancerPoliciesForBackendServer to enable the policies,
     * use the PolicyNames parameter to list the policies that you want to enable.
     * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy
     * is associated with the EC2 instance.
     *
     * For more information about enabling back-end instance authentication, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt">Configure Back-end Instance Authentication
     * in the Classic Load Balancers Guide. For more information about Proxy Protocol, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html">Configure Proxy Protocol Support
     * in the Classic Load Balancers Guide.
     */
    override suspend fun setLoadBalancerPoliciesForBackendServer(input: SetLoadBalancerPoliciesForBackendServerRequest): SetLoadBalancerPoliciesForBackendServerResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerPoliciesForBackendServerRequest, SetLoadBalancerPoliciesForBackendServerResponse> {
            serializer = SetLoadBalancerPoliciesForBackendServerOperationSerializer()
            deserializer = SetLoadBalancerPoliciesForBackendServerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLoadBalancerPoliciesForBackendServer"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
     * For more information about setting policies, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html">Update the SSL Negotiation Configuration,
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness, and
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    override suspend fun setLoadBalancerPoliciesOfListener(input: SetLoadBalancerPoliciesOfListenerRequest): SetLoadBalancerPoliciesOfListenerResponse {
        val op = SdkHttpOperation.build<SetLoadBalancerPoliciesOfListenerRequest, SetLoadBalancerPoliciesOfListenerResponse> {
            serializer = SetLoadBalancerPoliciesOfListenerOperationSerializer()
            deserializer = SetLoadBalancerPoliciesOfListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SetLoadBalancerPoliciesOfListener"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(Retry(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(
            MutateHeaders().apply {
                setIfMissing("Content-Type", "application/x-www-form-urlencoded")
            }
        )
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(
            AwsSigV4SigningMiddleware{
                this.credentialsProvider = config.credentialsProvider
                this.signingService = "elasticloadbalancing"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
