// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticloadbalancing.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elasticloadbalancing.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * <fullname>Elastic Load Balancing</fullname>
 *
 * A load balancer can distribute incoming traffic across your EC2 instances.
 * This enables you to increase the availability of your application. The load balancer
 * also monitors the health of its registered instances and ensures that it routes traffic
 * only to healthy instances. You configure your load balancer to accept incoming traffic
 * by specifying one or more listeners, which are configured with a protocol and port
 * number for connections from clients to the load balancer and a protocol and port number
 * for connections from the load balancer to the instances.
 * Elastic Load Balancing supports three types of load balancers: Application Load Balancers, Network Load Balancers,
 * and Classic Load Balancers. You can select a load balancer based on your application needs. For more
 * information, see the <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/">Elastic Load Balancing User Guide.
 * This reference covers the 2012-06-01 API, which supports Classic Load Balancers.
 * The 2015-12-01 API supports Application Load Balancers and Network Load Balancers.
 *
 * To get started, create a load balancer with one or more listeners using CreateLoadBalancer.
 * Register your instances with the load balancer using RegisterInstancesWithLoadBalancer.
 *
 * All Elastic Load Balancing operations are idempotent, which means
 * that they complete at most one time. If you repeat an operation, it succeeds with a 200 OK
 * response code.
 */
interface ElasticLoadBalancingClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Load Balancing"
    /**
     * ElasticLoadBalancingClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ElasticLoadBalancingClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticLoadBalancingClient(config)
        }

        operator fun invoke(config: Config): ElasticLoadBalancingClient = DefaultElasticLoadBalancingClient(config)

        /**
         * Construct a [ElasticLoadBalancingClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticLoadBalancingClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultElasticLoadBalancingClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated
     * with the load balancer, AddTags updates its value.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated
     * with the load balancer, AddTags updates its value.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html">Tag Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC
     * in the Classic Load Balancers Guide.
     */
    suspend fun applySecurityGroupsToLoadBalancer(input: ApplySecurityGroupsToLoadBalancerRequest): ApplySecurityGroupsToLoadBalancerResponse

    /**
     * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups">Security Groups for Load Balancers in a VPC
     * in the Classic Load Balancers Guide.
     */
    suspend fun applySecurityGroupsToLoadBalancer(block: ApplySecurityGroupsToLoadBalancerRequest.Builder.() -> Unit) = applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Adds one or more subnets to the set of configured subnets for the specified load balancer.
     * The load balancer evenly distributes requests across all registered subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC
     * in the Classic Load Balancers Guide.
     */
    suspend fun attachLoadBalancerToSubnets(input: AttachLoadBalancerToSubnetsRequest): AttachLoadBalancerToSubnetsResponse

    /**
     * Adds one or more subnets to the set of configured subnets for the specified load balancer.
     * The load balancer evenly distributes requests across all registered subnets.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html">Add or Remove Subnets for Your Load Balancer in a VPC
     * in the Classic Load Balancers Guide.
     */
    suspend fun attachLoadBalancerToSubnets(block: AttachLoadBalancerToSubnetsRequest.Builder.() -> Unit) = attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest.Builder().apply(block).build())

    /**
     * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html">Configure Health Checks for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun configureHealthCheck(input: ConfigureHealthCheckRequest): ConfigureHealthCheckResponse

    /**
     * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html">Configure Health Checks for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun configureHealthCheck(block: ConfigureHealthCheckRequest.Builder.() -> Unit) = configureHealthCheck(ConfigureHealthCheckRequest.Builder().apply(block).build())

    /**
     * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
     * This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
     * except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
     * follows the lifetime of the application-generated cookie specified in the policy configuration.
     * The load balancer only inserts a new stickiness cookie when the application response
     * includes a new application cookie.
     * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun createAppCookieStickinessPolicy(input: CreateAppCookieStickinessPolicyRequest): CreateAppCookieStickinessPolicyResponse

    /**
     * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
     * This policy is similar to the policy created by CreateLBCookieStickinessPolicy,
     * except that the lifetime of the special Elastic Load Balancing cookie, AWSELB,
     * follows the lifetime of the application-generated cookie specified in the policy configuration.
     * The load balancer only inserts a new stickiness cookie when the application response
     * includes a new application cookie.
     * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun createAppCookieStickinessPolicy(block: CreateAppCookieStickinessPolicyRequest.Builder.() -> Unit) = createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest.Builder().apply(block).build())

    /**
     * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
     * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request.
     * If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
     * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLbCookieStickinessPolicy(input: CreateLbCookieStickinessPolicyRequest): CreateLbCookieStickinessPolicyResponse

    /**
     * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
     * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request.
     * If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
     * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLbCookieStickinessPolicy(block: CreateLbCookieStickinessPolicyRequest.Builder.() -> Unit) = createLbCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest.Builder().apply(block).build())

    /**
     * Creates a Classic Load Balancer.
     *
     * You can add listeners, security groups, subnets, and tags when you create your load balancer,
     * or you can add them later using CreateLoadBalancerListeners,
     * ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets,
     * and AddTags.
     * To describe your current load balancers, see DescribeLoadBalancers.
     * When you are finished with a load balancer, you can delete it using
     * DeleteLoadBalancer.
     *
     * You can create up to 20 load balancers per region per account.
     * You can request an increase for the number of load balancers for your account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse

    /**
     * Creates a Classic Load Balancer.
     *
     * You can add listeners, security groups, subnets, and tags when you create your load balancer,
     * or you can add them later using CreateLoadBalancerListeners,
     * ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets,
     * and AddTags.
     * To describe your current load balancers, see DescribeLoadBalancers.
     * When you are finished with a load balancer, you can delete it using
     * DeleteLoadBalancer.
     *
     * You can create up to 20 load balancers per region per account.
     * You can request an increase for the number of load balancers for your account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLoadBalancer(block: CreateLoadBalancerRequest.Builder.() -> Unit) = createLoadBalancer(CreateLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLoadBalancerListeners(input: CreateLoadBalancerListenersRequest): CreateLoadBalancerListenersResponse

    /**
     * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html">Listeners for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun createLoadBalancerListeners(block: CreateLoadBalancerListenersRequest.Builder.() -> Unit) = createLoadBalancerListeners(CreateLoadBalancerListenersRequest.Builder().apply(block).build())

    /**
     * Creates a policy with the specified attributes for the specified load balancer.
     * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
     */
    suspend fun createLoadBalancerPolicy(input: CreateLoadBalancerPolicyRequest): CreateLoadBalancerPolicyResponse

    /**
     * Creates a policy with the specified attributes for the specified load balancer.
     * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
     */
    suspend fun createLoadBalancerPolicy(block: CreateLoadBalancerPolicyRequest.Builder.() -> Unit) = createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest.Builder().apply(block).build())

    /**
     * Deletes the specified load balancer.
     * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
     * If the load balancer does not exist or has already been deleted, the call to
     * DeleteLoadBalancer still succeeds.
     */
    suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse

    /**
     * Deletes the specified load balancer.
     * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
     * If the load balancer does not exist or has already been deleted, the call to
     * DeleteLoadBalancer still succeeds.
     */
    suspend fun deleteLoadBalancer(block: DeleteLoadBalancerRequest.Builder.() -> Unit) = deleteLoadBalancer(DeleteLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Deletes the specified listeners from the specified load balancer.
     */
    suspend fun deleteLoadBalancerListeners(input: DeleteLoadBalancerListenersRequest): DeleteLoadBalancerListenersResponse

    /**
     * Deletes the specified listeners from the specified load balancer.
     */
    suspend fun deleteLoadBalancerListeners(block: DeleteLoadBalancerListenersRequest.Builder.() -> Unit) = deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest.Builder().apply(block).build())

    /**
     * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     */
    suspend fun deleteLoadBalancerPolicy(input: DeleteLoadBalancerPolicyRequest): DeleteLoadBalancerPolicyResponse

    /**
     * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     */
    suspend fun deleteLoadBalancerPolicy(block: DeleteLoadBalancerPolicyRequest.Builder.() -> Unit) = deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest.Builder().apply(block).build())

    /**
     * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
     *
     * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    suspend fun deregisterInstancesFromLoadBalancer(input: DeregisterInstancesFromLoadBalancerRequest): DeregisterInstancesFromLoadBalancerResponse

    /**
     * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
     *
     * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    suspend fun deregisterInstancesFromLoadBalancer(block: DeregisterInstancesFromLoadBalancerRequest.Builder.() -> Unit) = deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest): DescribeAccountLimitsResponse

    /**
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html">Limits for Your Classic Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun describeAccountLimits(block: DescribeAccountLimitsRequest.Builder.() -> Unit) = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

    /**
     * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
     */
    suspend fun describeInstanceHealth(input: DescribeInstanceHealthRequest): DescribeInstanceHealthResponse

    /**
     * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
     */
    suspend fun describeInstanceHealth(block: DescribeInstanceHealthRequest.Builder.() -> Unit) = describeInstanceHealth(DescribeInstanceHealthRequest.Builder().apply(block).build())

    /**
     * Describes the attributes for the specified load balancer.
     */
    suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse

    /**
     * Describes the attributes for the specified load balancer.
     */
    suspend fun describeLoadBalancerAttributes(block: DescribeLoadBalancerAttributesRequest.Builder.() -> Unit) = describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.Builder().apply(block).build())

    /**
     * Describes the specified policies.
     * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer.
     * If you specify a policy name associated with your load balancer, the action returns the description of that policy.
     * If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies.
     * The names of the sample policies have the ELBSample- prefix.
     */
    suspend fun describeLoadBalancerPolicies(input: DescribeLoadBalancerPoliciesRequest): DescribeLoadBalancerPoliciesResponse

    /**
     * Describes the specified policies.
     * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer.
     * If you specify a policy name associated with your load balancer, the action returns the description of that policy.
     * If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies.
     * The names of the sample policies have the ELBSample- prefix.
     */
    suspend fun describeLoadBalancerPolicies(block: DescribeLoadBalancerPoliciesRequest.Builder.() -> Unit) = describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest.Builder().apply(block).build())

    /**
     * Describes the specified load balancer policy types or all load balancer policy types.
     * The description of each type indicates how it can be used. For example,
     * some policies can be used only with layer 7 listeners,
     * some policies can be used only with layer 4 listeners,
     * and some policies can be used only with your EC2 instances.
     * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types.
     * Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or
     * SetLoadBalancerPoliciesForBackendServer to set the policy.
     */
    suspend fun describeLoadBalancerPolicyTypes(input: DescribeLoadBalancerPolicyTypesRequest): DescribeLoadBalancerPolicyTypesResponse

    /**
     * Describes the specified load balancer policy types or all load balancer policy types.
     * The description of each type indicates how it can be used. For example,
     * some policies can be used only with layer 7 listeners,
     * some policies can be used only with layer 4 listeners,
     * and some policies can be used only with your EC2 instances.
     * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types.
     * Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or
     * SetLoadBalancerPoliciesForBackendServer to set the policy.
     */
    suspend fun describeLoadBalancerPolicyTypes(block: DescribeLoadBalancerPolicyTypesRequest.Builder.() -> Unit) = describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest.Builder().apply(block).build())

    /**
     * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
     */
    suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest): DescribeLoadBalancersResponse

    /**
     * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
     */
    suspend fun describeLoadBalancers(block: DescribeLoadBalancersRequest.Builder.() -> Unit) = describeLoadBalancers(DescribeLoadBalancersRequest.Builder().apply(block).build())

    /**
     * Describes the tags associated with the specified load balancers.
     */
    suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the tags associated with the specified load balancers.
     */
    suspend fun describeTags(block: DescribeTagsRequest.Builder.() -> Unit) = describeTags(DescribeTagsRequest.Builder().apply(block).build())

    /**
     * Removes the specified subnets from the set of configured subnets for the load balancer.
     * After a subnet is removed, all EC2 instances registered with the load balancer
     * in the removed subnet go into the OutOfService state. Then,
     * the load balancer balances the traffic among the remaining routable subnets.
     */
    suspend fun detachLoadBalancerFromSubnets(input: DetachLoadBalancerFromSubnetsRequest): DetachLoadBalancerFromSubnetsResponse

    /**
     * Removes the specified subnets from the set of configured subnets for the load balancer.
     * After a subnet is removed, all EC2 instances registered with the load balancer
     * in the removed subnet go into the OutOfService state. Then,
     * the load balancer balances the traffic among the remaining routable subnets.
     */
    suspend fun detachLoadBalancerFromSubnets(block: DetachLoadBalancerFromSubnetsRequest.Builder.() -> Unit) = detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest.Builder().apply(block).build())

    /**
     * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
     * There must be at least one Availability Zone registered with a load balancer at all times.
     * After an Availability Zone is removed, all instances registered with the load balancer that are in the removed
     * Availability Zone go into the OutOfService state. Then, the load balancer attempts to equally balance
     * the traffic among its remaining Availability Zones.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    suspend fun disableAvailabilityZonesForLoadBalancer(input: DisableAvailabilityZonesForLoadBalancerRequest): DisableAvailabilityZonesForLoadBalancerResponse

    /**
     * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
     * There must be at least one Availability Zone registered with a load balancer at all times.
     * After an Availability Zone is removed, all instances registered with the load balancer that are in the removed
     * Availability Zone go into the OutOfService state. Then, the load balancer attempts to equally balance
     * the traffic among its remaining Availability Zones.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    suspend fun disableAvailabilityZonesForLoadBalancer(block: DisableAvailabilityZonesForLoadBalancerRequest.Builder.() -> Unit) = disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
     * The load balancer evenly distributes requests across all its registered Availability Zones
     * that contain instances. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    suspend fun enableAvailabilityZonesForLoadBalancer(input: EnableAvailabilityZonesForLoadBalancerRequest): EnableAvailabilityZonesForLoadBalancerResponse

    /**
     * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer
     * in EC2-Classic or a default VPC.
     * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
     * The load balancer evenly distributes requests across all its registered Availability Zones
     * that contain instances. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html">Add or Remove Availability Zones
     * in the Classic Load Balancers Guide.
     */
    suspend fun enableAvailabilityZonesForLoadBalancer(block: EnableAvailabilityZonesForLoadBalancerRequest.Builder.() -> Unit) = enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Modifies the attributes of the specified load balancer.
     * You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining, and
     * CrossZoneLoadBalancing by either enabling or disabling them. Or, you can modify the load balancer attribute
     * ConnectionSettings by specifying an idle connection timeout value for your load balancer.
     * For more information, see the following in the Classic Load Balancers Guide:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Cross-Zone Load Balancing
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Connection Draining
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html">Access Logs
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Idle Connection Timeout
     */
    suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse

    /**
     * Modifies the attributes of the specified load balancer.
     * You can modify the load balancer attributes, such as AccessLogs, ConnectionDraining, and
     * CrossZoneLoadBalancing by either enabling or disabling them. Or, you can modify the load balancer attribute
     * ConnectionSettings by specifying an idle connection timeout value for your load balancer.
     * For more information, see the following in the Classic Load Balancers Guide:
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Cross-Zone Load Balancing
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Connection Draining
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html">Access Logs
     *
     *
     *
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Idle Connection Timeout
     */
    suspend fun modifyLoadBalancerAttributes(block: ModifyLoadBalancerAttributesRequest.Builder.() -> Unit) = modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.Builder().apply(block).build())

    /**
     * Adds the specified instances to the specified load balancer.
     *
     * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
     *
     * Note that RegisterInstanceWithLoadBalancer completes when the request has been registered.
     * Instance registration takes a little time to complete. To check the state of the registered instances, use
     * DescribeLoadBalancers or DescribeInstanceHealth.
     *
     * After the instance is registered, it starts receiving traffic
     * and requests from the load balancer. Any instance that is not
     * in one of the Availability Zones registered for the load balancer
     * is moved to the OutOfService state. If an Availability Zone
     * is added to the load balancer later, any instances registered with the
     * load balancer move to the InService state.
     *
     * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    suspend fun registerInstancesWithLoadBalancer(input: RegisterInstancesWithLoadBalancerRequest): RegisterInstancesWithLoadBalancerResponse

    /**
     * Adds the specified instances to the specified load balancer.
     *
     * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
     *
     * Note that RegisterInstanceWithLoadBalancer completes when the request has been registered.
     * Instance registration takes a little time to complete. To check the state of the registered instances, use
     * DescribeLoadBalancers or DescribeInstanceHealth.
     *
     * After the instance is registered, it starts receiving traffic
     * and requests from the load balancer. Any instance that is not
     * in one of the Availability Zones registered for the load balancer
     * is moved to the OutOfService state. If an Availability Zone
     * is added to the load balancer later, any instances registered with the
     * load balancer move to the InService state.
     *
     * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
     *
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html">Register or De-Register EC2 Instances
     * in the Classic Load Balancers Guide.
     */
    suspend fun registerInstancesWithLoadBalancer(block: RegisterInstancesWithLoadBalancerRequest.Builder.() -> Unit) = registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest.Builder().apply(block).build())

    /**
     * Removes one or more tags from the specified load balancer.
     */
    suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes one or more tags from the specified load balancer.
     */
    suspend fun removeTags(block: RemoveTagsRequest.Builder.() -> Unit) = removeTags(RemoveTagsRequest.Builder().apply(block).build())

    /**
     * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
     *
     * For more information about updating your SSL certificate, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html">Replace the SSL Certificate for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerListenerSslCertificate(input: SetLoadBalancerListenerSslCertificateRequest): SetLoadBalancerListenerSslCertificateResponse

    /**
     * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
     *
     * For more information about updating your SSL certificate, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html">Replace the SSL Certificate for Your Load Balancer
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerListenerSslCertificate(block: SetLoadBalancerListenerSslCertificateRequest.Builder.() -> Unit) = setLoadBalancerListenerSslCertificate(SetLoadBalancerListenerSslCertificateRequest.Builder().apply(block).build())

    /**
     * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies.
     * At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
     * Each time you use SetLoadBalancerPoliciesForBackendServer to enable the policies,
     * use the PolicyNames parameter to list the policies that you want to enable.
     * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy
     * is associated with the EC2 instance.
     *
     * For more information about enabling back-end instance authentication, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt">Configure Back-end Instance Authentication
     * in the Classic Load Balancers Guide. For more information about Proxy Protocol, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html">Configure Proxy Protocol Support
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerPoliciesForBackendServer(input: SetLoadBalancerPoliciesForBackendServerRequest): SetLoadBalancerPoliciesForBackendServerResponse

    /**
     * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies.
     * At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
     * Each time you use SetLoadBalancerPoliciesForBackendServer to enable the policies,
     * use the PolicyNames parameter to list the policies that you want to enable.
     * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy
     * is associated with the EC2 instance.
     *
     * For more information about enabling back-end instance authentication, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt">Configure Back-end Instance Authentication
     * in the Classic Load Balancers Guide. For more information about Proxy Protocol, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html">Configure Proxy Protocol Support
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerPoliciesForBackendServer(block: SetLoadBalancerPoliciesForBackendServerRequest.Builder.() -> Unit) = setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest.Builder().apply(block).build())

    /**
     * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
     * For more information about setting policies, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html">Update the SSL Negotiation Configuration,
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness, and
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerPoliciesOfListener(input: SetLoadBalancerPoliciesOfListenerRequest): SetLoadBalancerPoliciesOfListenerResponse

    /**
     * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
     * For more information about setting policies, see
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html">Update the SSL Negotiation Configuration,
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration">Duration-Based Session Stickiness, and
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application">Application-Controlled Session Stickiness
     * in the Classic Load Balancers Guide.
     */
    suspend fun setLoadBalancerPoliciesOfListener(block: SetLoadBalancerPoliciesOfListenerRequest.Builder.() -> Unit) = setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest.Builder().apply(block).build())
}
