// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.model



/**
 * The attributes for a load balancer.
 */
class LoadBalancerAttributes private constructor(builder: Builder) {
    /**
     * If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs
     * in the Classic Load Balancers Guide.
     */
    val accessLog: aws.sdk.kotlin.services.elasticloadbalancing.model.AccessLog? = builder.accessLog
    /**
     * Any additional attributes.
     */
    val additionalAttributes: List<AdditionalAttribute>? = builder.additionalAttributes
    /**
     * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining
     * in the Classic Load Balancers Guide.
     */
    val connectionDraining: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionDraining? = builder.connectionDraining
    /**
     * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.
     * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout
     * in the Classic Load Balancers Guide.
     */
    val connectionSettings: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionSettings? = builder.connectionSettings
    /**
     * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing
     * in the Classic Load Balancers Guide.
     */
    val crossZoneLoadBalancing: aws.sdk.kotlin.services.elasticloadbalancing.model.CrossZoneLoadBalancing? = builder.crossZoneLoadBalancing

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerAttributes = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancerAttributes(")
        append("accessLog=$accessLog,")
        append("additionalAttributes=$additionalAttributes,")
        append("connectionDraining=$connectionDraining,")
        append("connectionSettings=$connectionSettings,")
        append("crossZoneLoadBalancing=$crossZoneLoadBalancing)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessLog?.hashCode() ?: 0
        result = 31 * result + (additionalAttributes?.hashCode() ?: 0)
        result = 31 * result + (connectionDraining?.hashCode() ?: 0)
        result = 31 * result + (connectionSettings?.hashCode() ?: 0)
        result = 31 * result + (crossZoneLoadBalancing?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancerAttributes

        if (accessLog != other.accessLog) return false
        if (additionalAttributes != other.additionalAttributes) return false
        if (connectionDraining != other.connectionDraining) return false
        if (connectionSettings != other.connectionSettings) return false
        if (crossZoneLoadBalancing != other.crossZoneLoadBalancing) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerAttributes = Builder(this).apply(block).build()

    class Builder {
        /**
         * If enabled, the load balancer captures detailed information of all requests and delivers the information to the Amazon S3 bucket that you specify.
         * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-access-logs.html">Enable Access Logs
         * in the Classic Load Balancers Guide.
         */
        var accessLog: aws.sdk.kotlin.services.elasticloadbalancing.model.AccessLog? = null
        /**
         * Any additional attributes.
         */
        var additionalAttributes: List<AdditionalAttribute>? = null
        /**
         * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.
         * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining
         * in the Classic Load Balancers Guide.
         */
        var connectionDraining: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionDraining? = null
        /**
         * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.
         * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer.
         * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout
         * in the Classic Load Balancers Guide.
         */
        var connectionSettings: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionSettings? = null
        /**
         * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
         * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing
         * in the Classic Load Balancers Guide.
         */
        var crossZoneLoadBalancing: aws.sdk.kotlin.services.elasticloadbalancing.model.CrossZoneLoadBalancing? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerAttributes) : this() {
            this.accessLog = x.accessLog
            this.additionalAttributes = x.additionalAttributes
            this.connectionDraining = x.connectionDraining
            this.connectionSettings = x.connectionSettings
            this.crossZoneLoadBalancing = x.crossZoneLoadBalancing
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerAttributes = LoadBalancerAttributes(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.AccessLog] inside the given [block]
         */
        fun accessLog(block: aws.sdk.kotlin.services.elasticloadbalancing.model.AccessLog.Builder.() -> kotlin.Unit) {
            this.accessLog = aws.sdk.kotlin.services.elasticloadbalancing.model.AccessLog.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionDraining] inside the given [block]
         */
        fun connectionDraining(block: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionDraining.Builder.() -> kotlin.Unit) {
            this.connectionDraining = aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionDraining.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionSettings] inside the given [block]
         */
        fun connectionSettings(block: aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionSettings.Builder.() -> kotlin.Unit) {
            this.connectionSettings = aws.sdk.kotlin.services.elasticloadbalancing.model.ConnectionSettings.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancing.model.CrossZoneLoadBalancing] inside the given [block]
         */
        fun crossZoneLoadBalancing(block: aws.sdk.kotlin.services.elasticloadbalancing.model.CrossZoneLoadBalancing.Builder.() -> kotlin.Unit) {
            this.crossZoneLoadBalancing = aws.sdk.kotlin.services.elasticloadbalancing.model.CrossZoneLoadBalancing.invoke(block)
        }
    }
}
