// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.waiters

import aws.sdk.kotlin.services.elasticloadbalancing.ElasticLoadBalancingClient
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds
import kotlin.time.Duration.Companion.seconds


suspend fun ElasticLoadBalancingClient.waitUntilAnyInstanceInService(request: DescribeInstanceHealthRequest): Outcome<DescribeInstanceHealthResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxTime = 300.seconds, maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeInstanceHealthRequest, DescribeInstanceHealthResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val instanceStates = it?.instanceStates
            val instanceStatesOrEmpty = instanceStates?.flattenIfPossible() ?: listOf()
            val projection = instanceStatesOrEmpty.flatMap {
                val state = it?.state
                listOfNotNull(state)
            }
            projection?.any { it?.toString() == "InService" } ?: false
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeInstanceHealth(request) }
}

suspend fun ElasticLoadBalancingClient.waitUntilAnyInstanceInService(block: DescribeInstanceHealthRequest.Builder.() -> Unit): Outcome<DescribeInstanceHealthResponse> =
    waitUntilAnyInstanceInService(DescribeInstanceHealthRequest.Builder().apply(block).build())
