// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.paginators

import aws.sdk.kotlin.services.elasticloadbalancing.ElasticLoadBalancingClient
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerDescription
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeLoadBalancersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingClient.describeLoadBalancersPaginated(initialRequest: DescribeLoadBalancersRequest): Flow<DescribeLoadBalancersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.marker = cursor
            }
            val result = this@describeLoadBalancersPaginated.describeLoadBalancers(req)
            isFirstPage = false
            cursor = result.nextMarker
            emit(result)
        }
    }

/**
 * Paginate over [DescribeLoadBalancersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeLoadBalancersResponse]
 */
public fun ElasticLoadBalancingClient.describeLoadBalancersPaginated(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Flow<DescribeLoadBalancersResponse> =
    describeLoadBalancersPaginated(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeLoadBalancersPaginated]
 * to access the nested member [LoadBalancerDescription]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [LoadBalancerDescription]
 */
@JvmName("describeLoadBalancersResponseLoadBalancerDescription")
public fun Flow<DescribeLoadBalancersResponse>.loadBalancerDescriptions(): Flow<LoadBalancerDescription> =
    transform() { response ->
        response.loadBalancerDescriptions?.forEach {
            emit(it)
        }
    }
