// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.InstanceState
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeInstanceHealthOperationDeserializer: HttpDeserialize<DescribeInstanceHealthResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInstanceHealthResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInstanceHealthError(context, response)
        }
        val builder = DescribeInstanceHealthResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInstanceHealthOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeInstanceHealthError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstance" -> InvalidEndPointExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeInstanceHealthOperationBody(builder: DescribeInstanceHealthResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeInstanceHealthResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeInstanceHealthResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeInstanceHealth response")
    }
    // end unwrap response wrapper

    val INSTANCESTATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("InstanceStates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2012-06-01/"))
        trait(XmlSerialName("DescribeInstanceHealthResult"))
        field(INSTANCESTATES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INSTANCESTATES_DESCRIPTOR.index -> builder.instanceStates =
                    deserializer.deserializeList(INSTANCESTATES_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
