// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.sdk.kotlin.services.elasticloadbalancing.model.LoadBalancerAttributes
import aws.sdk.kotlin.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class ModifyLoadBalancerAttributesOperationDeserializer: HttpDeserialize<ModifyLoadBalancerAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyLoadBalancerAttributesResponse {
        if (!response.status.isSuccess()) {
            throwModifyLoadBalancerAttributesError(context, response)
        }
        val builder = ModifyLoadBalancerAttributesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyLoadBalancerAttributesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyLoadBalancerAttributesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "LoadBalancerNotFound" -> AccessPointNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "LoadBalancerAttributeNotFound" -> LoadBalancerAttributeNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyLoadBalancerAttributesOperationBody(builder: ModifyLoadBalancerAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyLoadBalancerAttributesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyLoadBalancerAttributesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyLoadBalancerAttributes response")
    }
    // end unwrap response wrapper

    val LOADBALANCERATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("LoadBalancerAttributes"))
    val LOADBALANCERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("LoadBalancerName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2012-06-01/"))
        trait(XmlSerialName("ModifyLoadBalancerAttributesResult"))
        field(LOADBALANCERATTRIBUTES_DESCRIPTOR)
        field(LOADBALANCERNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LOADBALANCERATTRIBUTES_DESCRIPTOR.index -> builder.loadBalancerAttributes = deserializeLoadBalancerAttributesDocument(deserializer)
                LOADBALANCERNAME_DESCRIPTOR.index -> builder.loadBalancerName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
