// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticloadbalancing.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elasticloadbalancing.model.*
import aws.sdk.kotlin.services.elasticloadbalancing.model.AddTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.AddTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ConfigureHealthCheckRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.ConfigureHealthCheckResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeleteLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeInstanceHealthResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DescribeTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.RemoveTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.RemoveTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # Elastic Load Balancing
 * A load balancer can distribute incoming traffic across your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered instances and ensures that it routes traffic only to healthy instances. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer and a protocol and port number for connections from the load balancer to the instances.
 *
 * Elastic Load Balancing supports three types of load balancers: Application Load Balancers, Network Load Balancers, and Classic Load Balancers. You can select a load balancer based on your application needs. For more information, see the [Elastic Load Balancing User Guide](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/).
 *
 * This reference covers the 2012-06-01 API, which supports Classic Load Balancers. The 2015-12-01 API supports Application Load Balancers and Network Load Balancers.
 *
 * To get started, create a load balancer with one or more listeners using CreateLoadBalancer. Register your instances with the load balancer using RegisterInstancesWithLoadBalancer.
 *
 * All Elastic Load Balancing operations are *idempotent*, which means that they complete at most one time. If you repeat an operation, it succeeds with a 200 OK response code.
 */
public interface ElasticLoadBalancingClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Load Balancing"
    /**
     * ElasticLoadBalancingClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ElasticLoadBalancingClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticLoadBalancingClient(config)
        }

        public operator fun invoke(config: Config): ElasticLoadBalancingClient = DefaultElasticLoadBalancingClient(config)

        /**
         * Construct a [ElasticLoadBalancingClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticLoadBalancingClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultElasticLoadBalancingClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
     *
     * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, `AddTags` updates its value.
     *
     * For more information, see [Tag Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
     *
     * For more information, see [Security Groups for Load Balancers in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups) in the *Classic Load Balancers Guide*.
     */
    public suspend fun applySecurityGroupsToLoadBalancer(input: ApplySecurityGroupsToLoadBalancerRequest): ApplySecurityGroupsToLoadBalancerResponse

    /**
     * Adds one or more subnets to the set of configured subnets for the specified load balancer.
     *
     * The load balancer evenly distributes requests across all registered subnets. For more information, see [Add or Remove Subnets for Your Load Balancer in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun attachLoadBalancerToSubnets(input: AttachLoadBalancerToSubnetsRequest): AttachLoadBalancerToSubnetsResponse

    /**
     * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
     *
     * For more information, see [Configure Health Checks for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun configureHealthCheck(input: ConfigureHealthCheckRequest): ConfigureHealthCheckResponse

    /**
     * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
     *
     * This policy is similar to the policy created by CreateLBCookieStickinessPolicy, except that the lifetime of the special Elastic Load Balancing cookie, `AWSELB`, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.
     *
     * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
     *
     * For more information, see [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
     */
    public suspend fun createAppCookieStickinessPolicy(input: CreateAppCookieStickinessPolicyRequest): CreateAppCookieStickinessPolicyResponse

    /**
     * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
     *
     * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
     *
     * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
     *
     * For more information, see [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration) in the *Classic Load Balancers Guide*.
     */
    public suspend fun createLbCookieStickinessPolicy(input: CreateLbCookieStickinessPolicyRequest): CreateLbCookieStickinessPolicyResponse

    /**
     * Creates a Classic Load Balancer.
     *
     * You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets, and AddTags.
     *
     * To describe your current load balancers, see DescribeLoadBalancers. When you are finished with a load balancer, you can delete it using DeleteLoadBalancer.
     *
     * You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse

    /**
     * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
     *
     * For more information, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun createLoadBalancerListeners(input: CreateLoadBalancerListenersRequest): CreateLoadBalancerListenersResponse

    /**
     * Creates a policy with the specified attributes for the specified load balancer.
     *
     * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
     */
    public suspend fun createLoadBalancerPolicy(input: CreateLoadBalancerPolicyRequest): CreateLoadBalancerPolicyResponse

    /**
     * Deletes the specified load balancer.
     *
     * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
     *
     * If the load balancer does not exist or has already been deleted, the call to `DeleteLoadBalancer` still succeeds.
     */
    public suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse

    /**
     * Deletes the specified listeners from the specified load balancer.
     */
    public suspend fun deleteLoadBalancerListeners(input: DeleteLoadBalancerListenersRequest): DeleteLoadBalancerListenersResponse

    /**
     * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
     */
    public suspend fun deleteLoadBalancerPolicy(input: DeleteLoadBalancerPolicyRequest): DeleteLoadBalancerPolicyResponse

    /**
     * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
     *
     * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
     *
     * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun deregisterInstancesFromLoadBalancer(input: DeregisterInstancesFromLoadBalancerRequest): DeregisterInstancesFromLoadBalancerResponse

    /**
     * Describes the current Elastic Load Balancing resource limits for your AWS account.
     *
     * For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest {}): DescribeAccountLimitsResponse

    /**
     * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
     */
    public suspend fun describeInstanceHealth(input: DescribeInstanceHealthRequest): DescribeInstanceHealthResponse

    /**
     * Describes the attributes for the specified load balancer.
     */
    public suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse

    /**
     * Describes the specified policies.
     *
     * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the `ELBSample-` prefix.
     */
    public suspend fun describeLoadBalancerPolicies(input: DescribeLoadBalancerPoliciesRequest = DescribeLoadBalancerPoliciesRequest {}): DescribeLoadBalancerPoliciesResponse

    /**
     * Describes the specified load balancer policy types or all load balancer policy types.
     *
     * The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances.
     *
     * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types. Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or SetLoadBalancerPoliciesForBackendServer to set the policy.
     */
    public suspend fun describeLoadBalancerPolicyTypes(input: DescribeLoadBalancerPolicyTypesRequest = DescribeLoadBalancerPolicyTypesRequest {}): DescribeLoadBalancerPolicyTypesResponse

    /**
     * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
     */
    public suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest = DescribeLoadBalancersRequest {}): DescribeLoadBalancersResponse

    /**
     * Describes the tags associated with the specified load balancers.
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Removes the specified subnets from the set of configured subnets for the load balancer.
     *
     * After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the `OutOfService` state. Then, the load balancer balances the traffic among the remaining routable subnets.
     */
    public suspend fun detachLoadBalancerFromSubnets(input: DetachLoadBalancerFromSubnetsRequest): DetachLoadBalancerFromSubnetsResponse

    /**
     * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
     *
     * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
     *
     * There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the `OutOfService` state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.
     *
     * For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun disableAvailabilityZonesForLoadBalancer(input: DisableAvailabilityZonesForLoadBalancerRequest): DisableAvailabilityZonesForLoadBalancerResponse

    /**
     * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
     *
     * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
     *
     * The load balancer evenly distributes requests across all its registered Availability Zones that contain instances. For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun enableAvailabilityZonesForLoadBalancer(input: EnableAvailabilityZonesForLoadBalancerRequest): EnableAvailabilityZonesForLoadBalancerResponse

    /**
     * Modifies the attributes of the specified load balancer.
     *
     * You can modify the load balancer attributes, such as `AccessLogs`, `ConnectionDraining`, and `CrossZoneLoadBalancing` by either enabling or disabling them. Or, you can modify the load balancer attribute `ConnectionSettings` by specifying an idle connection timeout value for your load balancer.
     *
     * For more information, see the following in the *Classic Load Balancers Guide*:
     * + [Cross-Zone Load Balancing](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html)
     * + [Connection Draining](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html)
     * + [Access Logs](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html)
     * + [Idle Connection Timeout](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html)
     */
    public suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse

    /**
     * Adds the specified instances to the specified load balancer.
     *
     * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
     *
     * Note that `RegisterInstanceWithLoadBalancer` completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use DescribeLoadBalancers or DescribeInstanceHealth.
     *
     * After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the `OutOfService` state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the `InService` state.
     *
     * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
     *
     * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun registerInstancesWithLoadBalancer(input: RegisterInstancesWithLoadBalancerRequest): RegisterInstancesWithLoadBalancerResponse

    /**
     * Removes one or more tags from the specified load balancer.
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
     *
     * For more information about updating your SSL certificate, see [Replace the SSL Certificate for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun setLoadBalancerListenerSslCertificate(input: SetLoadBalancerListenerSslCertificateRequest): SetLoadBalancerListenerSslCertificateResponse

    /**
     * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
     *
     * Each time you use `SetLoadBalancerPoliciesForBackendServer` to enable the policies, use the `PolicyNames` parameter to list the policies that you want to enable.
     *
     * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy is associated with the EC2 instance.
     *
     * For more information about enabling back-end instance authentication, see [Configure Back-end Instance Authentication](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt) in the *Classic Load Balancers Guide*. For more information about Proxy Protocol, see [Configure Proxy Protocol Support](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html) in the *Classic Load Balancers Guide*.
     */
    public suspend fun setLoadBalancerPoliciesForBackendServer(input: SetLoadBalancerPoliciesForBackendServerRequest): SetLoadBalancerPoliciesForBackendServerResponse

    /**
     * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
     *
     * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
     *
     * For more information about setting policies, see [Update the SSL Negotiation Configuration](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html), [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration), and [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
     */
    public suspend fun setLoadBalancerPoliciesOfListener(input: SetLoadBalancerPoliciesOfListenerRequest): SetLoadBalancerPoliciesOfListenerResponse
}

/**
 * Adds the specified tags to the specified load balancer. Each load balancer can have a maximum of 10 tags.
 *
 * Each tag consists of a key and an optional value. If a tag with the same key is already associated with the load balancer, `AddTags` updates its value.
 *
 * For more information, see [Tag Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Associates one or more security groups with your load balancer in a virtual private cloud (VPC). The specified security groups override the previously associated security groups.
 *
 * For more information, see [Security Groups for Load Balancers in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.applySecurityGroupsToLoadBalancer(crossinline block: ApplySecurityGroupsToLoadBalancerRequest.Builder.() -> Unit): ApplySecurityGroupsToLoadBalancerResponse = applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest.Builder().apply(block).build())

/**
 * Adds one or more subnets to the set of configured subnets for the specified load balancer.
 *
 * The load balancer evenly distributes requests across all registered subnets. For more information, see [Add or Remove Subnets for Your Load Balancer in a VPC](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-manage-subnets.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.attachLoadBalancerToSubnets(crossinline block: AttachLoadBalancerToSubnetsRequest.Builder.() -> Unit): AttachLoadBalancerToSubnetsResponse = attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest.Builder().apply(block).build())

/**
 * Specifies the health check settings to use when evaluating the health state of your EC2 instances.
 *
 * For more information, see [Configure Health Checks for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-healthchecks.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.configureHealthCheck(crossinline block: ConfigureHealthCheckRequest.Builder.() -> Unit): ConfigureHealthCheckResponse = configureHealthCheck(ConfigureHealthCheckRequest.Builder().apply(block).build())

/**
 * Generates a stickiness policy with sticky session lifetimes that follow that of an application-generated cookie. This policy can be associated only with HTTP/HTTPS listeners.
 *
 * This policy is similar to the policy created by CreateLBCookieStickinessPolicy, except that the lifetime of the special Elastic Load Balancing cookie, `AWSELB`, follows the lifetime of the application-generated cookie specified in the policy configuration. The load balancer only inserts a new stickiness cookie when the application response includes a new application cookie.
 *
 * If the application cookie is explicitly removed or expires, the session stops being sticky until a new application cookie is issued.
 *
 * For more information, see [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.createAppCookieStickinessPolicy(crossinline block: CreateAppCookieStickinessPolicyRequest.Builder.() -> Unit): CreateAppCookieStickinessPolicyResponse = createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest.Builder().apply(block).build())

/**
 * Generates a stickiness policy with sticky session lifetimes controlled by the lifetime of the browser (user-agent) or a specified expiration period. This policy can be associated only with HTTP/HTTPS listeners.
 *
 * When a load balancer implements this policy, the load balancer uses a special cookie to track the instance for each request. When the load balancer receives a request, it first checks to see if this cookie is present in the request. If so, the load balancer sends the request to the application server specified in the cookie. If not, the load balancer sends the request to a server that is chosen based on the existing load-balancing algorithm.
 *
 * A cookie is inserted into the response for binding subsequent requests from the same user to that server. The validity of the cookie is based on the cookie expiration time, which is specified in the policy configuration.
 *
 * For more information, see [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.createLbCookieStickinessPolicy(crossinline block: CreateLbCookieStickinessPolicyRequest.Builder.() -> Unit): CreateLbCookieStickinessPolicyResponse = createLbCookieStickinessPolicy(CreateLbCookieStickinessPolicyRequest.Builder().apply(block).build())

/**
 * Creates a Classic Load Balancer.
 *
 * You can add listeners, security groups, subnets, and tags when you create your load balancer, or you can add them later using CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer, AttachLoadBalancerToSubnets, and AddTags.
 *
 * To describe your current load balancers, see DescribeLoadBalancers. When you are finished with a load balancer, you can delete it using DeleteLoadBalancer.
 *
 * You can create up to 20 load balancers per region per account. You can request an increase for the number of load balancers for your account. For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.createLoadBalancer(crossinline block: CreateLoadBalancerRequest.Builder.() -> Unit): CreateLoadBalancerResponse = createLoadBalancer(CreateLoadBalancerRequest.Builder().apply(block).build())

/**
 * Creates one or more listeners for the specified load balancer. If a listener with the specified port does not already exist, it is created; otherwise, the properties of the new listener must match the properties of the existing listener.
 *
 * For more information, see [Listeners for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.createLoadBalancerListeners(crossinline block: CreateLoadBalancerListenersRequest.Builder.() -> Unit): CreateLoadBalancerListenersResponse = createLoadBalancerListeners(CreateLoadBalancerListenersRequest.Builder().apply(block).build())

/**
 * Creates a policy with the specified attributes for the specified load balancer.
 *
 * Policies are settings that are saved for your load balancer and that can be applied to the listener or the application server, depending on the policy type.
 */
public suspend inline fun ElasticLoadBalancingClient.createLoadBalancerPolicy(crossinline block: CreateLoadBalancerPolicyRequest.Builder.() -> Unit): CreateLoadBalancerPolicyResponse = createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest.Builder().apply(block).build())

/**
 * Deletes the specified load balancer.
 *
 * If you are attempting to recreate a load balancer, you must reconfigure all settings. The DNS name associated with a deleted load balancer are no longer usable. The name and associated DNS record of the deleted load balancer no longer exist and traffic sent to any of its IP addresses is no longer delivered to your instances.
 *
 * If the load balancer does not exist or has already been deleted, the call to `DeleteLoadBalancer` still succeeds.
 */
public suspend inline fun ElasticLoadBalancingClient.deleteLoadBalancer(crossinline block: DeleteLoadBalancerRequest.Builder.() -> Unit): DeleteLoadBalancerResponse = deleteLoadBalancer(DeleteLoadBalancerRequest.Builder().apply(block).build())

/**
 * Deletes the specified listeners from the specified load balancer.
 */
public suspend inline fun ElasticLoadBalancingClient.deleteLoadBalancerListeners(crossinline block: DeleteLoadBalancerListenersRequest.Builder.() -> Unit): DeleteLoadBalancerListenersResponse = deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest.Builder().apply(block).build())

/**
 * Deletes the specified policy from the specified load balancer. This policy must not be enabled for any listeners.
 */
public suspend inline fun ElasticLoadBalancingClient.deleteLoadBalancerPolicy(crossinline block: DeleteLoadBalancerPolicyRequest.Builder.() -> Unit): DeleteLoadBalancerPolicyResponse = deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest.Builder().apply(block).build())

/**
 * Deregisters the specified instances from the specified load balancer. After the instance is deregistered, it no longer receives traffic from the load balancer.
 *
 * You can use DescribeLoadBalancers to verify that the instance is deregistered from the load balancer.
 *
 * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.deregisterInstancesFromLoadBalancer(crossinline block: DeregisterInstancesFromLoadBalancerRequest.Builder.() -> Unit): DeregisterInstancesFromLoadBalancerResponse = deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest.Builder().apply(block).build())

/**
 * Describes the current Elastic Load Balancing resource limits for your AWS account.
 *
 * For more information, see [Limits for Your Classic Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Describes the state of the specified instances with respect to the specified load balancer. If no instances are specified, the call describes the state of all instances that are currently registered with the load balancer. If instances are specified, their state is returned even if they are no longer registered with the load balancer. The state of terminated instances is not returned.
 */
public suspend inline fun ElasticLoadBalancingClient.describeInstanceHealth(crossinline block: DescribeInstanceHealthRequest.Builder.() -> Unit): DescribeInstanceHealthResponse = describeInstanceHealth(DescribeInstanceHealthRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified load balancer.
 */
public suspend inline fun ElasticLoadBalancingClient.describeLoadBalancerAttributes(crossinline block: DescribeLoadBalancerAttributesRequest.Builder.() -> Unit): DescribeLoadBalancerAttributesResponse = describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Describes the specified policies.
 *
 * If you specify a load balancer name, the action returns the descriptions of all policies created for the load balancer. If you specify a policy name associated with your load balancer, the action returns the description of that policy. If you don't specify a load balancer name, the action returns descriptions of the specified sample policies, or descriptions of all sample policies. The names of the sample policies have the `ELBSample-` prefix.
 */
public suspend inline fun ElasticLoadBalancingClient.describeLoadBalancerPolicies(crossinline block: DescribeLoadBalancerPoliciesRequest.Builder.() -> Unit): DescribeLoadBalancerPoliciesResponse = describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest.Builder().apply(block).build())

/**
 * Describes the specified load balancer policy types or all load balancer policy types.
 *
 * The description of each type indicates how it can be used. For example, some policies can be used only with layer 7 listeners, some policies can be used only with layer 4 listeners, and some policies can be used only with your EC2 instances.
 *
 * You can use CreateLoadBalancerPolicy to create a policy configuration for any of these policy types. Then, depending on the policy type, use either SetLoadBalancerPoliciesOfListener or SetLoadBalancerPoliciesForBackendServer to set the policy.
 */
public suspend inline fun ElasticLoadBalancingClient.describeLoadBalancerPolicyTypes(crossinline block: DescribeLoadBalancerPolicyTypesRequest.Builder.() -> Unit): DescribeLoadBalancerPolicyTypesResponse = describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest.Builder().apply(block).build())

/**
 * Describes the specified the load balancers. If no load balancers are specified, the call describes all of your load balancers.
 */
public suspend inline fun ElasticLoadBalancingClient.describeLoadBalancers(crossinline block: DescribeLoadBalancersRequest.Builder.() -> Unit): DescribeLoadBalancersResponse = describeLoadBalancers(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * Describes the tags associated with the specified load balancers.
 */
public suspend inline fun ElasticLoadBalancingClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Removes the specified subnets from the set of configured subnets for the load balancer.
 *
 * After a subnet is removed, all EC2 instances registered with the load balancer in the removed subnet go into the `OutOfService` state. Then, the load balancer balances the traffic among the remaining routable subnets.
 */
public suspend inline fun ElasticLoadBalancingClient.detachLoadBalancerFromSubnets(crossinline block: DetachLoadBalancerFromSubnetsRequest.Builder.() -> Unit): DetachLoadBalancerFromSubnetsResponse = detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest.Builder().apply(block).build())

/**
 * Removes the specified Availability Zones from the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
 *
 * For load balancers in a non-default VPC, use DetachLoadBalancerFromSubnets.
 *
 * There must be at least one Availability Zone registered with a load balancer at all times. After an Availability Zone is removed, all instances registered with the load balancer that are in the removed Availability Zone go into the `OutOfService` state. Then, the load balancer attempts to equally balance the traffic among its remaining Availability Zones.
 *
 * For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.disableAvailabilityZonesForLoadBalancer(crossinline block: DisableAvailabilityZonesForLoadBalancerRequest.Builder.() -> Unit): DisableAvailabilityZonesForLoadBalancerResponse = disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest.Builder().apply(block).build())

/**
 * Adds the specified Availability Zones to the set of Availability Zones for the specified load balancer in EC2-Classic or a default VPC.
 *
 * For load balancers in a non-default VPC, use AttachLoadBalancerToSubnets.
 *
 * The load balancer evenly distributes requests across all its registered Availability Zones that contain instances. For more information, see [Add or Remove Availability Zones](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-az.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.enableAvailabilityZonesForLoadBalancer(crossinline block: EnableAvailabilityZonesForLoadBalancerRequest.Builder.() -> Unit): EnableAvailabilityZonesForLoadBalancerResponse = enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest.Builder().apply(block).build())

/**
 * Modifies the attributes of the specified load balancer.
 *
 * You can modify the load balancer attributes, such as `AccessLogs`, `ConnectionDraining`, and `CrossZoneLoadBalancing` by either enabling or disabling them. Or, you can modify the load balancer attribute `ConnectionSettings` by specifying an idle connection timeout value for your load balancer.
 *
 * For more information, see the following in the *Classic Load Balancers Guide*:
 * + [Cross-Zone Load Balancing](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html)
 * + [Connection Draining](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html)
 * + [Access Logs](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/access-log-collection.html)
 * + [Idle Connection Timeout](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html)
 */
public suspend inline fun ElasticLoadBalancingClient.modifyLoadBalancerAttributes(crossinline block: ModifyLoadBalancerAttributesRequest.Builder.() -> Unit): ModifyLoadBalancerAttributesResponse = modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Adds the specified instances to the specified load balancer.
 *
 * The instance must be a running instance in the same network as the load balancer (EC2-Classic or the same VPC). If you have EC2-Classic instances and a load balancer in a VPC with ClassicLink enabled, you can link the EC2-Classic instances to that VPC and then register the linked EC2-Classic instances with the load balancer in the VPC.
 *
 * Note that `RegisterInstanceWithLoadBalancer` completes when the request has been registered. Instance registration takes a little time to complete. To check the state of the registered instances, use DescribeLoadBalancers or DescribeInstanceHealth.
 *
 * After the instance is registered, it starts receiving traffic and requests from the load balancer. Any instance that is not in one of the Availability Zones registered for the load balancer is moved to the `OutOfService` state. If an Availability Zone is added to the load balancer later, any instances registered with the load balancer move to the `InService` state.
 *
 * To deregister instances from a load balancer, use DeregisterInstancesFromLoadBalancer.
 *
 * For more information, see [Register or De-Register EC2 Instances](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-deregister-register-instances.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.registerInstancesWithLoadBalancer(crossinline block: RegisterInstancesWithLoadBalancerRequest.Builder.() -> Unit): RegisterInstancesWithLoadBalancerResponse = registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from the specified load balancer.
 */
public suspend inline fun ElasticLoadBalancingClient.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Sets the certificate that terminates the specified listener's SSL connections. The specified certificate replaces any prior certificate that was used on the same load balancer and port.
 *
 * For more information about updating your SSL certificate, see [Replace the SSL Certificate for Your Load Balancer](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-update-ssl-cert.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.setLoadBalancerListenerSslCertificate(crossinline block: SetLoadBalancerListenerSslCertificateRequest.Builder.() -> Unit): SetLoadBalancerListenerSslCertificateResponse = setLoadBalancerListenerSslCertificate(SetLoadBalancerListenerSslCertificateRequest.Builder().apply(block).build())

/**
 * Replaces the set of policies associated with the specified port on which the EC2 instance is listening with a new set of policies. At this time, only the back-end server authentication policy type can be applied to the instance ports; this policy type is composed of multiple public key policies.
 *
 * Each time you use `SetLoadBalancerPoliciesForBackendServer` to enable the policies, use the `PolicyNames` parameter to list the policies that you want to enable.
 *
 * You can use DescribeLoadBalancers or DescribeLoadBalancerPolicies to verify that the policy is associated with the EC2 instance.
 *
 * For more information about enabling back-end instance authentication, see [Configure Back-end Instance Authentication](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-create-https-ssl-load-balancer.html#configure_backendauth_clt) in the *Classic Load Balancers Guide*. For more information about Proxy Protocol, see [Configure Proxy Protocol Support](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-proxy-protocol.html) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.setLoadBalancerPoliciesForBackendServer(crossinline block: SetLoadBalancerPoliciesForBackendServerRequest.Builder.() -> Unit): SetLoadBalancerPoliciesForBackendServerResponse = setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest.Builder().apply(block).build())

/**
 * Replaces the current set of policies for the specified load balancer port with the specified set of policies.
 *
 * To enable back-end server authentication, use SetLoadBalancerPoliciesForBackendServer.
 *
 * For more information about setting policies, see [Update the SSL Negotiation Configuration](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/ssl-config-update.html), [Duration-Based Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-duration), and [Application-Controlled Session Stickiness](https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-sticky-sessions.html#enable-sticky-sessions-application) in the *Classic Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingClient.setLoadBalancerPoliciesOfListener(crossinline block: SetLoadBalancerPoliciesOfListenerRequest.Builder.() -> Unit): SetLoadBalancerPoliciesOfListenerResponse = setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest.Builder().apply(block).build())
