// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancing.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancing.model.ElasticLoadBalancingException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class CreateLoadBalancerOperationDeserializer: HttpDeserialize<CreateLoadBalancerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateLoadBalancerResponse {
        if (!response.status.isSuccess()) {
            throwCreateLoadBalancerError(context, response)
        }
        val builder = CreateLoadBalancerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateLoadBalancerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateLoadBalancerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateLoadBalancerName" -> DuplicateAccessPointNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateTagKeys" -> DuplicateTagKeysExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidScheme" -> InvalidSchemeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSecurityGroup" -> InvalidSecurityGroupExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetExceptionDeserializer().deserialize(context, wrappedResponse)
        "OperationNotPermitted" -> OperationNotPermittedExceptionDeserializer().deserialize(context, wrappedResponse)
        "SubnetNotFound" -> SubnetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyLoadBalancers" -> TooManyAccessPointsExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTags" -> TooManyTagsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateLoadBalancerOperationBody(builder: CreateLoadBalancerResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("CreateLoadBalancerResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("CreateLoadBalancerResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap CreateLoadBalancer response")
    }
    // end unwrap response wrapper

    val DNSNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("DNSName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2012-06-01/"))
        trait(XmlSerialName("CreateLoadBalancerResult"))
        field(DNSNAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DNSNAME_DESCRIPTOR.index -> builder.dnsName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
