// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.endpoints.EndpointProvider
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.*
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AddTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeregisterTargetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DeregisterTargetsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeListenersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyRuleRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyRuleResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RegisterTargetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RegisterTargetsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTagsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.RemoveTagsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * # Elastic Load Balancing
 * A load balancer distributes incoming traffic across targets, such as your EC2 instances. This enables you to increase the availability of your application. The load balancer also monitors the health of its registered targets and ensures that it routes traffic only to healthy targets. You configure your load balancer to accept incoming traffic by specifying one or more listeners, which are configured with a protocol and port number for connections from clients to the load balancer. You configure a target group with a protocol and port number for connections from the load balancer to the targets, and with health check settings to be used when checking the health status of the targets.
 *
 * Elastic Load Balancing supports the following types of load balancers: Application Load Balancers, Network Load Balancers, Gateway Load Balancers, and Classic Load Balancers. This reference covers the following load balancer types:
 * + Application Load Balancer - Operates at the application layer (layer 7) and supports HTTP and HTTPS.
 * + Network Load Balancer - Operates at the transport layer (layer 4) and supports TCP, TLS, and UDP.
 * + Gateway Load Balancer - Operates at the network layer (layer 3).
 *
 * For more information, see the [Elastic Load Balancing User Guide](https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/).
 *
 * All Elastic Load Balancing operations are idempotent, which means that they complete at most one time. If you repeat an operation, it succeeds.
 */
public interface ElasticLoadBalancingV2Client : SdkClient {

    override val serviceName: String
        get() = "Elastic Load Balancing v2"
    /**
     * ElasticLoadBalancingV2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ElasticLoadBalancingV2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticLoadBalancingV2Client(config)
        }

        public operator fun invoke(config: Config): ElasticLoadBalancingV2Client = DefaultElasticLoadBalancingV2Client(config)

        /**
         * Construct a [ElasticLoadBalancingV2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticLoadBalancingV2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultElasticLoadBalancingV2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Elastic Load Balancing v2")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     *
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added again.
     *
     * For more information, see [HTTPS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html) in the *Application Load Balancers Guide* or [TLS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html) in the *Network Load Balancers Guide*.
     */
    public suspend fun addListenerCertificates(input: AddListenerCertificatesRequest): AddListenerCertificatesResponse

    /**
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.
     *
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, `AddTags` updates its value.
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Listeners for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
     * + [Listeners for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html)
     * + [Listeners for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.
     */
    public suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse

    /**
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
     * + [Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
     * + [Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.
     */
    public suspend fun createLoadBalancer(input: CreateLoadBalancerRequest): CreateLoadBalancerResponse

    /**
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     *
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see [Listener rules](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules) in the *Application Load Balancers Guide*.
     */
    public suspend fun createRule(input: CreateRuleRequest): CreateRuleResponse

    /**
     * Creates a target group.
     *
     * For more information, see the following:
     * + [Target groups for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
     * + [Target groups for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html)
     * + [Target groups for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html)
     *
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.
     */
    public suspend fun createTargetGroup(input: CreateTargetGroupRequest): CreateTargetGroupResponse

    /**
     * Deletes the specified listener.
     *
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     */
    public suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse

    /**
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
     *
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.
     *
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.
     */
    public suspend fun deleteLoadBalancer(input: DeleteLoadBalancerRequest): DeleteLoadBalancerResponse

    /**
     * Deletes the specified rule.
     *
     * You can't delete the default rule.
     */
    public suspend fun deleteRule(input: DeleteRuleRequest): DeleteRuleResponse

    /**
     * Deletes the specified target group.
     *
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.
     */
    public suspend fun deleteTargetGroup(input: DeleteTargetGroupRequest): DeleteTargetGroupResponse

    /**
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
     */
    public suspend fun deregisterTargets(input: DeregisterTargetsRequest): DeregisterTargetsResponse

    /**
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     *
     * For more information, see the following:
     * + [Quotas for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
     * + [Quotas for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
     * + [Quotas for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html)
     */
    public suspend fun describeAccountLimits(input: DescribeAccountLimitsRequest = DescribeAccountLimitsRequest {}): DescribeAccountLimitsResponse

    /**
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     *
     * If the default certificate is also in the certificate list, it appears twice in the results (once with `IsDefault` set to true and once with `IsDefault` set to false).
     *
     * For more information, see [SSL certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates) in the *Application Load Balancers Guide* or [Server certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate) in the *Network Load Balancers Guide*.
     */
    public suspend fun describeListenerCertificates(input: DescribeListenerCertificatesRequest): DescribeListenerCertificatesResponse

    /**
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     */
    public suspend fun describeListeners(input: DescribeListenersRequest = DescribeListenersRequest {}): DescribeListenersResponse

    /**
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * For more information, see the following:
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes) in the *Application Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes) in the *Network Load Balancers Guide*
     * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes) in the *Gateway Load Balancers Guide*
     */
    public suspend fun describeLoadBalancerAttributes(input: DescribeLoadBalancerAttributesRequest): DescribeLoadBalancerAttributesResponse

    /**
     * Describes the specified load balancers or all of your load balancers.
     */
    public suspend fun describeLoadBalancers(input: DescribeLoadBalancersRequest = DescribeLoadBalancersRequest {}): DescribeLoadBalancersResponse

    /**
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
     */
    public suspend fun describeRules(input: DescribeRulesRequest = DescribeRulesRequest {}): DescribeRulesResponse

    /**
     * Describes the specified policies or all policies used for SSL negotiation.
     *
     * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
     */
    public suspend fun describeSslPolicies(input: DescribeSslPoliciesRequest = DescribeSslPoliciesRequest {}): DescribeSslPoliciesResponse

    /**
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Describes the attributes for the specified target group.
     *
     * For more information, see the following:
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes) in the *Application Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes) in the *Network Load Balancers Guide*
     * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes) in the *Gateway Load Balancers Guide*
     */
    public suspend fun describeTargetGroupAttributes(input: DescribeTargetGroupAttributesRequest): DescribeTargetGroupAttributesResponse

    /**
     * Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
     */
    public suspend fun describeTargetGroups(input: DescribeTargetGroupsRequest = DescribeTargetGroupsRequest {}): DescribeTargetGroupsResponse

    /**
     * Describes the health of the specified targets or all of your targets.
     */
    public suspend fun describeTargetHealth(input: DescribeTargetHealthRequest): DescribeTargetHealthResponse

    /**
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
     *
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     */
    public suspend fun modifyListener(input: ModifyListenerRequest): ModifyListenerResponse

    /**
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     *
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.
     */
    public suspend fun modifyLoadBalancerAttributes(input: ModifyLoadBalancerAttributesRequest): ModifyLoadBalancerAttributesResponse

    /**
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     *
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
     */
    public suspend fun modifyRule(input: ModifyRuleRequest): ModifyRuleResponse

    /**
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     */
    public suspend fun modifyTargetGroup(input: ModifyTargetGroupRequest): ModifyTargetGroupResponse

    /**
     * Modifies the specified attributes of the specified target group.
     */
    public suspend fun modifyTargetGroupAttributes(input: ModifyTargetGroupAttributesRequest): ModifyTargetGroupAttributesResponse

    /**
     * Registers the specified targets with the specified target group.
     *
     * If the target is an EC2 instance, it must be in the `running` state when you register it.
     *
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.
     *
     * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.
     */
    public suspend fun registerTargets(input: RegisterTargetsRequest): RegisterTargetsResponse

    /**
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     */
    public suspend fun removeListenerCertificates(input: RemoveListenerCertificatesRequest): RemoveListenerCertificatesResponse

    /**
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     */
    public suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     */
    public suspend fun setIpAddressType(input: SetIpAddressTypeRequest): SetIpAddressTypeResponse

    /**
     * Sets the priorities of the specified rules.
     *
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.
     */
    public suspend fun setRulePriorities(input: SetRulePrioritiesRequest): SetRulePrioritiesResponse

    /**
     * Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups.
     *
     * You can't specify a security group for a Network Load Balancer or Gateway Load Balancer.
     */
    public suspend fun setSecurityGroups(input: SetSecurityGroupsRequest): SetSecurityGroupsResponse

    /**
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets.
     *
     * When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.
     */
    public suspend fun setSubnets(input: SetSubnetsRequest): SetSubnetsResponse
}

/**
 * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
 *
 * If the certificate in already in the certificate list, the call is successful but the certificate is not added again.
 *
 * For more information, see [HTTPS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html) in the *Application Load Balancers Guide* or [TLS listeners](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html) in the *Network Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.addListenerCertificates(crossinline block: AddListenerCertificatesRequest.Builder.() -> Unit): AddListenerCertificatesResponse = addListenerCertificates(AddListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, and rules.
 *
 * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, `AddTags` updates its value.
 */
public suspend inline fun ElasticLoadBalancingV2Client.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Listeners for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html)
 * + [Listeners for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html)
 * + [Listeners for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple listeners with the same settings, each call succeeds.
 */
public suspend inline fun ElasticLoadBalancingV2Client.createListener(crossinline block: CreateListenerRequest.Builder.() -> Unit): CreateListenerResponse = createListener(CreateListenerRequest.Builder().apply(block).build())

/**
 * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html)
 * + [Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html)
 * + [Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple load balancers with the same settings, each call succeeds.
 */
public suspend inline fun ElasticLoadBalancingV2Client.createLoadBalancer(crossinline block: CreateLoadBalancerRequest.Builder.() -> Unit): CreateLoadBalancerResponse = createLoadBalancer(CreateLoadBalancerRequest.Builder().apply(block).build())

/**
 * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
 *
 * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more information, see [Listener rules](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules) in the *Application Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.createRule(crossinline block: CreateRuleRequest.Builder.() -> Unit): CreateRuleResponse = createRule(CreateRuleRequest.Builder().apply(block).build())

/**
 * Creates a target group.
 *
 * For more information, see the following:
 * + [Target groups for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html)
 * + [Target groups for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html)
 * + [Target groups for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html)
 *
 * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple target groups with the same settings, each call succeeds.
 */
public suspend inline fun ElasticLoadBalancingV2Client.createTargetGroup(crossinline block: CreateTargetGroupRequest.Builder.() -> Unit): CreateTargetGroupResponse = createTargetGroup(CreateTargetGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified listener.
 *
 * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteListener(crossinline block: DeleteListenerRequest.Builder.() -> Unit): DeleteListenerResponse = deleteListener(DeleteListenerRequest.Builder().apply(block).build())

/**
 * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load balancer also deletes its listeners.
 *
 * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has already been deleted, the call succeeds.
 *
 * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or terminate them.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteLoadBalancer(crossinline block: DeleteLoadBalancerRequest.Builder.() -> Unit): DeleteLoadBalancerResponse = deleteLoadBalancer(DeleteLoadBalancerRequest.Builder().apply(block).build())

/**
 * Deletes the specified rule.
 *
 * You can't delete the default rule.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteRule(crossinline block: DeleteRuleRequest.Builder.() -> Unit): DeleteRuleResponse = deleteRule(DeleteRuleRequest.Builder().apply(block).build())

/**
 * Deletes the specified target group.
 *
 * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2 instances continue to run until you stop or terminate them.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deleteTargetGroup(crossinline block: DeleteTargetGroupRequest.Builder.() -> Unit): DeleteTargetGroupResponse = deleteTargetGroup(DeleteTargetGroupRequest.Builder().apply(block).build())

/**
 * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no longer receive traffic from the load balancer.
 */
public suspend inline fun ElasticLoadBalancingV2Client.deregisterTargets(crossinline block: DeregisterTargetsRequest.Builder.() -> Unit): DeregisterTargetsResponse = deregisterTargets(DeregisterTargetsRequest.Builder().apply(block).build())

/**
 * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
 *
 * For more information, see the following:
 * + [Quotas for your Application Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html)
 * + [Quotas for your Network Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html)
 * + [Quotas for your Gateway Load Balancers](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html)
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeAccountLimits(crossinline block: DescribeAccountLimitsRequest.Builder.() -> Unit): DescribeAccountLimitsResponse = describeAccountLimits(DescribeAccountLimitsRequest.Builder().apply(block).build())

/**
 * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
 *
 * If the default certificate is also in the certificate list, it appears twice in the results (once with `IsDefault` set to true and once with `IsDefault` set to false).
 *
 * For more information, see [SSL certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates) in the *Application Load Balancers Guide* or [Server certificates](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate) in the *Network Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeListenerCertificates(crossinline block: DescribeListenerCertificatesRequest.Builder.() -> Unit): DescribeListenerCertificatesResponse = describeListenerCertificates(DescribeListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeListeners(crossinline block: DescribeListenersRequest.Builder.() -> Unit): DescribeListenersResponse = describeListeners(DescribeListenersRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * For more information, see the following:
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes) in the *Application Load Balancers Guide*
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes) in the *Network Load Balancers Guide*
 * + [Load balancer attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes) in the *Gateway Load Balancers Guide*
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeLoadBalancerAttributes(crossinline block: DescribeLoadBalancerAttributesRequest.Builder.() -> Unit): DescribeLoadBalancerAttributesResponse = describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Describes the specified load balancers or all of your load balancers.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeLoadBalancers(crossinline block: DescribeLoadBalancersRequest.Builder.() -> Unit): DescribeLoadBalancersResponse = describeLoadBalancers(DescribeLoadBalancersRequest.Builder().apply(block).build())

/**
 * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one or more rules.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeRules(crossinline block: DescribeRulesRequest.Builder.() -> Unit): DescribeRulesResponse = describeRules(DescribeRulesRequest.Builder().apply(block).build())

/**
 * Describes the specified policies or all policies used for SSL negotiation.
 *
 * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeSslPolicies(crossinline block: DescribeSslPoliciesRequest.Builder.() -> Unit): DescribeSslPoliciesResponse = describeSslPolicies(DescribeSslPoliciesRequest.Builder().apply(block).build())

/**
 * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Describes the attributes for the specified target group.
 *
 * For more information, see the following:
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes) in the *Application Load Balancers Guide*
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes) in the *Network Load Balancers Guide*
 * + [Target group attributes](https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes) in the *Gateway Load Balancers Guide*
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetGroupAttributes(crossinline block: DescribeTargetGroupAttributesRequest.Builder.() -> Unit): DescribeTargetGroupAttributesResponse = describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest.Builder().apply(block).build())

/**
 * Describes the specified target groups or all of your target groups. By default, all target groups are described. Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the names of one or more target groups, or the ARNs of one or more target groups.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetGroups(crossinline block: DescribeTargetGroupsRequest.Builder.() -> Unit): DescribeTargetGroupsResponse = describeTargetGroups(DescribeTargetGroupsRequest.Builder().apply(block).build())

/**
 * Describes the health of the specified targets or all of your targets.
 */
public suspend inline fun ElasticLoadBalancingV2Client.describeTargetHealth(crossinline block: DescribeTargetHealthRequest.Builder.() -> Unit): DescribeTargetHealthResponse = describeTargetHealth(DescribeTargetHealthRequest.Builder().apply(block).build())

/**
 * Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.
 *
 * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy and default certificate properties.
 *
 * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyListener(crossinline block: ModifyListenerRequest.Builder.() -> Unit): ModifyListenerResponse = modifyListener(ModifyListenerRequest.Builder().apply(block).build())

/**
 * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
 *
 * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that you do not modify retain their current values.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyLoadBalancerAttributes(crossinline block: ModifyLoadBalancerAttributesRequest.Builder.() -> Unit): ModifyLoadBalancerAttributesResponse = modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest.Builder().apply(block).build())

/**
 * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
 *
 * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire list. For example, to add an action, specify a list with the current actions plus the new action.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyRule(crossinline block: ModifyRuleRequest.Builder.() -> Unit): ModifyRuleResponse = modifyRule(ModifyRuleRequest.Builder().apply(block).build())

/**
 * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyTargetGroup(crossinline block: ModifyTargetGroupRequest.Builder.() -> Unit): ModifyTargetGroupResponse = modifyTargetGroup(ModifyTargetGroupRequest.Builder().apply(block).build())

/**
 * Modifies the specified attributes of the specified target group.
 */
public suspend inline fun ElasticLoadBalancingV2Client.modifyTargetGroupAttributes(crossinline block: ModifyTargetGroupAttributesRequest.Builder.() -> Unit): ModifyTargetGroupAttributesResponse = modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest.Builder().apply(block).build())

/**
 * Registers the specified targets with the specified target group.
 *
 * If the target is an EC2 instance, it must be in the `running` state when you register it.
 *
 * By default, the load balancer routes requests to registered targets using the protocol and port for the target group. Alternatively, you can override the port for a target when you register it. You can register each EC2 instance or IP address with the same target group multiple times using different ports.
 *
 * With a Network Load Balancer, you cannot register instances by instance ID if they have the following instance types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of these types by IP address.
 */
public suspend inline fun ElasticLoadBalancingV2Client.registerTargets(crossinline block: RegisterTargetsRequest.Builder.() -> Unit): RegisterTargetsResponse = registerTargets(RegisterTargetsRequest.Builder().apply(block).build())

/**
 * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
 */
public suspend inline fun ElasticLoadBalancingV2Client.removeListenerCertificates(crossinline block: RemoveListenerCertificatesRequest.Builder.() -> Unit): RemoveListenerCertificatesResponse = removeListenerCertificates(RemoveListenerCertificatesRequest.Builder().apply(block).build())

/**
 * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
 */
public suspend inline fun ElasticLoadBalancingV2Client.removeTags(crossinline block: RemoveTagsRequest.Builder.() -> Unit): RemoveTagsResponse = removeTags(RemoveTagsRequest.Builder().apply(block).build())

/**
 * Sets the type of IP addresses used by the subnets of the specified load balancer.
 */
public suspend inline fun ElasticLoadBalancingV2Client.setIpAddressType(crossinline block: SetIpAddressTypeRequest.Builder.() -> Unit): SetIpAddressTypeResponse = setIpAddressType(SetIpAddressTypeRequest.Builder().apply(block).build())

/**
 * Sets the priorities of the specified rules.
 *
 * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that you do not specify retain their current priority.
 */
public suspend inline fun ElasticLoadBalancingV2Client.setRulePriorities(crossinline block: SetRulePrioritiesRequest.Builder.() -> Unit): SetRulePrioritiesResponse = setRulePriorities(SetRulePrioritiesRequest.Builder().apply(block).build())

/**
 * Associates the specified security groups with the specified Application Load Balancer. The specified security groups override the previously associated security groups.
 *
 * You can't specify a security group for a Network Load Balancer or Gateway Load Balancer.
 */
public suspend inline fun ElasticLoadBalancingV2Client.setSecurityGroups(crossinline block: SetSecurityGroupsRequest.Builder.() -> Unit): SetSecurityGroupsResponse = setSecurityGroups(SetSecurityGroupsRequest.Builder().apply(block).build())

/**
 * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer or Network Load Balancer. The specified subnets replace the previously enabled subnets.
 *
 * When you specify subnets for a Network Load Balancer, you must include all subnets that were enabled previously, with their existing configurations, plus any additional subnets.
 */
public suspend inline fun ElasticLoadBalancingV2Client.setSubnets(crossinline block: SetSubnetsRequest.Builder.() -> Unit): SetSubnetsResponse = setSubnets(SetSubnetsRequest.Builder().apply(block).build())
