// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about an action.
 *
 * Each rule must include exactly one of the following types of actions: `forward`, `fixed-response`, or `redirect`, and it must be the last action to be performed.
 */
public class Action private constructor(builder: Builder) {
    /**
     * &#91;HTTPS listeners&#93; Information for using Amazon Cognito to authenticate users. Specify only when `Type` is `authenticate-cognito`.
     */
    public val authenticateCognitoConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig? = builder.authenticateCognitoConfig
    /**
     * &#91;HTTPS listeners&#93; Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `Type` is `authenticate-oidc`.
     */
    public val authenticateOidcConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig? = builder.authenticateOidcConfig
    /**
     * &#91;Application Load Balancer&#93; Information for creating an action that returns a custom HTTP response. Specify only when `Type` is `fixed-response`.
     */
    public val fixedResponseConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.FixedResponseActionConfig? = builder.fixedResponseConfig
    /**
     * Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when `Type` is `forward`. If you specify both `ForwardConfig` and `TargetGroupArn`, you can specify only one target group using `ForwardConfig` and it must be the same target group specified in `TargetGroupArn`.
     */
    public val forwardConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ForwardActionConfig? = builder.forwardConfig
    /**
     * The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
     */
    public val order: kotlin.Int? = builder.order
    /**
     * &#91;Application Load Balancer&#93; Information for creating a redirect action. Specify only when `Type` is `redirect`.
     */
    public val redirectConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig? = builder.redirectConfig
    /**
     * The Amazon Resource Name (ARN) of the target group. Specify only when `Type` is `forward` and you want to route to a single target group. To route to one or more target groups, use `ForwardConfig` instead.
     */
    public val targetGroupArn: kotlin.String? = builder.targetGroupArn
    /**
     * The type of action.
     */
    public val type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ActionTypeEnum? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Action = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Action(")
        append("authenticateCognitoConfig=$authenticateCognitoConfig,")
        append("authenticateOidcConfig=$authenticateOidcConfig,")
        append("fixedResponseConfig=$fixedResponseConfig,")
        append("forwardConfig=$forwardConfig,")
        append("order=$order,")
        append("redirectConfig=$redirectConfig,")
        append("targetGroupArn=$targetGroupArn,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticateCognitoConfig?.hashCode() ?: 0
        result = 31 * result + (authenticateOidcConfig?.hashCode() ?: 0)
        result = 31 * result + (fixedResponseConfig?.hashCode() ?: 0)
        result = 31 * result + (forwardConfig?.hashCode() ?: 0)
        result = 31 * result + (order ?: 0)
        result = 31 * result + (redirectConfig?.hashCode() ?: 0)
        result = 31 * result + (targetGroupArn?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Action

        if (authenticateCognitoConfig != other.authenticateCognitoConfig) return false
        if (authenticateOidcConfig != other.authenticateOidcConfig) return false
        if (fixedResponseConfig != other.fixedResponseConfig) return false
        if (forwardConfig != other.forwardConfig) return false
        if (order != other.order) return false
        if (redirectConfig != other.redirectConfig) return false
        if (targetGroupArn != other.targetGroupArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Action = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;HTTPS listeners&#93; Information for using Amazon Cognito to authenticate users. Specify only when `Type` is `authenticate-cognito`.
         */
        public var authenticateCognitoConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig? = null
        /**
         * &#91;HTTPS listeners&#93; Information about an identity provider that is compliant with OpenID Connect (OIDC). Specify only when `Type` is `authenticate-oidc`.
         */
        public var authenticateOidcConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig? = null
        /**
         * &#91;Application Load Balancer&#93; Information for creating an action that returns a custom HTTP response. Specify only when `Type` is `fixed-response`.
         */
        public var fixedResponseConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.FixedResponseActionConfig? = null
        /**
         * Information for creating an action that distributes requests among one or more target groups. For Network Load Balancers, you can specify a single target group. Specify only when `Type` is `forward`. If you specify both `ForwardConfig` and `TargetGroupArn`, you can specify only one target group using `ForwardConfig` and it must be the same target group specified in `TargetGroupArn`.
         */
        public var forwardConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ForwardActionConfig? = null
        /**
         * The order for the action. This value is required for rules with multiple actions. The action with the lowest value for order is performed first.
         */
        public var order: kotlin.Int? = null
        /**
         * &#91;Application Load Balancer&#93; Information for creating a redirect action. Specify only when `Type` is `redirect`.
         */
        public var redirectConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the target group. Specify only when `Type` is `forward` and you want to route to a single target group. To route to one or more target groups, use `ForwardConfig` instead.
         */
        public var targetGroupArn: kotlin.String? = null
        /**
         * The type of action.
         */
        public var type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ActionTypeEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Action) : this() {
            this.authenticateCognitoConfig = x.authenticateCognitoConfig
            this.authenticateOidcConfig = x.authenticateOidcConfig
            this.fixedResponseConfig = x.fixedResponseConfig
            this.forwardConfig = x.forwardConfig
            this.order = x.order
            this.redirectConfig = x.redirectConfig
            this.targetGroupArn = x.targetGroupArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.Action = Action(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig] inside the given [block]
         */
        public fun authenticateCognitoConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.Builder.() -> kotlin.Unit) {
            this.authenticateCognitoConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig] inside the given [block]
         */
        public fun authenticateOidcConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.Builder.() -> kotlin.Unit) {
            this.authenticateOidcConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateOidcActionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.FixedResponseActionConfig] inside the given [block]
         */
        public fun fixedResponseConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.FixedResponseActionConfig.Builder.() -> kotlin.Unit) {
            this.fixedResponseConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.FixedResponseActionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.ForwardActionConfig] inside the given [block]
         */
        public fun forwardConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ForwardActionConfig.Builder.() -> kotlin.Unit) {
            this.forwardConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.ForwardActionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig] inside the given [block]
         */
        public fun redirectConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig.Builder.() -> kotlin.Unit) {
            this.redirectConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig.invoke(block)
        }
    }
}
