// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Request parameters to use when integrating with Amazon Cognito to authenticate users.
 */
public class AuthenticateCognitoActionConfig private constructor(builder: Builder) {
    /**
     * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
     */
    public val authenticationRequestExtraParams: Map<String, String>? = builder.authenticationRequestExtraParams
    /**
     * The behavior if the user is not authenticated. The following are possible values:
     * + deny`` - Return an HTTP 401 Unauthorized error.
     * + allow`` - Allow the request to be forwarded to the target.
     * + authenticate`` - Redirect the request to the IdP authorization endpoint. This is the default value.
     */
    public val onUnauthenticatedRequest: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum? = builder.onUnauthenticatedRequest
    /**
     * The set of user claims to be requested from the IdP. The default is `openid`.
     *
     * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
     */
    public val scope: kotlin.String? = builder.scope
    /**
     * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
     */
    public val sessionCookieName: kotlin.String? = builder.sessionCookieName
    /**
     * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
     */
    public val sessionTimeout: kotlin.Long? = builder.sessionTimeout
    /**
     * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
     */
    public val userPoolArn: kotlin.String? = builder.userPoolArn
    /**
     * The ID of the Amazon Cognito user pool client.
     */
    public val userPoolClientId: kotlin.String? = builder.userPoolClientId
    /**
     * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
     */
    public val userPoolDomain: kotlin.String? = builder.userPoolDomain

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthenticateCognitoActionConfig(")
        append("authenticationRequestExtraParams=$authenticationRequestExtraParams,")
        append("onUnauthenticatedRequest=$onUnauthenticatedRequest,")
        append("scope=$scope,")
        append("sessionCookieName=$sessionCookieName,")
        append("sessionTimeout=$sessionTimeout,")
        append("userPoolArn=$userPoolArn,")
        append("userPoolClientId=$userPoolClientId,")
        append("userPoolDomain=$userPoolDomain)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationRequestExtraParams?.hashCode() ?: 0
        result = 31 * result + (onUnauthenticatedRequest?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        result = 31 * result + (sessionCookieName?.hashCode() ?: 0)
        result = 31 * result + (sessionTimeout?.hashCode() ?: 0)
        result = 31 * result + (userPoolArn?.hashCode() ?: 0)
        result = 31 * result + (userPoolClientId?.hashCode() ?: 0)
        result = 31 * result + (userPoolDomain?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthenticateCognitoActionConfig

        if (authenticationRequestExtraParams != other.authenticationRequestExtraParams) return false
        if (onUnauthenticatedRequest != other.onUnauthenticatedRequest) return false
        if (scope != other.scope) return false
        if (sessionCookieName != other.sessionCookieName) return false
        if (sessionTimeout != other.sessionTimeout) return false
        if (userPoolArn != other.userPoolArn) return false
        if (userPoolClientId != other.userPoolClientId) return false
        if (userPoolDomain != other.userPoolDomain) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The query parameters (up to 10) to include in the redirect request to the authorization endpoint.
         */
        public var authenticationRequestExtraParams: Map<String, String>? = null
        /**
         * The behavior if the user is not authenticated. The following are possible values:
         * + deny`` - Return an HTTP 401 Unauthorized error.
         * + allow`` - Allow the request to be forwarded to the target.
         * + authenticate`` - Redirect the request to the IdP authorization endpoint. This is the default value.
         */
        public var onUnauthenticatedRequest: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConditionalBehaviorEnum? = null
        /**
         * The set of user claims to be requested from the IdP. The default is `openid`.
         *
         * To verify which scope values your IdP supports and how to separate multiple values, see the documentation for your IdP.
         */
        public var scope: kotlin.String? = null
        /**
         * The name of the cookie used to maintain session information. The default is AWSELBAuthSessionCookie.
         */
        public var sessionCookieName: kotlin.String? = null
        /**
         * The maximum duration of the authentication session, in seconds. The default is 604800 seconds (7 days).
         */
        public var sessionTimeout: kotlin.Long? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Cognito user pool.
         */
        public var userPoolArn: kotlin.String? = null
        /**
         * The ID of the Amazon Cognito user pool client.
         */
        public var userPoolClientId: kotlin.String? = null
        /**
         * The domain prefix or fully-qualified domain name of the Amazon Cognito user pool.
         */
        public var userPoolDomain: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig) : this() {
            this.authenticationRequestExtraParams = x.authenticationRequestExtraParams
            this.onUnauthenticatedRequest = x.onUnauthenticatedRequest
            this.scope = x.scope
            this.sessionCookieName = x.sessionCookieName
            this.sessionTimeout = x.sessionTimeout
            this.userPoolArn = x.userPoolArn
            this.userPoolClientId = x.userPoolClientId
            this.userPoolDomain = x.userPoolDomain
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.AuthenticateCognitoActionConfig = AuthenticateCognitoActionConfig(this)
    }
}
