// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



public class CreateListenerRequest private constructor(builder: Builder) {
    /**
     * &#91;TLS listeners&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:
     * + `HTTP1Only`
     * + `HTTP2Only`
     * + `HTTP2Optional`
     * + `HTTP2Preferred`
     * + `None`
     *
     * For more information, see [ALPN policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies) in the *Network Load Balancers Guide*.
     */
    public val alpnPolicy: List<String>? = builder.alpnPolicy
    /**
     * &#91;HTTPS and TLS listeners&#93; The default certificate for the listener. You must provide exactly one certificate. Set `CertificateArn` to the certificate ARN but do not set `IsDefault`.
     */
    public val certificates: List<Certificate>? = builder.certificates
    /**
     * The actions for the default rule.
     */
    public val defaultActions: List<Action>? = builder.defaultActions
    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    public val loadBalancerArn: kotlin.String? = builder.loadBalancerArn
    /**
     * The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
     */
    public val protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.protocol
    /**
     * &#91;HTTPS and TLS listeners&#93; The security policy that defines which protocols and ciphers are supported.
     *
     * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
     */
    public val sslPolicy: kotlin.String? = builder.sslPolicy
    /**
     * The tags to assign to the listener.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateListenerRequest(")
        append("alpnPolicy=$alpnPolicy,")
        append("certificates=$certificates,")
        append("defaultActions=$defaultActions,")
        append("loadBalancerArn=$loadBalancerArn,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("sslPolicy=$sslPolicy,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alpnPolicy?.hashCode() ?: 0
        result = 31 * result + (certificates?.hashCode() ?: 0)
        result = 31 * result + (defaultActions?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (sslPolicy?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateListenerRequest

        if (alpnPolicy != other.alpnPolicy) return false
        if (certificates != other.certificates) return false
        if (defaultActions != other.defaultActions) return false
        if (loadBalancerArn != other.loadBalancerArn) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (sslPolicy != other.sslPolicy) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;TLS listeners&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:
         * + `HTTP1Only`
         * + `HTTP2Only`
         * + `HTTP2Optional`
         * + `HTTP2Preferred`
         * + `None`
         *
         * For more information, see [ALPN policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies) in the *Network Load Balancers Guide*.
         */
        public var alpnPolicy: List<String>? = null
        /**
         * &#91;HTTPS and TLS listeners&#93; The default certificate for the listener. You must provide exactly one certificate. Set `CertificateArn` to the certificate ARN but do not set `IsDefault`.
         */
        public var certificates: List<Certificate>? = null
        /**
         * The actions for the default rule.
         */
        public var defaultActions: List<Action>? = null
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        public var loadBalancerArn: kotlin.String? = null
        /**
         * The port on which the load balancer is listening. You cannot specify a port for a Gateway Load Balancer.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol for connections from clients to the load balancer. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, and TCP_UDP. You can’t specify the UDP or TCP_UDP protocol if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
         */
        public var protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTPS and TLS listeners&#93; The security policy that defines which protocols and ciphers are supported.
         *
         * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* and [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
         */
        public var sslPolicy: kotlin.String? = null
        /**
         * The tags to assign to the listener.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest) : this() {
            this.alpnPolicy = x.alpnPolicy
            this.certificates = x.certificates
            this.defaultActions = x.defaultActions
            this.loadBalancerArn = x.loadBalancerArn
            this.port = x.port
            this.protocol = x.protocol
            this.sslPolicy = x.sslPolicy
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateListenerRequest = CreateListenerRequest(this)
    }
}
