// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



public class CreateLoadBalancerRequest private constructor(builder: Builder) {
    /**
     * &#91;Application Load Balancers on Outposts&#93; The ID of the customer-owned address pool (CoIP pool).
     */
    public val customerOwnedIpv4Pool: kotlin.String? = builder.customerOwnedIpv4Pool
    /**
     * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
     */
    public val ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType? = builder.ipAddressType
    /**
     * The name of the load balancer.
     *
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
     */
    public val name: kotlin.String? = builder.name
    /**
     * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
     *
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
     *
     * The default is an Internet-facing load balancer.
     *
     * You cannot specify a scheme for a Gateway Load Balancer.
     */
    public val scheme: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum? = builder.scheme
    /**
     * &#91;Application Load Balancers&#93; The IDs of the security groups for the load balancer.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
     *
     * &#91;Application Load Balancers&#93; You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     *
     * &#91;Application Load Balancers on Outposts&#93; You must specify one Outpost subnet.
     *
     * &#91;Application Load Balancers on Local Zones&#93; You can specify subnets from one or more Local Zones.
     *
     * &#91;Network Load Balancers&#93; You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
     *
     * &#91;Gateway Load Balancers&#93; You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
     */
    public val subnetMappings: List<SubnetMapping>? = builder.subnetMappings
    /**
     * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
     *
     * &#91;Application Load Balancers&#93; You must specify subnets from at least two Availability Zones.
     *
     * &#91;Application Load Balancers on Outposts&#93; You must specify one Outpost subnet.
     *
     * &#91;Application Load Balancers on Local Zones&#93; You can specify subnets from one or more Local Zones.
     *
     * &#91;Network Load Balancers&#93; You can specify subnets from one or more Availability Zones.
     *
     * &#91;Gateway Load Balancers&#93; You can specify subnets from one or more Availability Zones.
     */
    public val subnets: List<String>? = builder.subnets
    /**
     * The tags to assign to the load balancer.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of load balancer. The default is `application`.
     */
    public val type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLoadBalancerRequest(")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("ipAddressType=$ipAddressType,")
        append("name=$name,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("subnetMappings=$subnetMappings,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerOwnedIpv4Pool?.hashCode() ?: 0
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (subnetMappings?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateLoadBalancerRequest

        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (ipAddressType != other.ipAddressType) return false
        if (name != other.name) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (subnetMappings != other.subnetMappings) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;Application Load Balancers on Outposts&#93; The ID of the customer-owned address pool (CoIP pool).
         */
        public var customerOwnedIpv4Pool: kotlin.String? = null
        /**
         * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
         */
        public var ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType? = null
        /**
         * The name of the load balancer.
         *
         * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, must not begin or end with a hyphen, and must not begin with "internal-".
         */
        public var name: kotlin.String? = null
        /**
         * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
         *
         * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
         *
         * The default is an Internet-facing load balancer.
         *
         * You cannot specify a scheme for a Gateway Load Balancer.
         */
        public var scheme: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum? = null
        /**
         * &#91;Application Load Balancers&#93; The IDs of the security groups for the load balancer.
         */
        public var securityGroups: List<String>? = null
        /**
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both.
         *
         * &#91;Application Load Balancers&#93; You must specify subnets from at least two Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         *
         * &#91;Application Load Balancers on Outposts&#93; You must specify one Outpost subnet.
         *
         * &#91;Application Load Balancers on Local Zones&#93; You can specify subnets from one or more Local Zones.
         *
         * &#91;Network Load Balancers&#93; You can specify subnets from one or more Availability Zones. You can specify one Elastic IP address per subnet if you need static IP addresses for your internet-facing load balancer. For internal load balancers, you can specify one private IP address per subnet from the IPv4 range of the subnet. For internet-facing load balancer, you can specify one IPv6 address per subnet.
         *
         * &#91;Gateway Load Balancers&#93; You can specify subnets from one or more Availability Zones. You cannot specify Elastic IP addresses for your subnets.
         */
        public var subnetMappings: List<SubnetMapping>? = null
        /**
         * The IDs of the public subnets. You can specify only one subnet per Availability Zone. You must specify either subnets or subnet mappings, but not both. To specify an Elastic IP address, specify subnet mappings instead of subnets.
         *
         * &#91;Application Load Balancers&#93; You must specify subnets from at least two Availability Zones.
         *
         * &#91;Application Load Balancers on Outposts&#93; You must specify one Outpost subnet.
         *
         * &#91;Application Load Balancers on Local Zones&#93; You can specify subnets from one or more Local Zones.
         *
         * &#91;Network Load Balancers&#93; You can specify subnets from one or more Availability Zones.
         *
         * &#91;Gateway Load Balancers&#93; You can specify subnets from one or more Availability Zones.
         */
        public var subnets: List<String>? = null
        /**
         * The tags to assign to the load balancer.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of load balancer. The default is `application`.
         */
        public var type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest) : this() {
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.ipAddressType = x.ipAddressType
            this.name = x.name
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.subnetMappings = x.subnetMappings
            this.subnets = x.subnets
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest = CreateLoadBalancerRequest(this)
    }
}
