// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



public class CreateTargetGroupRequest private constructor(builder: Builder) {
    /**
     * Indicates whether health checks are enabled. If the target type is `lambda`, health checks are disabled by default but can be enabled. If the target type is `instance`, `ip`, or `alb`, health checks are always enabled and cannot be disabled.
     */
    public val healthCheckEnabled: kotlin.Boolean? = builder.healthCheckEnabled
    /**
     * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. If the target group protocol is TCP, TLS, UDP, TCP_UDP, HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is `lambda`, the default is 35 seconds.
     */
    public val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * &#91;HTTP/HTTPS health checks&#93; The destination for health checks on the targets.
     *
     * &#91;HTTP1 or HTTP2 protocol version&#93; The ping path. The default is /.
     *
     * &#91;GRPC protocol version&#93; The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is `traffic-port`, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
     */
    public val healthCheckPort: kotlin.String? = builder.healthCheckPort
    /**
     * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
     */
    public val healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.healthCheckProtocol
    /**
     * The amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is `lambda`, the default is 30 seconds.
     */
    public val healthCheckTimeoutSeconds: kotlin.Int? = builder.healthCheckTimeoutSeconds
    /**
     * The number of consecutive health check successes required before considering a target healthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 5. For target groups with a protocol of GENEVE, the default is 3. If the target type is `lambda`, the default is 5.
     */
    public val healthyThresholdCount: kotlin.Int? = builder.healthyThresholdCount
    /**
     * The type of IP address used for this target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
     */
    public val ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum? = builder.ipAddressType
    /**
     * &#91;HTTP/HTTPS health checks&#93; The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.
     */
    public val matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = builder.matcher
    /**
     * The name of the target group.
     *
     * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
     */
    public val protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.protocol
    /**
     * &#91;HTTP/HTTPS protocol&#93; The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1.
     */
    public val protocolVersion: kotlin.String? = builder.protocolVersion
    /**
     * The tags to assign to the target group.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.
     * + `instance` - Register targets by instance ID. This is the default value.
     * + `ip` - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
     * + `lambda` - Register a single Lambda function as a target.
     * + `alb` - Register a single Application Load Balancer as a target.
     */
    public val targetType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetTypeEnum? = builder.targetType
    /**
     * The number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 2. For target groups with a protocol of GENEVE, the default is 3. If the target type is `lambda`, the default is 5.
     */
    public val unhealthyThresholdCount: kotlin.Int? = builder.unhealthyThresholdCount
    /**
     * The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTargetGroupRequest(")
        append("healthCheckEnabled=$healthCheckEnabled,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckPath=$healthCheckPath,")
        append("healthCheckPort=$healthCheckPort,")
        append("healthCheckProtocol=$healthCheckProtocol,")
        append("healthCheckTimeoutSeconds=$healthCheckTimeoutSeconds,")
        append("healthyThresholdCount=$healthyThresholdCount,")
        append("ipAddressType=$ipAddressType,")
        append("matcher=$matcher,")
        append("name=$name,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("protocolVersion=$protocolVersion,")
        append("tags=$tags,")
        append("targetType=$targetType,")
        append("unhealthyThresholdCount=$unhealthyThresholdCount,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthCheckEnabled?.hashCode() ?: 0
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPort?.hashCode() ?: 0)
        result = 31 * result + (healthCheckProtocol?.hashCode() ?: 0)
        result = 31 * result + (healthCheckTimeoutSeconds ?: 0)
        result = 31 * result + (healthyThresholdCount ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (matcher?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (protocolVersion?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetType?.hashCode() ?: 0)
        result = 31 * result + (unhealthyThresholdCount ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTargetGroupRequest

        if (healthCheckEnabled != other.healthCheckEnabled) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (healthCheckPort != other.healthCheckPort) return false
        if (healthCheckProtocol != other.healthCheckProtocol) return false
        if (healthCheckTimeoutSeconds != other.healthCheckTimeoutSeconds) return false
        if (healthyThresholdCount != other.healthyThresholdCount) return false
        if (ipAddressType != other.ipAddressType) return false
        if (matcher != other.matcher) return false
        if (name != other.name) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (protocolVersion != other.protocolVersion) return false
        if (tags != other.tags) return false
        if (targetType != other.targetType) return false
        if (unhealthyThresholdCount != other.unhealthyThresholdCount) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether health checks are enabled. If the target type is `lambda`, health checks are disabled by default but can be enabled. If the target type is `instance`, `ip`, or `alb`, health checks are always enabled and cannot be disabled.
         */
        public var healthCheckEnabled: kotlin.Boolean? = null
        /**
         * The approximate amount of time, in seconds, between health checks of an individual target. The range is 5-300. If the target group protocol is TCP, TLS, UDP, TCP_UDP, HTTP or HTTPS, the default is 30 seconds. If the target group protocol is GENEVE, the default is 10 seconds. If the target type is `lambda`, the default is 35 seconds.
         */
        public var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * &#91;HTTP/HTTPS health checks&#93; The destination for health checks on the targets.
         *
         * &#91;HTTP1 or HTTP2 protocol version&#93; The ping path. The default is /.
         *
         * &#91;GRPC protocol version&#93; The path of a custom health check method with the format /package.service/method. The default is /Amazon Web Services.ALB/healthcheck.
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * The port the load balancer uses when performing health checks on targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the default is `traffic-port`, which is the port on which each target receives traffic from the load balancer. If the protocol is GENEVE, the default is port 80.
         */
        public var healthCheckPort: kotlin.String? = null
        /**
         * The protocol the load balancer uses when performing health checks on targets. For Application Load Balancers, the default is HTTP. For Network Load Balancers and Gateway Load Balancers, the default is TCP. The TCP protocol is not supported for health checks if the protocol of the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP protocols are not supported for health checks.
         */
        public var healthCheckProtocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * The amount of time, in seconds, during which no response from a target means a failed health check. The range is 2–120 seconds. For target groups with a protocol of HTTP, the default is 6 seconds. For target groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds. For target groups with a protocol of GENEVE, the default is 5 seconds. If the target type is `lambda`, the default is 30 seconds.
         */
        public var healthCheckTimeoutSeconds: kotlin.Int? = null
        /**
         * The number of consecutive health check successes required before considering a target healthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 5. For target groups with a protocol of GENEVE, the default is 3. If the target type is `lambda`, the default is 5.
         */
        public var healthyThresholdCount: kotlin.Int? = null
        /**
         * The type of IP address used for this target group. The possible values are `ipv4` and `ipv6`. This is an optional parameter. If not specified, the IP address type defaults to `ipv4`.
         */
        public var ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetGroupIpAddressTypeEnum? = null
        /**
         * &#91;HTTP/HTTPS health checks&#93; The HTTP or gRPC codes to use when checking for a successful response from a target. For target groups with a protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target groups with a protocol of HTTP or HTTPS, the range is 200-499. For target groups with a protocol of GENEVE, the range is 200-399.
         */
        public var matcher: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher? = null
        /**
         * The name of the target group.
         *
         * This name must be unique per region per account, can have a maximum of 32 characters, must contain only alphanumeric characters or hyphens, and must not begin or end with a hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * The port on which the targets receive traffic. This port is used unless you specify a port override when registering the target. If the target is a Lambda function, this parameter does not apply. If the protocol is GENEVE, the supported port is 6081.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol to use for routing traffic to the targets. For Application Load Balancers, the supported protocols are HTTP and HTTPS. For Network Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP. For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP listener must be associated with a TCP_UDP target group. If the target is a Lambda function, this parameter does not apply.
         */
        public var protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTP/HTTPS protocol&#93; The protocol version. Specify `GRPC` to send requests to targets using gRPC. Specify `HTTP2` to send requests to targets using HTTP/2. The default is `HTTP1`, which sends requests to targets using HTTP/1.1.
         */
        public var protocolVersion: kotlin.String? = null
        /**
         * The tags to assign to the target group.
         */
        public var tags: List<Tag>? = null
        /**
         * The type of target that you must specify when registering targets with this target group. You can't specify targets for a target group using more than one target type.
         * + `instance` - Register targets by instance ID. This is the default value.
         * + `ip` - Register targets by IP address. You can specify IP addresses from the subnets of the virtual private cloud (VPC) for the target group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and 192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't specify publicly routable IP addresses.
         * + `lambda` - Register a single Lambda function as a target.
         * + `alb` - Register a single Application Load Balancer as a target.
         */
        public var targetType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetTypeEnum? = null
        /**
         * The number of consecutive health check failures required before considering a target unhealthy. The range is 2-10. If the target group protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 2. For target groups with a protocol of GENEVE, the default is 3. If the target type is `lambda`, the default is 5.
         */
        public var unhealthyThresholdCount: kotlin.Int? = null
        /**
         * The identifier of the virtual private cloud (VPC). If the target is a Lambda function, this parameter does not apply. Otherwise, this parameter is required.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest) : this() {
            this.healthCheckEnabled = x.healthCheckEnabled
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckPath = x.healthCheckPath
            this.healthCheckPort = x.healthCheckPort
            this.healthCheckProtocol = x.healthCheckProtocol
            this.healthCheckTimeoutSeconds = x.healthCheckTimeoutSeconds
            this.healthyThresholdCount = x.healthyThresholdCount
            this.ipAddressType = x.ipAddressType
            this.matcher = x.matcher
            this.name = x.name
            this.port = x.port
            this.protocol = x.protocol
            this.protocolVersion = x.protocolVersion
            this.tags = x.tags
            this.targetType = x.targetType
            this.unhealthyThresholdCount = x.unhealthyThresholdCount
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.CreateTargetGroupRequest = CreateTargetGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher] inside the given [block]
         */
        public fun matcher(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.Builder.() -> kotlin.Unit) {
            this.matcher = aws.sdk.kotlin.services.elasticloadbalancingv2.model.Matcher.invoke(block)
        }
    }
}
