// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a load balancer.
 */
public class LoadBalancer private constructor(builder: Builder) {
    /**
     * The subnets for the load balancer.
     */
    public val availabilityZones: List<AvailabilityZone>? = builder.availabilityZones
    /**
     * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
     */
    public val canonicalHostedZoneId: kotlin.String? = builder.canonicalHostedZoneId
    /**
     * The date and time the load balancer was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * &#91;Application Load Balancers on Outposts&#93; The ID of the customer-owned address pool.
     */
    public val customerOwnedIpv4Pool: kotlin.String? = builder.customerOwnedIpv4Pool
    /**
     * The public DNS name of the load balancer.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
     */
    public val ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType? = builder.ipAddressType
    /**
     * The Amazon Resource Name (ARN) of the load balancer.
     */
    public val loadBalancerArn: kotlin.String? = builder.loadBalancerArn
    /**
     * The name of the load balancer.
     */
    public val loadBalancerName: kotlin.String? = builder.loadBalancerName
    /**
     * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
     *
     * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
     */
    public val scheme: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum? = builder.scheme
    /**
     * The IDs of the security groups for the load balancer.
     */
    public val securityGroups: List<String>? = builder.securityGroups
    /**
     * The state of the load balancer.
     */
    public val state: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerState? = builder.state
    /**
     * The type of load balancer.
     */
    public val type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum? = builder.type
    /**
     * The ID of the VPC for the load balancer.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LoadBalancer(")
        append("availabilityZones=$availabilityZones,")
        append("canonicalHostedZoneId=$canonicalHostedZoneId,")
        append("createdTime=$createdTime,")
        append("customerOwnedIpv4Pool=$customerOwnedIpv4Pool,")
        append("dnsName=$dnsName,")
        append("ipAddressType=$ipAddressType,")
        append("loadBalancerArn=$loadBalancerArn,")
        append("loadBalancerName=$loadBalancerName,")
        append("scheme=$scheme,")
        append("securityGroups=$securityGroups,")
        append("state=$state,")
        append("type=$type,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZones?.hashCode() ?: 0
        result = 31 * result + (canonicalHostedZoneId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (customerOwnedIpv4Pool?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerArn?.hashCode() ?: 0)
        result = 31 * result + (loadBalancerName?.hashCode() ?: 0)
        result = 31 * result + (scheme?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LoadBalancer

        if (availabilityZones != other.availabilityZones) return false
        if (canonicalHostedZoneId != other.canonicalHostedZoneId) return false
        if (createdTime != other.createdTime) return false
        if (customerOwnedIpv4Pool != other.customerOwnedIpv4Pool) return false
        if (dnsName != other.dnsName) return false
        if (ipAddressType != other.ipAddressType) return false
        if (loadBalancerArn != other.loadBalancerArn) return false
        if (loadBalancerName != other.loadBalancerName) return false
        if (scheme != other.scheme) return false
        if (securityGroups != other.securityGroups) return false
        if (state != other.state) return false
        if (type != other.type) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The subnets for the load balancer.
         */
        public var availabilityZones: List<AvailabilityZone>? = null
        /**
         * The ID of the Amazon Route 53 hosted zone associated with the load balancer.
         */
        public var canonicalHostedZoneId: kotlin.String? = null
        /**
         * The date and time the load balancer was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * &#91;Application Load Balancers on Outposts&#93; The ID of the customer-owned address pool.
         */
        public var customerOwnedIpv4Pool: kotlin.String? = null
        /**
         * The public DNS name of the load balancer.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The type of IP addresses used by the subnets for your load balancer. The possible values are `ipv4` (for IPv4 addresses) and `dualstack` (for IPv4 and IPv6 addresses).
         */
        public var ipAddressType: aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType? = null
        /**
         * The Amazon Resource Name (ARN) of the load balancer.
         */
        public var loadBalancerArn: kotlin.String? = null
        /**
         * The name of the load balancer.
         */
        public var loadBalancerName: kotlin.String? = null
        /**
         * The nodes of an Internet-facing load balancer have public IP addresses. The DNS name of an Internet-facing load balancer is publicly resolvable to the public IP addresses of the nodes. Therefore, Internet-facing load balancers can route requests from clients over the internet.
         *
         * The nodes of an internal load balancer have only private IP addresses. The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes. Therefore, internal load balancers can route requests only from clients with access to the VPC for the load balancer.
         */
        public var scheme: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum? = null
        /**
         * The IDs of the security groups for the load balancer.
         */
        public var securityGroups: List<String>? = null
        /**
         * The state of the load balancer.
         */
        public var state: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerState? = null
        /**
         * The type of load balancer.
         */
        public var type: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum? = null
        /**
         * The ID of the VPC for the load balancer.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer) : this() {
            this.availabilityZones = x.availabilityZones
            this.canonicalHostedZoneId = x.canonicalHostedZoneId
            this.createdTime = x.createdTime
            this.customerOwnedIpv4Pool = x.customerOwnedIpv4Pool
            this.dnsName = x.dnsName
            this.ipAddressType = x.ipAddressType
            this.loadBalancerArn = x.loadBalancerArn
            this.loadBalancerName = x.loadBalancerName
            this.scheme = x.scheme
            this.securityGroups = x.securityGroups
            this.state = x.state
            this.type = x.type
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancer = LoadBalancer(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerState] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.elasticloadbalancingv2.model.LoadBalancerState.invoke(block)
        }
    }
}
