// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



public class ModifyListenerRequest private constructor(builder: Builder) {
    /**
     * &#91;TLS listeners&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:
     * + `HTTP1Only`
     * + `HTTP2Only`
     * + `HTTP2Optional`
     * + `HTTP2Preferred`
     * + `None`
     *
     * For more information, see [ALPN policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies) in the *Network Load Balancers Guide*.
     */
    public val alpnPolicy: List<String>? = builder.alpnPolicy
    /**
     * &#91;HTTPS and TLS listeners&#93; The default certificate for the listener. You must provide exactly one certificate. Set `CertificateArn` to the certificate ARN but do not set `IsDefault`.
     */
    public val certificates: List<Certificate>? = builder.certificates
    /**
     * The actions for the default rule.
     */
    public val defaultActions: List<Action>? = builder.defaultActions
    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    public val listenerArn: kotlin.String? = builder.listenerArn
    /**
     * The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.
     */
    public val port: kotlin.Int? = builder.port
    /**
     * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
     */
    public val protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = builder.protocol
    /**
     * &#91;HTTPS and TLS listeners&#93; The security policy that defines which protocols and ciphers are supported.
     *
     * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
     */
    public val sslPolicy: kotlin.String? = builder.sslPolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyListenerRequest(")
        append("alpnPolicy=$alpnPolicy,")
        append("certificates=$certificates,")
        append("defaultActions=$defaultActions,")
        append("listenerArn=$listenerArn,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("sslPolicy=$sslPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = alpnPolicy?.hashCode() ?: 0
        result = 31 * result + (certificates?.hashCode() ?: 0)
        result = 31 * result + (defaultActions?.hashCode() ?: 0)
        result = 31 * result + (listenerArn?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (sslPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyListenerRequest

        if (alpnPolicy != other.alpnPolicy) return false
        if (certificates != other.certificates) return false
        if (defaultActions != other.defaultActions) return false
        if (listenerArn != other.listenerArn) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (sslPolicy != other.sslPolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * &#91;TLS listeners&#93; The name of the Application-Layer Protocol Negotiation (ALPN) policy. You can specify one policy name. The following are the possible values:
         * + `HTTP1Only`
         * + `HTTP2Only`
         * + `HTTP2Optional`
         * + `HTTP2Preferred`
         * + `None`
         *
         * For more information, see [ALPN policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#alpn-policies) in the *Network Load Balancers Guide*.
         */
        public var alpnPolicy: List<String>? = null
        /**
         * &#91;HTTPS and TLS listeners&#93; The default certificate for the listener. You must provide exactly one certificate. Set `CertificateArn` to the certificate ARN but do not set `IsDefault`.
         */
        public var certificates: List<Certificate>? = null
        /**
         * The actions for the default rule.
         */
        public var defaultActions: List<Action>? = null
        /**
         * The Amazon Resource Name (ARN) of the listener.
         */
        public var listenerArn: kotlin.String? = null
        /**
         * The port for connections from clients to the load balancer. You cannot specify a port for a Gateway Load Balancer.
         */
        public var port: kotlin.Int? = null
        /**
         * The protocol for connections from clients to the load balancer. Application Load Balancers support the HTTP and HTTPS protocols. Network Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You can’t change the protocol to UDP or TCP_UDP if dual-stack mode is enabled. You cannot specify a protocol for a Gateway Load Balancer.
         */
        public var protocol: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ProtocolEnum? = null
        /**
         * &#91;HTTPS and TLS listeners&#93; The security policy that defines which protocols and ciphers are supported.
         *
         * For more information, see [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies) in the *Application Load Balancers Guide* or [Security policies](https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies) in the *Network Load Balancers Guide*.
         */
        public var sslPolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest) : this() {
            this.alpnPolicy = x.alpnPolicy
            this.certificates = x.certificates
            this.defaultActions = x.defaultActions
            this.listenerArn = x.listenerArn
            this.port = x.port
            this.protocol = x.protocol
            this.sslPolicy = x.sslPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerRequest = ModifyListenerRequest(this)
    }
}
