// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about a redirect action.
 *
 * A URI consists of the following components: protocol://hostname:port/path?query. You must modify at least one of the following components to avoid a redirect loop: protocol, hostname, port, or path. Any components that you do not modify retain their original values.
 *
 * You can reuse URI components using the following reserved keywords:
 * + #{protocol}
 * + #{host}
 * + #{port}
 * + #{path} (the leading "/" is removed)
 * + #{query}
 *
 * For example, you can change the path to "/new/#{path}", the hostname to "example.#{host}", or the query to "#{query}&value=xyz".
 */
public class RedirectActionConfig private constructor(builder: Builder) {
    /**
     * The hostname. This component is not percent-encoded. The hostname can contain #{host}.
     */
    public val host: kotlin.String? = builder.host
    /**
     * The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
     */
    public val path: kotlin.String? = builder.path
    /**
     * The port. You can specify a value from 1 to 65535 or #{port}.
     */
    public val port: kotlin.String? = builder.port
    /**
     * The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
     */
    public val protocol: kotlin.String? = builder.protocol
    /**
     * The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
     */
    public val query: kotlin.String? = builder.query
    /**
     * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
     */
    public val statusCode: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum? = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedirectActionConfig(")
        append("host=$host,")
        append("path=$path,")
        append("port=$port,")
        append("protocol=$protocol,")
        append("query=$query,")
        append("statusCode=$statusCode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = host?.hashCode() ?: 0
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (port?.hashCode() ?: 0)
        result = 31 * result + (protocol?.hashCode() ?: 0)
        result = 31 * result + (query?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedirectActionConfig

        if (host != other.host) return false
        if (path != other.path) return false
        if (port != other.port) return false
        if (protocol != other.protocol) return false
        if (query != other.query) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The hostname. This component is not percent-encoded. The hostname can contain #{host}.
         */
        public var host: kotlin.String? = null
        /**
         * The absolute path, starting with the leading "/". This component is not percent-encoded. The path can contain #{host}, #{path}, and #{port}.
         */
        public var path: kotlin.String? = null
        /**
         * The port. You can specify a value from 1 to 65535 or #{port}.
         */
        public var port: kotlin.String? = null
        /**
         * The protocol. You can specify HTTP, HTTPS, or #{protocol}. You can redirect HTTP to HTTP, HTTP to HTTPS, and HTTPS to HTTPS. You cannot redirect HTTPS to HTTP.
         */
        public var protocol: kotlin.String? = null
        /**
         * The query parameters, URL-encoded when necessary, but not percent-encoded. Do not include the leading "?", as it is automatically added. You can specify any of the reserved keywords.
         */
        public var query: kotlin.String? = null
        /**
         * The HTTP redirect code. The redirect is either permanent (HTTP 301) or temporary (HTTP 302).
         */
        public var statusCode: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionStatusCodeEnum? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig) : this() {
            this.host = x.host
            this.path = x.path
            this.port = x.port
            this.protocol = x.protocol
            this.query = x.query
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RedirectActionConfig = RedirectActionConfig(this)
    }
}
