// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about a condition for a rule.
 *
 * Each rule can optionally include up to one of each of the following conditions: `http-request-method`, `host-header`, `path-pattern`, and `source-ip`. Each rule can also optionally include one or more of each of the following conditions: `http-header` and `query-string`. Note that the value for a condition cannot be empty.
 */
public class RuleCondition private constructor(builder: Builder) {
    /**
     * The field in the HTTP request. The following are the possible values:
     * + `http-header`
     * + `http-request-method`
     * + `host-header`
     * + `path-pattern`
     * + `query-string`
     * + `source-ip`
     */
    public val field: kotlin.String? = builder.field
    /**
     * Information for a host header condition. Specify only when `Field` is `host-header`.
     */
    public val hostHeaderConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HostHeaderConditionConfig? = builder.hostHeaderConfig
    /**
     * Information for an HTTP header condition. Specify only when `Field` is `http-header`.
     */
    public val httpHeaderConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig? = builder.httpHeaderConfig
    /**
     * Information for an HTTP method condition. Specify only when `Field` is `http-request-method`.
     */
    public val httpRequestMethodConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig? = builder.httpRequestMethodConfig
    /**
     * Information for a path pattern condition. Specify only when `Field` is `path-pattern`.
     */
    public val pathPatternConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.PathPatternConditionConfig? = builder.pathPatternConfig
    /**
     * Information for a query string condition. Specify only when `Field` is `query-string`.
     */
    public val queryStringConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.QueryStringConditionConfig? = builder.queryStringConfig
    /**
     * Information for a source IP condition. Specify only when `Field` is `source-ip`.
     */
    public val sourceIpConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.SourceIpConditionConfig? = builder.sourceIpConfig
    /**
     * The condition value. Specify only when `Field` is `host-header` or `path-pattern`. Alternatively, to specify multiple host names or multiple path patterns, use `HostHeaderConfig` or `PathPatternConfig`.
     *
     * If `Field` is `host-header` and you are not using `HostHeaderConfig`, you can specify a single host name (for example, my.example.com) in `Values`. A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
     * + A-Z, a-z, 0-9
     * + - .
     * + * (matches 0 or more characters)
     * + ? (matches exactly 1 character)
     *
     * If `Field` is `path-pattern` and you are not using `PathPatternConfig`, you can specify a single path pattern (for example, /img&#47;*) in `Values`. A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
     * + A-Z, a-z, 0-9
     * + _ - . $ / ~ " ' @ : +
     * + & (using &)
     * + * (matches 0 or more characters)
     * + ? (matches exactly 1 character)
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RuleCondition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RuleCondition(")
        append("field=$field,")
        append("hostHeaderConfig=$hostHeaderConfig,")
        append("httpHeaderConfig=$httpHeaderConfig,")
        append("httpRequestMethodConfig=$httpRequestMethodConfig,")
        append("pathPatternConfig=$pathPatternConfig,")
        append("queryStringConfig=$queryStringConfig,")
        append("sourceIpConfig=$sourceIpConfig,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (hostHeaderConfig?.hashCode() ?: 0)
        result = 31 * result + (httpHeaderConfig?.hashCode() ?: 0)
        result = 31 * result + (httpRequestMethodConfig?.hashCode() ?: 0)
        result = 31 * result + (pathPatternConfig?.hashCode() ?: 0)
        result = 31 * result + (queryStringConfig?.hashCode() ?: 0)
        result = 31 * result + (sourceIpConfig?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RuleCondition

        if (field != other.field) return false
        if (hostHeaderConfig != other.hostHeaderConfig) return false
        if (httpHeaderConfig != other.httpHeaderConfig) return false
        if (httpRequestMethodConfig != other.httpRequestMethodConfig) return false
        if (pathPatternConfig != other.pathPatternConfig) return false
        if (queryStringConfig != other.queryStringConfig) return false
        if (sourceIpConfig != other.sourceIpConfig) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RuleCondition = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The field in the HTTP request. The following are the possible values:
         * + `http-header`
         * + `http-request-method`
         * + `host-header`
         * + `path-pattern`
         * + `query-string`
         * + `source-ip`
         */
        public var field: kotlin.String? = null
        /**
         * Information for a host header condition. Specify only when `Field` is `host-header`.
         */
        public var hostHeaderConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HostHeaderConditionConfig? = null
        /**
         * Information for an HTTP header condition. Specify only when `Field` is `http-header`.
         */
        public var httpHeaderConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig? = null
        /**
         * Information for an HTTP method condition. Specify only when `Field` is `http-request-method`.
         */
        public var httpRequestMethodConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig? = null
        /**
         * Information for a path pattern condition. Specify only when `Field` is `path-pattern`.
         */
        public var pathPatternConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.PathPatternConditionConfig? = null
        /**
         * Information for a query string condition. Specify only when `Field` is `query-string`.
         */
        public var queryStringConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.QueryStringConditionConfig? = null
        /**
         * Information for a source IP condition. Specify only when `Field` is `source-ip`.
         */
        public var sourceIpConfig: aws.sdk.kotlin.services.elasticloadbalancingv2.model.SourceIpConditionConfig? = null
        /**
         * The condition value. Specify only when `Field` is `host-header` or `path-pattern`. Alternatively, to specify multiple host names or multiple path patterns, use `HostHeaderConfig` or `PathPatternConfig`.
         *
         * If `Field` is `host-header` and you are not using `HostHeaderConfig`, you can specify a single host name (for example, my.example.com) in `Values`. A host name is case insensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * + A-Z, a-z, 0-9
         * + - .
         * + * (matches 0 or more characters)
         * + ? (matches exactly 1 character)
         *
         * If `Field` is `path-pattern` and you are not using `PathPatternConfig`, you can specify a single path pattern (for example, /img&#47;*) in `Values`. A path pattern is case-sensitive, can be up to 128 characters in length, and can contain any of the following characters.
         * + A-Z, a-z, 0-9
         * + _ - . $ / ~ " ' @ : +
         * + & (using &)
         * + * (matches 0 or more characters)
         * + ? (matches exactly 1 character)
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.RuleCondition) : this() {
            this.field = x.field
            this.hostHeaderConfig = x.hostHeaderConfig
            this.httpHeaderConfig = x.httpHeaderConfig
            this.httpRequestMethodConfig = x.httpRequestMethodConfig
            this.pathPatternConfig = x.pathPatternConfig
            this.queryStringConfig = x.queryStringConfig
            this.sourceIpConfig = x.sourceIpConfig
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.RuleCondition = RuleCondition(this)

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.HostHeaderConditionConfig] inside the given [block]
         */
        public fun hostHeaderConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HostHeaderConditionConfig.Builder.() -> kotlin.Unit) {
            this.hostHeaderConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.HostHeaderConditionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig] inside the given [block]
         */
        public fun httpHeaderConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig.Builder.() -> kotlin.Unit) {
            this.httpHeaderConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpHeaderConditionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig] inside the given [block]
         */
        public fun httpRequestMethodConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig.Builder.() -> kotlin.Unit) {
            this.httpRequestMethodConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.HttpRequestMethodConditionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.PathPatternConditionConfig] inside the given [block]
         */
        public fun pathPatternConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.PathPatternConditionConfig.Builder.() -> kotlin.Unit) {
            this.pathPatternConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.PathPatternConditionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.QueryStringConditionConfig] inside the given [block]
         */
        public fun queryStringConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.QueryStringConditionConfig.Builder.() -> kotlin.Unit) {
            this.queryStringConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.QueryStringConditionConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elasticloadbalancingv2.model.SourceIpConditionConfig] inside the given [block]
         */
        public fun sourceIpConfig(block: aws.sdk.kotlin.services.elasticloadbalancingv2.model.SourceIpConditionConfig.Builder.() -> kotlin.Unit) {
            this.sourceIpConfig = aws.sdk.kotlin.services.elasticloadbalancingv2.model.SourceIpConditionConfig.invoke(block)
        }
    }
}
