// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.model



/**
 * Information about a target.
 */
public class TargetDescription private constructor(builder: Builder) {
    /**
     * An Availability Zone or `all`. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
     *
     * For Application Load Balancer target groups, the specified Availability Zone value is only applicable when cross-zone load balancing is off. Otherwise the parameter is ignored and treated as `all`.
     *
     * This parameter is not supported if the target type of the target group is `instance` or `alb`.
     *
     * If the target type is `ip` and the IP address is in a subnet of the VPC for the target group, the Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC, this parameter is required.
     *
     * For Application Load Balancer target groups with cross-zone load balancing off, if the target type is `ip` and the IP address is outside of the VPC for the target group, this should be an Availability Zone inside the VPC for the target group.
     *
     * If the target type is `lambda`, this parameter is optional and the only supported value is `all`.
     */
    public val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the target. If the target type of the target group is `instance`, specify an instance ID. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the ARN of the Lambda function. If the target type is `alb`, specify the ARN of the Application Load Balancer target.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is `alb`, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
     */
    public val port: kotlin.Int? = builder.port

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetDescription(")
        append("availabilityZone=$availabilityZone,")
        append("id=$id,")
        append("port=$port)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (port ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetDescription

        if (availabilityZone != other.availabilityZone) return false
        if (id != other.id) return false
        if (port != other.port) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Availability Zone or `all`. This determines whether the target receives traffic from the load balancer nodes in the specified Availability Zone or from all enabled Availability Zones for the load balancer.
         *
         * For Application Load Balancer target groups, the specified Availability Zone value is only applicable when cross-zone load balancing is off. Otherwise the parameter is ignored and treated as `all`.
         *
         * This parameter is not supported if the target type of the target group is `instance` or `alb`.
         *
         * If the target type is `ip` and the IP address is in a subnet of the VPC for the target group, the Availability Zone is automatically detected and this parameter is optional. If the IP address is outside the VPC, this parameter is required.
         *
         * For Application Load Balancer target groups with cross-zone load balancing off, if the target type is `ip` and the IP address is outside of the VPC for the target group, this should be an Availability Zone inside the VPC for the target group.
         *
         * If the target type is `lambda`, this parameter is optional and the only supported value is `all`.
         */
        public var availabilityZone: kotlin.String? = null
        /**
         * The ID of the target. If the target type of the target group is `instance`, specify an instance ID. If the target type is `ip`, specify an IP address. If the target type is `lambda`, specify the ARN of the Lambda function. If the target type is `alb`, specify the ARN of the Application Load Balancer target.
         */
        public var id: kotlin.String? = null
        /**
         * The port on which the target is listening. If the target group protocol is GENEVE, the supported port is 6081. If the target type is `alb`, the targeted Application Load Balancer must have at least one listener whose port matches the target group port. Not used if the target is a Lambda function.
         */
        public var port: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetDescription) : this() {
            this.availabilityZone = x.availabilityZone
            this.id = x.id
            this.port = x.port
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elasticloadbalancingv2.model.TargetDescription = TargetDescription(this)
    }
}
