// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeRulesResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Rule
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class DescribeRulesOperationDeserializer: HttpDeserialize<DescribeRulesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeRulesResponse {
        if (!response.status.isSuccess()) {
            throwDescribeRulesError(context, response)
        }
        val builder = DescribeRulesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeRulesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeRulesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "RuleNotFound" -> RuleNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeRulesOperationBody(builder: DescribeRulesResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("DescribeRulesResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("DescribeRulesResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap DescribeRules response")
    }
    // end unwrap response wrapper

    val NEXTMARKER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("NextMarker"))
    val RULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Rules"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2015-12-01/"))
        trait(XmlSerialName("DescribeRulesResult"))
        field(NEXTMARKER_DESCRIPTOR)
        field(RULES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTMARKER_DESCRIPTOR.index -> builder.nextMarker = deserializeString()
                RULES_DESCRIPTOR.index -> builder.rules =
                    deserializer.deserializeList(RULES_DESCRIPTOR) {
                        val col0 = mutableListOf<Rule>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuleDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
