// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.Listener
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ModifyListenerResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class ModifyListenerOperationDeserializer: HttpDeserialize<ModifyListenerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ModifyListenerResponse {
        if (!response.status.isSuccess()) {
            throwModifyListenerError(context, response)
        }
        val builder = ModifyListenerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeModifyListenerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwModifyListenerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ALPNPolicyNotFound" -> AlpnPolicyNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "CertificateNotFound" -> CertificateNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "DuplicateListener" -> DuplicateListenerExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncompatibleProtocols" -> IncompatibleProtocolsExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidLoadBalancerAction" -> InvalidLoadBalancerActionExceptionDeserializer().deserialize(context, wrappedResponse)
        "ListenerNotFound" -> ListenerNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "SSLPolicyNotFound" -> SslPolicyNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TargetGroupAssociationLimit" -> TargetGroupAssociationLimitExceptionDeserializer().deserialize(context, wrappedResponse)
        "TargetGroupNotFound" -> TargetGroupNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyActions" -> TooManyActionsExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyCertificates" -> TooManyCertificatesExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyListeners" -> TooManyListenersExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRegistrationsForTargetId" -> TooManyRegistrationsForTargetIdExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyTargets" -> TooManyTargetsExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyUniqueTargetGroupsPerLoadBalancer" -> TooManyUniqueTargetGroupsPerLoadBalancerExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedProtocol" -> UnsupportedProtocolExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeModifyListenerOperationBody(builder: ModifyListenerResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ModifyListenerResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("ModifyListenerResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap ModifyListener response")
    }
    // end unwrap response wrapper

    val LISTENERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("Listeners"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2015-12-01/"))
        trait(XmlSerialName("ModifyListenerResult"))
        field(LISTENERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LISTENERS_DESCRIPTOR.index -> builder.listeners =
                    deserializer.deserializeList(LISTENERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Listener>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListenerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
