// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseRestXmlErrorResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.AvailabilityZone
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.IpAddressType
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.SetSubnetsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.DeserializationException
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import kotlin.collections.mutableListOf


internal class SetSubnetsOperationDeserializer: HttpDeserialize<SetSubnetsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SetSubnetsResponse {
        if (!response.status.isSuccess()) {
            throwSetSubnetsError(context, response)
        }
        val builder = SetSubnetsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSetSubnetsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSetSubnetsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw ElasticLoadBalancingV2Exception("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AllocationIdNotFound" -> AllocationIdNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "AvailabilityZoneNotSupported" -> AvailabilityZoneNotSupportedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidConfigurationRequest" -> InvalidConfigurationRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidSubnet" -> InvalidSubnetExceptionDeserializer().deserialize(context, wrappedResponse)
        "LoadBalancerNotFound" -> LoadBalancerNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "SubnetNotFound" -> SubnetNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticLoadBalancingV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSetSubnetsOperationBody(builder: SetSubnetsResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    // begin unwrap response wrapper
    val resultDescriptor = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("SetSubnetsResult"))
    val wrapperDescriptor = SdkObjectDescriptor.build {
        trait(XmlSerialName("SetSubnetsResponse"))
        field(resultDescriptor)
    }

    val wrapper = deserializer.deserializeStruct(wrapperDescriptor)
    if (wrapper.findNextFieldIndex() != resultDescriptor.index) {
        throw DeserializationException("failed to unwrap SetSubnets response")
    }
    // end unwrap response wrapper

    val AVAILABILITYZONES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("AvailabilityZones"))
    val IPADDRESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("IpAddressType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://elasticloadbalancing.amazonaws.com/doc/2015-12-01/"))
        trait(XmlSerialName("SetSubnetsResult"))
        field(AVAILABILITYZONES_DESCRIPTOR)
        field(IPADDRESSTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AVAILABILITYZONES_DESCRIPTOR.index -> builder.availabilityZones =
                    deserializer.deserializeList(AVAILABILITYZONES_DESCRIPTOR) {
                        val col0 = mutableListOf<AvailabilityZone>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAvailabilityZoneDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                IPADDRESSTYPE_DESCRIPTOR.index -> builder.ipAddressType = deserializeString().let { IpAddressType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
