// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elasticloadbalancingv2.waiters

import aws.sdk.kotlin.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest
import aws.sdk.kotlin.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import aws.smithy.kotlin.runtime.retries.policy.SuccessAcceptor
import aws.smithy.kotlin.runtime.util.flattenIfPossible
import kotlin.time.Duration.Companion.milliseconds


public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancerAvailable(request: DescribeLoadBalancersRequest): Outcome<DescribeLoadBalancersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val loadBalancers = it?.loadBalancers
            val loadBalancersOrEmpty = loadBalancers?.flattenIfPossible() ?: listOf()
            val projection = loadBalancersOrEmpty.flatMap {
                val state = it?.state
                val code = state?.code
                listOfNotNull(code)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "active" }
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val loadBalancers = it?.loadBalancers
            val loadBalancersOrEmpty = loadBalancers?.flattenIfPossible() ?: listOf()
            val projection = loadBalancersOrEmpty.flatMap {
                val state = it?.state
                val code = state?.code
                listOfNotNull(code)
            }
            projection?.any { it?.toString() == "provisioning" } ?: false
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "LoadBalancerNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeLoadBalancers(request) }
}

public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancerAvailable(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Outcome<DescribeLoadBalancersResponse> =
    waitUntilLoadBalancerAvailable(DescribeLoadBalancersRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancerExists(request: DescribeLoadBalancersRequest): Outcome<DescribeLoadBalancersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>>(
        SuccessAcceptor(RetryDirective.TerminateAndSucceed, true),
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "LoadBalancerNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeLoadBalancers(request) }
}

public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancerExists(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Outcome<DescribeLoadBalancersResponse> =
    waitUntilLoadBalancerExists(DescribeLoadBalancersRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancersDeleted(request: DescribeLoadBalancersRequest): Outcome<DescribeLoadBalancersResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>>(
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val loadBalancers = it?.loadBalancers
            val loadBalancersOrEmpty = loadBalancers?.flattenIfPossible() ?: listOf()
            val projection = loadBalancersOrEmpty.flatMap {
                val state = it?.state
                val code = state?.code
                listOfNotNull(code)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "active" }
        },
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "LoadBalancerNotFound"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeLoadBalancers(request) }
}

public suspend fun ElasticLoadBalancingV2Client.waitUntilLoadBalancersDeleted(block: DescribeLoadBalancersRequest.Builder.() -> Unit): Outcome<DescribeLoadBalancersResponse> =
    waitUntilLoadBalancersDeleted(DescribeLoadBalancersRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingV2Client.waitUntilTargetDeregistered(request: DescribeTargetHealthRequest): Outcome<DescribeTargetHealthResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeTargetHealthRequest, DescribeTargetHealthResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "InvalidTarget"),
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val targetHealthDescriptions = it?.targetHealthDescriptions
            val targetHealthDescriptionsOrEmpty = targetHealthDescriptions?.flattenIfPossible() ?: listOf()
            val projection = targetHealthDescriptionsOrEmpty.flatMap {
                val targetHealth = it?.targetHealth
                val state = targetHealth?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "unused" }
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTargetHealth(request) }
}

public suspend fun ElasticLoadBalancingV2Client.waitUntilTargetDeregistered(block: DescribeTargetHealthRequest.Builder.() -> Unit): Outcome<DescribeTargetHealthResponse> =
    waitUntilTargetDeregistered(DescribeTargetHealthRequest.Builder().apply(block).build())

public suspend fun ElasticLoadBalancingV2Client.waitUntilTargetInService(request: DescribeTargetHealthRequest): Outcome<DescribeTargetHealthResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 15_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<DescribeTargetHealthRequest, DescribeTargetHealthResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val targetHealthDescriptions = it?.targetHealthDescriptions
            val targetHealthDescriptionsOrEmpty = targetHealthDescriptions?.flattenIfPossible() ?: listOf()
            val projection = targetHealthDescriptionsOrEmpty.flatMap {
                val targetHealth = it?.targetHealth
                val state = targetHealth?.state
                listOfNotNull(state)
            }
            projection != null && projection.size > 0 && projection.all { it?.toString() == "healthy" }
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvalidInstance"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTargetHealth(request) }
}

public suspend fun ElasticLoadBalancingV2Client.waitUntilTargetInService(block: DescribeTargetHealthRequest.Builder.() -> Unit): Outcome<DescribeTargetHealthResponse> =
    waitUntilTargetInService(DescribeTargetHealthRequest.Builder().apply(block).build())
