// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elastictranscoder.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elastictranscoder.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS Elastic Transcoder Service
 * The AWS Elastic Transcoder Service.
 */
interface ElasticTranscoderClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Transcoder"
    /**
     * ElasticTranscoderClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): ElasticTranscoderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticTranscoderClient(config)
        }

        operator fun invoke(config: Config): ElasticTranscoderClient = DefaultElasticTranscoderClient(config)

        /**
         * Construct a [ElasticTranscoderClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticTranscoderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultElasticTranscoderClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The CancelJob operation cancels an unfinished job.
     *
     * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
     */
    suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * The CancelJob operation cancels an unfinished job.
     *
     * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
     */
    suspend fun cancelJob(block: CancelJobRequest.Builder.() -> Unit) = cancelJob(CancelJobRequest.Builder().apply(block).build())

    /**
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
     *
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
     */
    suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
     *
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
     */
    suspend fun createJob(block: CreateJobRequest.Builder.() -> Unit) = createJob(CreateJobRequest.Builder().apply(block).build())

    /**
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     */
    suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     */
    suspend fun createPipeline(block: CreatePipelineRequest.Builder.() -> Unit) = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

    /**
     * The CreatePreset operation creates a preset with settings that you specify.
     *
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
     *
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
     */
    suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse

    /**
     * The CreatePreset operation creates a preset with settings that you specify.
     *
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
     *
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
     */
    suspend fun createPreset(block: CreatePresetRequest.Builder.() -> Unit) = createPreset(CreatePresetRequest.Builder().apply(block).build())

    /**
     * The DeletePipeline operation removes a pipeline.
     *
     *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
     */
    suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * The DeletePipeline operation removes a pipeline.
     *
     *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
     */
    suspend fun deletePipeline(block: DeletePipelineRequest.Builder.() -> Unit) = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

    /**
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     *
     * You can't delete the default presets that are included with Elastic Transcoder.
     */
    suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse

    /**
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     *
     * You can't delete the default presets that are included with Elastic Transcoder.
     */
    suspend fun deletePreset(block: DeletePresetRequest.Builder.() -> Unit) = deletePreset(DeletePresetRequest.Builder().apply(block).build())

    /**
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     *
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
     */
    suspend fun listJobsByPipeline(input: ListJobsByPipelineRequest): ListJobsByPipelineResponse

    /**
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     *
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
     */
    suspend fun listJobsByPipeline(block: ListJobsByPipelineRequest.Builder.() -> Unit) = listJobsByPipeline(ListJobsByPipelineRequest.Builder().apply(block).build())

    /**
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
     */
    suspend fun listJobsByStatus(input: ListJobsByStatusRequest): ListJobsByStatusResponse

    /**
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
     */
    suspend fun listJobsByStatus(block: ListJobsByStatusRequest.Builder.() -> Unit) = listJobsByStatus(ListJobsByStatusRequest.Builder().apply(block).build())

    /**
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     */
    suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     */
    suspend fun listPipelines(block: ListPipelinesRequest.Builder.() -> Unit) = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

    /**
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
     */
    suspend fun listPresets(input: ListPresetsRequest = ListPresetsRequest {}): ListPresetsResponse

    /**
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
     */
    suspend fun listPresets(block: ListPresetsRequest.Builder.() -> Unit) = listPresets(ListPresetsRequest.Builder().apply(block).build())

    /**
     * The ReadJob operation returns detailed information about a job.
     */
    suspend fun readJob(input: ReadJobRequest): ReadJobResponse

    /**
     * The ReadJob operation returns detailed information about a job.
     */
    suspend fun readJob(block: ReadJobRequest.Builder.() -> Unit) = readJob(ReadJobRequest.Builder().apply(block).build())

    /**
     * The ReadPipeline operation gets detailed information about a pipeline.
     */
    suspend fun readPipeline(input: ReadPipelineRequest): ReadPipelineResponse

    /**
     * The ReadPipeline operation gets detailed information about a pipeline.
     */
    suspend fun readPipeline(block: ReadPipelineRequest.Builder.() -> Unit) = readPipeline(ReadPipelineRequest.Builder().apply(block).build())

    /**
     * The ReadPreset operation gets detailed information about a preset.
     */
    suspend fun readPreset(input: ReadPresetRequest): ReadPresetResponse

    /**
     * The ReadPreset operation gets detailed information about a preset.
     */
    suspend fun readPreset(block: ReadPresetRequest.Builder.() -> Unit) = readPreset(ReadPresetRequest.Builder().apply(block).build())

    /**
     * The TestRole operation tests the IAM role used to create the pipeline.
     *
     * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun testRole(input: TestRoleRequest): TestRoleResponse

    /**
     * The TestRole operation tests the IAM role used to create the pipeline.
     *
     * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun testRole(block: TestRoleRequest.Builder.() -> Unit) = testRole(TestRoleRequest.Builder().apply(block).build())

    /**
     * Use the `UpdatePipeline` operation to update settings for a pipeline.
     *
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
     */
    suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse

    /**
     * Use the `UpdatePipeline` operation to update settings for a pipeline.
     *
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
     */
    suspend fun updatePipeline(block: UpdatePipelineRequest.Builder.() -> Unit) = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())

    /**
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
     *
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
     */
    suspend fun updatePipelineNotifications(input: UpdatePipelineNotificationsRequest): UpdatePipelineNotificationsResponse

    /**
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
     *
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
     */
    suspend fun updatePipelineNotifications(block: UpdatePipelineNotificationsRequest.Builder.() -> Unit) = updatePipelineNotifications(UpdatePipelineNotificationsRequest.Builder().apply(block).build())

    /**
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
     *
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
     */
    suspend fun updatePipelineStatus(input: UpdatePipelineStatusRequest): UpdatePipelineStatusResponse

    /**
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
     *
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
     */
    suspend fun updatePipelineStatus(block: UpdatePipelineStatusRequest.Builder.() -> Unit) = updatePipelineStatus(UpdatePipelineStatusRequest.Builder().apply(block).build())
}
