// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The file to be used as album art. There can be multiple artworks associated with an audio file, to a maximum of 20.
 *
 * To remove artwork or leave the artwork empty, you can either set `Artwork` to null, or set the `Merge Policy` to "Replace" and use an empty `Artwork` array.
 *
 * To pass through existing artwork unchanged, set the `Merge Policy` to "Prepend", "Append", or "Fallback", and use an empty `Artwork` array.
 */
class Artwork private constructor(builder: Builder) {
    /**
     * The format of album art, if any. Valid formats are `.jpg` and `.png`.
     */
    val albumArtFormat: kotlin.String? = builder.albumArtFormat
    /**
     * The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
     */
    val encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = builder.encryption
    /**
     * The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by `PipelineId`; the `InputBucket` object in that pipeline identifies the bucket.
     *
     * If the file name includes a prefix, for example, `cooking/pie.jpg`, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
     */
    val inputKey: kotlin.String? = builder.inputKey
    /**
     * The maximum height of the output album art in pixels. If you specify `auto`, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
     */
    val maxHeight: kotlin.String? = builder.maxHeight
    /**
     * The maximum width of the output album art in pixels. If you specify `auto`, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
     */
    val maxWidth: kotlin.String? = builder.maxWidth
    /**
     * When you set `PaddingPolicy` to `Pad`, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for `MaxWidth` and `MaxHeight`.
     */
    val paddingPolicy: kotlin.String? = builder.paddingPolicy
    /**
     * Specify one of the following values to control scaling of the output album art:
     * + `Fit:` Elastic Transcoder scales the output art so it matches the value that you specified in either `MaxWidth` or `MaxHeight` without exceeding the other value.
     * + `Fill:` Elastic Transcoder scales the output art so it matches the value that you specified in either `MaxWidth` or `MaxHeight` and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value.
     * + `Stretch:` Elastic Transcoder stretches the output art to match the values that you specified for `MaxWidth` and `MaxHeight`. If the relative proportions of the input art and the output art are different, the output art will be distorted.
     * + `Keep:` Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for `MaxWidth` and `MaxHeight`, Elastic Transcoder crops the output art.
     * + `ShrinkToFit:` Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.
     * + `ShrinkToFill` Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.
     */
    val sizingPolicy: kotlin.String? = builder.sizingPolicy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Artwork = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Artwork(")
        append("albumArtFormat=$albumArtFormat,")
        append("encryption=$encryption,")
        append("inputKey=$inputKey,")
        append("maxHeight=$maxHeight,")
        append("maxWidth=$maxWidth,")
        append("paddingPolicy=$paddingPolicy,")
        append("sizingPolicy=$sizingPolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = albumArtFormat?.hashCode() ?: 0
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (inputKey?.hashCode() ?: 0)
        result = 31 * result + (maxHeight?.hashCode() ?: 0)
        result = 31 * result + (maxWidth?.hashCode() ?: 0)
        result = 31 * result + (paddingPolicy?.hashCode() ?: 0)
        result = 31 * result + (sizingPolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Artwork

        if (albumArtFormat != other.albumArtFormat) return false
        if (encryption != other.encryption) return false
        if (inputKey != other.inputKey) return false
        if (maxHeight != other.maxHeight) return false
        if (maxWidth != other.maxWidth) return false
        if (paddingPolicy != other.paddingPolicy) return false
        if (sizingPolicy != other.sizingPolicy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Artwork = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format of album art, if any. Valid formats are `.jpg` and `.png`.
         */
        var albumArtFormat: kotlin.String? = null
        /**
         * The encryption settings, if any, that you want Elastic Transcoder to apply to your artwork.
         */
        var encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = null
        /**
         * The name of the file to be used as album art. To determine which Amazon S3 bucket contains the specified file, Elastic Transcoder checks the pipeline specified by `PipelineId`; the `InputBucket` object in that pipeline identifies the bucket.
         *
         * If the file name includes a prefix, for example, `cooking/pie.jpg`, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         */
        var inputKey: kotlin.String? = null
        /**
         * The maximum height of the output album art in pixels. If you specify `auto`, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 3072, inclusive.
         */
        var maxHeight: kotlin.String? = null
        /**
         * The maximum width of the output album art in pixels. If you specify `auto`, Elastic Transcoder uses 600 as the default value. If you specify a numeric value, enter an even integer between 32 and 4096, inclusive.
         */
        var maxWidth: kotlin.String? = null
        /**
         * When you set `PaddingPolicy` to `Pad`, Elastic Transcoder may add white bars to the top and bottom and/or left and right sides of the output album art to make the total size of the output art match the values that you specified for `MaxWidth` and `MaxHeight`.
         */
        var paddingPolicy: kotlin.String? = null
        /**
         * Specify one of the following values to control scaling of the output album art:
         * + `Fit:` Elastic Transcoder scales the output art so it matches the value that you specified in either `MaxWidth` or `MaxHeight` without exceeding the other value.
         * + `Fill:` Elastic Transcoder scales the output art so it matches the value that you specified in either `MaxWidth` or `MaxHeight` and matches or exceeds the other value. Elastic Transcoder centers the output art and then crops it in the dimension (if any) that exceeds the maximum value.
         * + `Stretch:` Elastic Transcoder stretches the output art to match the values that you specified for `MaxWidth` and `MaxHeight`. If the relative proportions of the input art and the output art are different, the output art will be distorted.
         * + `Keep:` Elastic Transcoder does not scale the output art. If either dimension of the input art exceeds the values that you specified for `MaxWidth` and `MaxHeight`, Elastic Transcoder crops the output art.
         * + `ShrinkToFit:` Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale the art up.
         * + `ShrinkToFill` Elastic Transcoder scales the output art down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without dropping below either value. If you specify this option, Elastic Transcoder does not scale the art up.
         */
        var sizingPolicy: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Artwork) : this() {
            this.albumArtFormat = x.albumArtFormat
            this.encryption = x.encryption
            this.inputKey = x.inputKey
            this.maxHeight = x.maxHeight
            this.maxWidth = x.maxWidth
            this.paddingPolicy = x.paddingPolicy
            this.sizingPolicy = x.sizingPolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Artwork = Artwork(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Encryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.elastictranscoder.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.elastictranscoder.model.Encryption.invoke(block)
        }
    }
}
