// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to your output files.
 */
class HlsContentProtection private constructor(builder: Builder) {
    /**
     * If Elastic Transcoder is generating your key for you, you must leave this field blank.
     *
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
     */
    val initializationVector: kotlin.String? = builder.initializationVector
    /**
     * If you want Elastic Transcoder to generate a key for you, leave this field blank.
     *
     * If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
     *
     * `128`, `192`, or `256`.
     */
    val key: kotlin.String? = builder.key
    /**
     * If Elastic Transcoder is generating your key for you, you must leave this field blank.
     *
     * The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.
     */
    val keyMd5: kotlin.String? = builder.keyMd5
    /**
     * Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose `WithVariantPlaylists`, `LicenseAcquisitionUrl` must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.
     */
    val keyStoragePolicy: kotlin.String? = builder.keyStoragePolicy
    /**
     * The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
     */
    val licenseAcquisitionUrl: kotlin.String? = builder.licenseAcquisitionUrl
    /**
     * The content protection method for your output. The only valid value is: `aes-128`.
     *
     * This value is written into the method attribute of the `EXT-X-KEY` metadata tag in the output playlist.
     */
    val method: kotlin.String? = builder.method

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HlsContentProtection(")
        append("initializationVector=$initializationVector,")
        append("key=$key,")
        append("keyMd5=$keyMd5,")
        append("keyStoragePolicy=$keyStoragePolicy,")
        append("licenseAcquisitionUrl=$licenseAcquisitionUrl,")
        append("method=$method)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initializationVector?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (keyMd5?.hashCode() ?: 0)
        result = 31 * result + (keyStoragePolicy?.hashCode() ?: 0)
        result = 31 * result + (licenseAcquisitionUrl?.hashCode() ?: 0)
        result = 31 * result + (method?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HlsContentProtection

        if (initializationVector != other.initializationVector) return false
        if (key != other.key) return false
        if (keyMd5 != other.keyMd5) return false
        if (keyStoragePolicy != other.keyStoragePolicy) return false
        if (licenseAcquisitionUrl != other.licenseAcquisitionUrl) return false
        if (method != other.method) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection = Builder(this).apply(block).build()

    class Builder {
        /**
         * If Elastic Transcoder is generating your key for you, you must leave this field blank.
         *
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes before being base64-encoded.
         */
        var initializationVector: kotlin.String? = null
        /**
         * If you want Elastic Transcoder to generate a key for you, leave this field blank.
         *
         * If you choose to supply your own key, you must encrypt the key by using AWS KMS. The key must be base64-encoded, and it must be one of the following bit lengths before being base64-encoded:
         *
         * `128`, `192`, or `256`.
         */
        var key: kotlin.String? = null
        /**
         * If Elastic Transcoder is generating your key for you, you must leave this field blank.
         *
         * The MD5 digest of the key that you want Elastic Transcoder to use to encrypt your output file, and that you want Elastic Transcoder to use as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes before being base64- encoded.
         */
        var keyMd5: kotlin.String? = null
        /**
         * Specify whether you want Elastic Transcoder to write your HLS license key to an Amazon S3 bucket. If you choose `WithVariantPlaylists`, `LicenseAcquisitionUrl` must be left blank and Elastic Transcoder writes your data key into the same bucket as the associated playlist.
         */
        var keyStoragePolicy: kotlin.String? = null
        /**
         * The location of the license key required to decrypt your HLS playlist. The URL must be an absolute path, and is referenced in the URI attribute of the EXT-X-KEY metadata tag in the playlist file.
         */
        var licenseAcquisitionUrl: kotlin.String? = null
        /**
         * The content protection method for your output. The only valid value is: `aes-128`.
         *
         * This value is written into the method attribute of the `EXT-X-KEY` metadata tag in the output playlist.
         */
        var method: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection) : this() {
            this.initializationVector = x.initializationVector
            this.key = x.key
            this.keyMd5 = x.keyMd5
            this.keyStoragePolicy = x.keyStoragePolicy
            this.licenseAcquisitionUrl = x.licenseAcquisitionUrl
            this.method = x.method
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection = HlsContentProtection(this)
    }
}
