// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Information about the file that you're transcoding.
 */
class JobInput private constructor(builder: Builder) {
    /**
     * The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify `auto`. If you want to specify the aspect ratio for the output file, enter one of the following values:
     *
     * `1:1`, `4:3`, `3:2`, `16:9`
     *
     *  If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of the aspect ratio.
     */
    val aspectRatio: kotlin.String? = builder.aspectRatio
    /**
     * The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify `auto`. If you want to specify the container type for the input file, enter one of the following values:
     *
     * `3gp`, `aac`, `asf`, `avi`, `divx`, `flv`, `m4a`, `mkv`, `mov`, `mp3`, `mp4`, `mpeg`, `mpeg-ps`, `mpeg-ts`, `mxf`, `ogg`, `vob`, `wav`, `webm`
     */
    val container: kotlin.String? = builder.container
    /**
     * The detected properties of the input file.
     */
    val detectedProperties: aws.sdk.kotlin.services.elastictranscoder.model.DetectedProperties? = builder.detectedProperties
    /**
     * The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
     */
    val encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = builder.encryption
    /**
     * The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify `auto`. If you want to specify the frame rate for the input file, enter one of the following values:
     *
     * `10`, `15`, `23.97`, `24`, `25`, `29.97`, `30`, `60`
     *
     * If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of the frame rate.
     */
    val frameRate: kotlin.String? = builder.frameRate
    /**
     * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:
     * + **Embedded:** Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.Valid input values include: `CEA-608 (EIA-608`, first non-empty channel only), `CEA-708 (EIA-708`, first non-empty channel only), and `mov-text`Valid outputs include: `mov-text`Elastic Transcoder supports a maximum of one embedded format per output.
     * + **Sidecar:** Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.Valid input values include: `dfxp` (first div element only), `ebu-tt`, `scc`, `smpt`, `srt`, `ttml` (first div element only), and `webvtt`Valid outputs include: `dfxp` (first div element only), `scc`, `srt`, and `webvtt`.
     *
     * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
     *
     * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.
     *
     * To remove captions or leave the captions empty, set `Captions` to null. To pass through existing captions unchanged, set the `MergePolicy` to `MergeRetain`, and pass in a null `CaptionSources` array.
     *
     * For more information on embedded files, see the Subtitles Wikipedia page.
     *
     * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
     */
    val inputCaptions: aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions? = builder.inputCaptions
    /**
     * Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify `auto`. If you want to specify whether the input file is interlaced, enter one of the following values:
     *
     * `true`, `false`
     *
     * If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of interlacing.
     */
    val interlaced: kotlin.String? = builder.interlaced
    /**
     * The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The `InputBucket` object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from.
     *
     * If the file name includes a prefix, such as `cooking/lasagna.mpg`, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
     */
    val key: kotlin.String? = builder.key
    /**
     * This value must be `auto`, which causes Elastic Transcoder to automatically detect the resolution of the input file.
     */
    val resolution: kotlin.String? = builder.resolution
    /**
     * Settings for clipping an input. Each input can have different clip settings.
     */
    val timeSpan: aws.sdk.kotlin.services.elastictranscoder.model.TimeSpan? = builder.timeSpan

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.JobInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobInput(")
        append("aspectRatio=$aspectRatio,")
        append("container=$container,")
        append("detectedProperties=$detectedProperties,")
        append("encryption=$encryption,")
        append("frameRate=$frameRate,")
        append("inputCaptions=$inputCaptions,")
        append("interlaced=$interlaced,")
        append("key=$key,")
        append("resolution=$resolution,")
        append("timeSpan=$timeSpan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aspectRatio?.hashCode() ?: 0
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (detectedProperties?.hashCode() ?: 0)
        result = 31 * result + (encryption?.hashCode() ?: 0)
        result = 31 * result + (frameRate?.hashCode() ?: 0)
        result = 31 * result + (inputCaptions?.hashCode() ?: 0)
        result = 31 * result + (interlaced?.hashCode() ?: 0)
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (resolution?.hashCode() ?: 0)
        result = 31 * result + (timeSpan?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobInput

        if (aspectRatio != other.aspectRatio) return false
        if (container != other.container) return false
        if (detectedProperties != other.detectedProperties) return false
        if (encryption != other.encryption) return false
        if (frameRate != other.frameRate) return false
        if (inputCaptions != other.inputCaptions) return false
        if (interlaced != other.interlaced) return false
        if (key != other.key) return false
        if (resolution != other.resolution) return false
        if (timeSpan != other.timeSpan) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.JobInput = Builder(this).apply(block).build()

    class Builder {
        /**
         * The aspect ratio of the input file. If you want Elastic Transcoder to automatically detect the aspect ratio of the input file, specify `auto`. If you want to specify the aspect ratio for the output file, enter one of the following values:
         *
         * `1:1`, `4:3`, `3:2`, `16:9`
         *
         *  If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of the aspect ratio.
         */
        var aspectRatio: kotlin.String? = null
        /**
         * The container type for the input file. If you want Elastic Transcoder to automatically detect the container type of the input file, specify `auto`. If you want to specify the container type for the input file, enter one of the following values:
         *
         * `3gp`, `aac`, `asf`, `avi`, `divx`, `flv`, `m4a`, `mkv`, `mov`, `mp3`, `mp4`, `mpeg`, `mpeg-ps`, `mpeg-ts`, `mxf`, `ogg`, `vob`, `wav`, `webm`
         */
        var container: kotlin.String? = null
        /**
         * The detected properties of the input file.
         */
        var detectedProperties: aws.sdk.kotlin.services.elastictranscoder.model.DetectedProperties? = null
        /**
         * The encryption settings, if any, that are used for decrypting your input files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file.
         */
        var encryption: aws.sdk.kotlin.services.elastictranscoder.model.Encryption? = null
        /**
         * The frame rate of the input file. If you want Elastic Transcoder to automatically detect the frame rate of the input file, specify `auto`. If you want to specify the frame rate for the input file, enter one of the following values:
         *
         * `10`, `15`, `23.97`, `24`, `25`, `29.97`, `30`, `60`
         *
         * If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of the frame rate.
         */
        var frameRate: kotlin.String? = null
        /**
         * You can configure Elastic Transcoder to transcode captions, or subtitles, from one format to another. All captions must be in UTF-8. Elastic Transcoder supports two types of captions:
         * + **Embedded:** Embedded captions are included in the same file as the audio and video. Elastic Transcoder supports only one embedded caption per language, to a maximum of 300 embedded captions per file.Valid input values include: `CEA-608 (EIA-608`, first non-empty channel only), `CEA-708 (EIA-708`, first non-empty channel only), and `mov-text`Valid outputs include: `mov-text`Elastic Transcoder supports a maximum of one embedded format per output.
         * + **Sidecar:** Sidecar captions are kept in a separate metadata file from the audio and video data. Sidecar captions require a player that is capable of understanding the relationship between the video file and the sidecar file. Elastic Transcoder supports only one sidecar caption per language, to a maximum of 20 sidecar captions per file.Valid input values include: `dfxp` (first div element only), `ebu-tt`, `scc`, `smpt`, `srt`, `ttml` (first div element only), and `webvtt`Valid outputs include: `dfxp` (first div element only), `scc`, `srt`, and `webvtt`.
         *
         * If you want ttml or smpte-tt compatible captions, specify dfxp as your output format.
         *
         * Elastic Transcoder does not support OCR (Optical Character Recognition), does not accept pictures as a valid input for captions, and is not available for audio-only transcoding. Elastic Transcoder does not preserve text formatting (for example, italics) during the transcoding process.
         *
         * To remove captions or leave the captions empty, set `Captions` to null. To pass through existing captions unchanged, set the `MergePolicy` to `MergeRetain`, and pass in a null `CaptionSources` array.
         *
         * For more information on embedded files, see the Subtitles Wikipedia page.
         *
         * For more information on sidecar files, see the Extensible Metadata Platform and Sidecar file Wikipedia pages.
         */
        var inputCaptions: aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions? = null
        /**
         * Whether the input file is interlaced. If you want Elastic Transcoder to automatically detect whether the input file is interlaced, specify `auto`. If you want to specify whether the input file is interlaced, enter one of the following values:
         *
         * `true`, `false`
         *
         * If you specify a value other than `auto`, Elastic Transcoder disables automatic detection of interlacing.
         */
        var interlaced: kotlin.String? = null
        /**
         * The name of the file to transcode. Elsewhere in the body of the JSON block is the the ID of the pipeline to use for processing the job. The `InputBucket` object in that pipeline tells Elastic Transcoder which Amazon S3 bucket to get the file from.
         *
         * If the file name includes a prefix, such as `cooking/lasagna.mpg`, include the prefix in the key. If the file isn't in the specified bucket, Elastic Transcoder returns an error.
         */
        var key: kotlin.String? = null
        /**
         * This value must be `auto`, which causes Elastic Transcoder to automatically detect the resolution of the input file.
         */
        var resolution: kotlin.String? = null
        /**
         * Settings for clipping an input. Each input can have different clip settings.
         */
        var timeSpan: aws.sdk.kotlin.services.elastictranscoder.model.TimeSpan? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.JobInput) : this() {
            this.aspectRatio = x.aspectRatio
            this.container = x.container
            this.detectedProperties = x.detectedProperties
            this.encryption = x.encryption
            this.frameRate = x.frameRate
            this.inputCaptions = x.inputCaptions
            this.interlaced = x.interlaced
            this.key = x.key
            this.resolution = x.resolution
            this.timeSpan = x.timeSpan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.JobInput = JobInput(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.DetectedProperties] inside the given [block]
         */
        fun detectedProperties(block: aws.sdk.kotlin.services.elastictranscoder.model.DetectedProperties.Builder.() -> kotlin.Unit) {
            this.detectedProperties = aws.sdk.kotlin.services.elastictranscoder.model.DetectedProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Encryption] inside the given [block]
         */
        fun encryption(block: aws.sdk.kotlin.services.elastictranscoder.model.Encryption.Builder.() -> kotlin.Unit) {
            this.encryption = aws.sdk.kotlin.services.elastictranscoder.model.Encryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions] inside the given [block]
         */
        fun inputCaptions(block: aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions.Builder.() -> kotlin.Unit) {
            this.inputCaptions = aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.TimeSpan] inside the given [block]
         */
        fun timeSpan(block: aws.sdk.kotlin.services.elastictranscoder.model.TimeSpan.Builder.() -> kotlin.Unit) {
            this.timeSpan = aws.sdk.kotlin.services.elastictranscoder.model.TimeSpan.invoke(block)
        }
    }
}
