// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The Amazon Simple Notification Service (Amazon SNS) topic or topics to notify in order to report job status.
 *
 * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
 */
class Notifications private constructor(builder: Builder) {
    /**
     * The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
     */
    val completed: kotlin.String? = builder.completed
    /**
     * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
     */
    val error: kotlin.String? = builder.error
    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.
     */
    val progressing: kotlin.String? = builder.progressing
    /**
     * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
     */
    val warning: kotlin.String? = builder.warning

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Notifications = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Notifications(")
        append("completed=$completed,")
        append("error=$error,")
        append("progressing=$progressing,")
        append("warning=$warning)")
    }

    override fun hashCode(): kotlin.Int {
        var result = completed?.hashCode() ?: 0
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (progressing?.hashCode() ?: 0)
        result = 31 * result + (warning?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Notifications

        if (completed != other.completed) return false
        if (error != other.error) return false
        if (progressing != other.progressing) return false
        if (warning != other.warning) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Notifications = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
         */
        var completed: kotlin.String? = null
        /**
         * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
         */
        var error: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.
         */
        var progressing: kotlin.String? = null
        /**
         * The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
         */
        var warning: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Notifications) : this() {
            this.completed = x.completed
            this.error = x.error
            this.progressing = x.progressing
            this.warning = x.warning
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Notifications = Notifications(this)
    }
}
