// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The pipeline (queue) that is used to manage jobs.
 */
class Pipeline private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the pipeline.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     *
     * If you use either `s3` or `s3-aws-kms` as your `Encryption:Mode`, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an `Encryption:Mode` of `aes-cbc-pkcs7`, `aes-ctr`, or `aes-gcm`.
     */
    val awsKmsKeyArn: kotlin.String? = builder.awsKmsKeyArn
    /**
     * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both `ContentConfig` and `ThumbnailConfig`, or you specify `OutputBucket`.
     * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
     * + **Permissions**: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have.
     *    + GranteeType: The type of value that appears in the `Grantee` object:
     *       + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.
     *       + `Email`: The registered email address of an AWS account.
     *       + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
     *    + `Grantee`: The AWS user or group that you want to have access to transcoded files and playlists.
     *    + `Access`: The permission that you want to give to the AWS user that is listed in `Grantee`. Valid values include:
     *       + `READ`: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `READ_ACP`: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `WRITE_ACP`: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     * + **StorageClass**: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     */
    val contentConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = builder.contentConfig
    /**
     * The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.
     */
    val id: kotlin.String? = builder.id
    /**
     * The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.
     */
    val inputBucket: kotlin.String? = builder.inputBucket
    /**
     * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.
     *
     * Constraints: Maximum 40 characters
     */
    val name: kotlin.String? = builder.name
    /**
     * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
     *
     * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     *
     * + **Progressing** (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.
     * + **Complete** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
     * + **Warning** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
     * + **Error** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
     */
    val notifications: aws.sdk.kotlin.services.elastictranscoder.model.Notifications? = builder.notifications
    /**
     * The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both `ContentConfig` and `ThumbnailConfig`.
     */
    val outputBucket: kotlin.String? = builder.outputBucket
    /**
     * The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.
     */
    val role: kotlin.String? = builder.role
    /**
     * The current status of the pipeline:
     * + `Active`: The pipeline is processing jobs.
     * + `Paused`: The pipeline is not currently processing jobs.
     */
    val status: kotlin.String? = builder.status
    /**
     * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both `ContentConfig` and `ThumbnailConfig`, or you specify `OutputBucket`.
     * + `Bucket`: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     * + `Permissions`: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have.
     *    + GranteeType: The type of value that appears in the Grantee object:
     *       + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
     *       + `Email`: The registered email address of an AWS account.
     *       + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
     *    + `Grantee`: The AWS user or group that you want to have access to thumbnail files.
     *    + Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
     *       + `READ`: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     *       + `FULL_CONTROL`: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * + `StorageClass`: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     */
    val thumbnailConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = builder.thumbnailConfig

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Pipeline = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Pipeline(")
        append("arn=$arn,")
        append("awsKmsKeyArn=$awsKmsKeyArn,")
        append("contentConfig=$contentConfig,")
        append("id=$id,")
        append("inputBucket=$inputBucket,")
        append("name=$name,")
        append("notifications=$notifications,")
        append("outputBucket=$outputBucket,")
        append("role=$role,")
        append("status=$status,")
        append("thumbnailConfig=$thumbnailConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (awsKmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (contentConfig?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inputBucket?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        result = 31 * result + (outputBucket?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (thumbnailConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Pipeline

        if (arn != other.arn) return false
        if (awsKmsKeyArn != other.awsKmsKeyArn) return false
        if (contentConfig != other.contentConfig) return false
        if (id != other.id) return false
        if (inputBucket != other.inputBucket) return false
        if (name != other.name) return false
        if (notifications != other.notifications) return false
        if (outputBucket != other.outputBucket) return false
        if (role != other.role) return false
        if (status != other.status) return false
        if (thumbnailConfig != other.thumbnailConfig) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Pipeline = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the pipeline.
         */
        var arn: kotlin.String? = null
        /**
         * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         *
         * If you use either `s3` or `s3-aws-kms` as your `Encryption:Mode`, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an `Encryption:Mode` of `aes-cbc-pkcs7`, `aes-ctr`, or `aes-gcm`.
         */
        var awsKmsKeyArn: kotlin.String? = null
        /**
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists. Either you specify both `ContentConfig` and `ThumbnailConfig`, or you specify `OutputBucket`.
         * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
         * + **Permissions**: A list of the users and/or predefined Amazon S3 groups you want to have access to transcoded files and playlists, and the type of access that you want them to have.
         *    + GranteeType: The type of value that appears in the `Grantee` object:
         *       + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.
         *       + `Email`: The registered email address of an AWS account.
         *       + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
         *    + `Grantee`: The AWS user or group that you want to have access to transcoded files and playlists.
         *    + `Access`: The permission that you want to give to the AWS user that is listed in `Grantee`. Valid values include:
         *       + `READ`: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `READ_ACP`: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `WRITE_ACP`: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * + **StorageClass**: The Amazon S3 storage class, Standard or ReducedRedundancy, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         */
        var contentConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = null
        /**
         * The identifier for the pipeline. You use this value to identify the pipeline in which you want to perform a variety of operations, such as creating a job or a preset.
         */
        var id: kotlin.String? = null
        /**
         * The Amazon S3 bucket from which Elastic Transcoder gets media files for transcoding and the graphics files, if any, that you want to use for watermarks.
         */
        var inputBucket: kotlin.String? = null
        /**
         * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.
         *
         * Constraints: Maximum 40 characters
         */
        var name: kotlin.String? = null
        /**
         * The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         *
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         *
         * + **Progressing** (optional): The Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process the job.
         * + **Complete** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing the job.
         * + **Warning** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition.
         * + **Error** (optional): The Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition.
         */
        var notifications: aws.sdk.kotlin.services.elastictranscoder.model.Notifications? = null
        /**
         * The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files, thumbnails, and playlists. Either you specify this value, or you specify both `ContentConfig` and `ThumbnailConfig`.
         */
        var outputBucket: kotlin.String? = null
        /**
         * The IAM Amazon Resource Name (ARN) for the role that Elastic Transcoder uses to transcode jobs for this pipeline.
         */
        var role: kotlin.String? = null
        /**
         * The current status of the pipeline:
         * + `Active`: The pipeline is processing jobs.
         * + `Paused`: The pipeline is not currently processing jobs.
         */
        var status: kotlin.String? = null
        /**
         * Information about the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files. Either you specify both `ContentConfig` and `ThumbnailConfig`, or you specify `OutputBucket`.
         * + `Bucket`: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * + `Permissions`: A list of the users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access that you want them to have.
         *    + GranteeType: The type of value that appears in the Grantee object:
         *       + `Canonical`: Either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
         *       + `Email`: The registered email address of an AWS account.
         *       + `Group`: One of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
         *    + `Grantee`: The AWS user or group that you want to have access to thumbnail files.
         *    + Access: The permission that you want to give to the AWS user that is listed in Grantee. Valid values include:
         *       + `READ`: The grantee can read the thumbnails and metadata for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *       + `FULL_CONTROL`: The grantee has READ, READ_ACP, and WRITE_ACP permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * + `StorageClass`: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
         */
        var thumbnailConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Pipeline) : this() {
            this.arn = x.arn
            this.awsKmsKeyArn = x.awsKmsKeyArn
            this.contentConfig = x.contentConfig
            this.id = x.id
            this.inputBucket = x.inputBucket
            this.name = x.name
            this.notifications = x.notifications
            this.outputBucket = x.outputBucket
            this.role = x.role
            this.status = x.status
            this.thumbnailConfig = x.thumbnailConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Pipeline = Pipeline(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig] inside the given [block]
         */
        fun contentConfig(block: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.Builder.() -> kotlin.Unit) {
            this.contentConfig = aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Notifications] inside the given [block]
         */
        fun notifications(block: aws.sdk.kotlin.services.elastictranscoder.model.Notifications.Builder.() -> kotlin.Unit) {
            this.notifications = aws.sdk.kotlin.services.elastictranscoder.model.Notifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig] inside the given [block]
         */
        fun thumbnailConfig(block: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.Builder.() -> kotlin.Unit) {
            this.thumbnailConfig = aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.invoke(block)
        }
    }
}
