// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Use Only for Fragmented MP4 or MPEG-TS Outputs. If you specify a preset for which the value of Container is `fmp4` (Fragmented MP4) or `ts` (MPEG-TS), Playlists contains information about the master playlists that you want Elastic Transcoder to create. We recommend that you create only one master playlist per output format. The maximum number of master playlists in a job is 30.
 */
class Playlist private constructor(builder: Builder) {
    /**
     * The format of the output playlist. Valid formats include `HLSv3`, `HLSv4`, and `Smooth`.
     */
    val format: kotlin.String? = builder.format
    /**
     * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
     */
    val hlsContentProtection: aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection? = builder.hlsContentProtection
    /**
     * The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a `/` character, the section of the name before the last `/` must be identical for all `Name` objects. If you create more than one master playlist, the values of all `Name` objects must be unique.
     *
     * Elastic Transcoder automatically appends the relevant file extension to the file name (`.m3u8` for `HLSv3` and `HLSv4` playlists, and `.ism` and `.ismc` for `Smooth` playlists). If you include a file extension in `Name`, the file name will have two extensions.
     */
    val name: kotlin.String? = builder.name
    /**
     * For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.
     * + If your output is not `HLS` or does not have a segment duration set, the name of the output file is a concatenation of `OutputKeyPrefix` and `Outputs:Key`:OutputKeyPrefix`Outputs:Key`
     * + If your output is `HLSv3` and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of `.m3u8`, and a series of `.ts` files that include a five-digit sequential counter beginning with 00000:OutputKeyPrefix`Outputs:Key`.m3u8OutputKeyPrefix`Outputs:Key`00000.ts
     * + If your output is `HLSv4`, has a segment duration set, and is included in an `HLSv4` playlist, Elastic Transcoder creates an output playlist file with a file extension of `_v4.m3u8`. If the output is video, Elastic Transcoder also creates an output file with an extension of `_iframe.m3u8`:OutputKeyPrefix`Outputs:Key`_v4.m3u8OutputKeyPrefix`Outputs:Key`_iframe.m3u8OutputKeyPrefix`Outputs:Key`.ts
     *
     * Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.
     *
     * If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For `Smooth` playlists, the `Audio:Profile`, `Video:Profile`, and `Video:FrameRate` to `Video:KeyframesMaxDist` ratio must be the same for all outputs.
     */
    val outputKeys: List<String>? = builder.outputKeys
    /**
     * The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
     */
    val playReadyDrm: aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm? = builder.playReadyDrm
    /**
     * The status of the job with which the playlist is associated.
     */
    val status: kotlin.String? = builder.status
    /**
     * Information that further explains the status.
     */
    val statusDetail: kotlin.String? = builder.statusDetail

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Playlist = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Playlist(")
        append("format=$format,")
        append("hlsContentProtection=$hlsContentProtection,")
        append("name=$name,")
        append("outputKeys=$outputKeys,")
        append("playReadyDrm=$playReadyDrm,")
        append("status=$status,")
        append("statusDetail=$statusDetail)")
    }

    override fun hashCode(): kotlin.Int {
        var result = format?.hashCode() ?: 0
        result = 31 * result + (hlsContentProtection?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputKeys?.hashCode() ?: 0)
        result = 31 * result + (playReadyDrm?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusDetail?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Playlist

        if (format != other.format) return false
        if (hlsContentProtection != other.hlsContentProtection) return false
        if (name != other.name) return false
        if (outputKeys != other.outputKeys) return false
        if (playReadyDrm != other.playReadyDrm) return false
        if (status != other.status) return false
        if (statusDetail != other.statusDetail) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Playlist = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format of the output playlist. Valid formats include `HLSv3`, `HLSv4`, and `Smooth`.
         */
        var format: kotlin.String? = null
        /**
         * The HLS content protection settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
         */
        var hlsContentProtection: aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection? = null
        /**
         * The name that you want Elastic Transcoder to assign to the master playlist, for example, nyc-vacation.m3u8. If the name includes a `/` character, the section of the name before the last `/` must be identical for all `Name` objects. If you create more than one master playlist, the values of all `Name` objects must be unique.
         *
         * Elastic Transcoder automatically appends the relevant file extension to the file name (`.m3u8` for `HLSv3` and `HLSv4` playlists, and `.ism` and `.ismc` for `Smooth` playlists). If you include a file extension in `Name`, the file name will have two extensions.
         */
        var name: kotlin.String? = null
        /**
         * For each output in this job that you want to include in a master playlist, the value of the Outputs:Key object.
         * + If your output is not `HLS` or does not have a segment duration set, the name of the output file is a concatenation of `OutputKeyPrefix` and `Outputs:Key`:OutputKeyPrefix`Outputs:Key`
         * + If your output is `HLSv3` and has a segment duration set, or is not included in a playlist, Elastic Transcoder creates an output playlist file with a file extension of `.m3u8`, and a series of `.ts` files that include a five-digit sequential counter beginning with 00000:OutputKeyPrefix`Outputs:Key`.m3u8OutputKeyPrefix`Outputs:Key`00000.ts
         * + If your output is `HLSv4`, has a segment duration set, and is included in an `HLSv4` playlist, Elastic Transcoder creates an output playlist file with a file extension of `_v4.m3u8`. If the output is video, Elastic Transcoder also creates an output file with an extension of `_iframe.m3u8`:OutputKeyPrefix`Outputs:Key`_v4.m3u8OutputKeyPrefix`Outputs:Key`_iframe.m3u8OutputKeyPrefix`Outputs:Key`.ts
         *
         * Elastic Transcoder automatically appends the relevant file extension to the file name. If you include a file extension in Output Key, the file name will have two extensions.
         *
         * If you include more than one output in a playlist, any segment duration settings, clip settings, or caption settings must be the same for all outputs in the playlist. For `Smooth` playlists, the `Audio:Profile`, `Video:Profile`, and `Video:FrameRate` to `Video:KeyframesMaxDist` ratio must be the same for all outputs.
         */
        var outputKeys: List<String>? = null
        /**
         * The DRM settings, if any, that you want Elastic Transcoder to apply to the output files associated with this playlist.
         */
        var playReadyDrm: aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm? = null
        /**
         * The status of the job with which the playlist is associated.
         */
        var status: kotlin.String? = null
        /**
         * Information that further explains the status.
         */
        var statusDetail: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Playlist) : this() {
            this.format = x.format
            this.hlsContentProtection = x.hlsContentProtection
            this.name = x.name
            this.outputKeys = x.outputKeys
            this.playReadyDrm = x.playReadyDrm
            this.status = x.status
            this.statusDetail = x.statusDetail
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Playlist = Playlist(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection] inside the given [block]
         */
        fun hlsContentProtection(block: aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection.Builder.() -> kotlin.Unit) {
            this.hlsContentProtection = aws.sdk.kotlin.services.elastictranscoder.model.HlsContentProtection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm] inside the given [block]
         */
        fun playReadyDrm(block: aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm.Builder.() -> kotlin.Unit) {
            this.playReadyDrm = aws.sdk.kotlin.services.elastictranscoder.model.PlayReadyDrm.invoke(block)
        }
    }
}
