// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Presets are templates that contain most of the settings for transcoding media files from one format to another. Elastic Transcoder includes some default presets for common formats, for example, several iPod and iPhone versions. You can also create your own presets for formats that aren't included among the default presets. You specify which preset you want to use when you create a job.
 */
class Preset private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the preset.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * A section of the response body that provides information about the audio preset values.
     */
    val audio: aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters? = builder.audio
    /**
     * The container type for the output file. Valid values include `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
     */
    val container: kotlin.String? = builder.container
    /**
     * A description of the preset.
     */
    val description: kotlin.String? = builder.description
    /**
     * Identifier for the new preset. You use this value to get settings for the preset or to delete it.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the preset.
     */
    val name: kotlin.String? = builder.name
    /**
     * A section of the response body that provides information about the thumbnail preset values, if any.
     */
    val thumbnails: aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails? = builder.thumbnails
    /**
     * Whether the preset is a default preset provided by Elastic Transcoder (`System`) or a preset that you have defined (`Custom`).
     */
    val type: kotlin.String? = builder.type
    /**
     * A section of the response body that provides information about the video preset values.
     */
    val video: aws.sdk.kotlin.services.elastictranscoder.model.VideoParameters? = builder.video

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Preset = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Preset(")
        append("arn=$arn,")
        append("audio=$audio,")
        append("container=$container,")
        append("description=$description,")
        append("id=$id,")
        append("name=$name,")
        append("thumbnails=$thumbnails,")
        append("type=$type,")
        append("video=$video)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (audio?.hashCode() ?: 0)
        result = 31 * result + (container?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (thumbnails?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (video?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Preset

        if (arn != other.arn) return false
        if (audio != other.audio) return false
        if (container != other.container) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (thumbnails != other.thumbnails) return false
        if (type != other.type) return false
        if (video != other.video) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Preset = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) for the preset.
         */
        var arn: kotlin.String? = null
        /**
         * A section of the response body that provides information about the audio preset values.
         */
        var audio: aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters? = null
        /**
         * The container type for the output file. Valid values include `flac`, `flv`, `fmp4`, `gif`, `mp3`, `mp4`, `mpg`, `mxf`, `oga`, `ogg`, `ts`, and `webm`.
         */
        var container: kotlin.String? = null
        /**
         * A description of the preset.
         */
        var description: kotlin.String? = null
        /**
         * Identifier for the new preset. You use this value to get settings for the preset or to delete it.
         */
        var id: kotlin.String? = null
        /**
         * The name of the preset.
         */
        var name: kotlin.String? = null
        /**
         * A section of the response body that provides information about the thumbnail preset values, if any.
         */
        var thumbnails: aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails? = null
        /**
         * Whether the preset is a default preset provided by Elastic Transcoder (`System`) or a preset that you have defined (`Custom`).
         */
        var type: kotlin.String? = null
        /**
         * A section of the response body that provides information about the video preset values.
         */
        var video: aws.sdk.kotlin.services.elastictranscoder.model.VideoParameters? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Preset) : this() {
            this.arn = x.arn
            this.audio = x.audio
            this.container = x.container
            this.description = x.description
            this.id = x.id
            this.name = x.name
            this.thumbnails = x.thumbnails
            this.type = x.type
            this.video = x.video
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Preset = Preset(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters] inside the given [block]
         */
        fun audio(block: aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters.Builder.() -> kotlin.Unit) {
            this.audio = aws.sdk.kotlin.services.elastictranscoder.model.AudioParameters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails] inside the given [block]
         */
        fun thumbnails(block: aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails.Builder.() -> kotlin.Unit) {
            this.thumbnails = aws.sdk.kotlin.services.elastictranscoder.model.Thumbnails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.VideoParameters] inside the given [block]
         */
        fun video(block: aws.sdk.kotlin.services.elastictranscoder.model.VideoParameters.Builder.() -> kotlin.Unit) {
            this.video = aws.sdk.kotlin.services.elastictranscoder.model.VideoParameters.invoke(block)
        }
    }
}
