// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Elastic Transcoder returns a warning if the resources used by your pipeline are not in the same region as the pipeline.
 *
 * Using resources in the same region, such as your Amazon S3 buckets, Amazon SNS notification topics, and AWS KMS key, reduces processing time and prevents cross-regional charges.
 */
class Warning private constructor(builder: Builder) {
    /**
     * The code of the cross-regional warning.
     */
    val code: kotlin.String? = builder.code
    /**
     * The message explaining what resources are in a different region from the pipeline.
     *
     * AWS KMS keys must be in the same region as the pipeline.
     */
    val message: kotlin.String? = builder.message

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Warning = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Warning(")
        append("code=$code,")
        append("message=$message)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Warning

        if (code != other.code) return false
        if (message != other.message) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Warning = Builder(this).apply(block).build()

    class Builder {
        /**
         * The code of the cross-regional warning.
         */
        var code: kotlin.String? = null
        /**
         * The message explaining what resources are in a different region from the pipeline.
         *
         * AWS KMS keys must be in the same region as the pipeline.
         */
        var message: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Warning) : this() {
            this.code = x.code
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Warning = Warning(this)
    }
}
