// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ElasticTranscoderException
import aws.sdk.kotlin.services.elastictranscoder.model.Preset
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreatePresetOperationDeserializer: HttpDeserialize<CreatePresetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreatePresetResponse {
        if (!response.status.isSuccess()) {
            throwCreatePresetError(context, response)
        }
        val builder = CreatePresetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreatePresetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreatePresetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ElasticTranscoderException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncompatibleVersionException" -> IncompatibleVersionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceException" -> InternalServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ElasticTranscoderException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreatePresetOperationBody(builder: CreatePresetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PRESET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Preset"))
    val WARNING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Warning"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PRESET_DESCRIPTOR)
        field(WARNING_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PRESET_DESCRIPTOR.index -> builder.preset = deserializePresetDocument(deserializer)
                WARNING_DESCRIPTOR.index -> builder.warning = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
