// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.elastictranscoder.model.*
import aws.sdk.kotlin.services.elastictranscoder.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Elastic Transcoder"
public const val ServiceApiVersion: String = "2012-09-25"
public const val SdkVersion: String = "0.17.7-beta"

internal class DefaultElasticTranscoderClient(override val config: ElasticTranscoderClient.Config) : ElasticTranscoderClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * The CancelJob operation cancels an unfinished job.
     *
     * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
     */
    override suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse {
        val op = SdkHttpOperation.build<CancelJobRequest, CancelJobResponse> {
            serializer = CancelJobOperationSerializer()
            deserializer = CancelJobOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "CancelJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
     *
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
     */
    override suspend fun createJob(input: CreateJobRequest): CreateJobResponse {
        val op = SdkHttpOperation.build<CreateJobRequest, CreateJobResponse> {
            serializer = CreateJobOperationSerializer()
            deserializer = CreateJobOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreateJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     */
    override suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse {
        val op = SdkHttpOperation.build<CreatePipelineRequest, CreatePipelineResponse> {
            serializer = CreatePipelineOperationSerializer()
            deserializer = CreatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The CreatePreset operation creates a preset with settings that you specify.
     *
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
     *
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
     */
    override suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse {
        val op = SdkHttpOperation.build<CreatePresetRequest, CreatePresetResponse> {
            serializer = CreatePresetOperationSerializer()
            deserializer = CreatePresetOperationDeserializer()
            context {
                expectedHttpStatus = 201
                service = serviceName
                operationName = "CreatePreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The DeletePipeline operation removes a pipeline.
     *
     *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
     */
    override suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse {
        val op = SdkHttpOperation.build<DeletePipelineRequest, DeletePipelineResponse> {
            serializer = DeletePipelineOperationSerializer()
            deserializer = DeletePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeletePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     *
     * You can't delete the default presets that are included with Elastic Transcoder.
     */
    override suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse {
        val op = SdkHttpOperation.build<DeletePresetRequest, DeletePresetResponse> {
            serializer = DeletePresetOperationSerializer()
            deserializer = DeletePresetOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeletePreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     *
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
     */
    override suspend fun listJobsByPipeline(input: ListJobsByPipelineRequest): ListJobsByPipelineResponse {
        val op = SdkHttpOperation.build<ListJobsByPipelineRequest, ListJobsByPipelineResponse> {
            serializer = ListJobsByPipelineOperationSerializer()
            deserializer = ListJobsByPipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobsByPipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
     */
    override suspend fun listJobsByStatus(input: ListJobsByStatusRequest): ListJobsByStatusResponse {
        val op = SdkHttpOperation.build<ListJobsByStatusRequest, ListJobsByStatusResponse> {
            serializer = ListJobsByStatusOperationSerializer()
            deserializer = ListJobsByStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobsByStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     */
    override suspend fun listPipelines(input: ListPipelinesRequest): ListPipelinesResponse {
        val op = SdkHttpOperation.build<ListPipelinesRequest, ListPipelinesResponse> {
            serializer = ListPipelinesOperationSerializer()
            deserializer = ListPipelinesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPipelines"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
     */
    override suspend fun listPresets(input: ListPresetsRequest): ListPresetsResponse {
        val op = SdkHttpOperation.build<ListPresetsRequest, ListPresetsResponse> {
            serializer = ListPresetsOperationSerializer()
            deserializer = ListPresetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPresets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ReadJob operation returns detailed information about a job.
     */
    override suspend fun readJob(input: ReadJobRequest): ReadJobResponse {
        val op = SdkHttpOperation.build<ReadJobRequest, ReadJobResponse> {
            serializer = ReadJobOperationSerializer()
            deserializer = ReadJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReadJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ReadPipeline operation gets detailed information about a pipeline.
     */
    override suspend fun readPipeline(input: ReadPipelineRequest): ReadPipelineResponse {
        val op = SdkHttpOperation.build<ReadPipelineRequest, ReadPipelineResponse> {
            serializer = ReadPipelineOperationSerializer()
            deserializer = ReadPipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReadPipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The ReadPreset operation gets detailed information about a preset.
     */
    override suspend fun readPreset(input: ReadPresetRequest): ReadPresetResponse {
        val op = SdkHttpOperation.build<ReadPresetRequest, ReadPresetResponse> {
            serializer = ReadPresetOperationSerializer()
            deserializer = ReadPresetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ReadPreset"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The TestRole operation tests the IAM role used to create the pipeline.
     *
     * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun testRole(input: TestRoleRequest): TestRoleResponse {
        val op = SdkHttpOperation.build<TestRoleRequest, TestRoleResponse> {
            serializer = TestRoleOperationSerializer()
            deserializer = TestRoleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestRole"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Use the `UpdatePipeline` operation to update settings for a pipeline.
     *
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
     */
    override suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse {
        val op = SdkHttpOperation.build<UpdatePipelineRequest, UpdatePipelineResponse> {
            serializer = UpdatePipelineOperationSerializer()
            deserializer = UpdatePipelineOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipeline"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
     *
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
     */
    override suspend fun updatePipelineNotifications(input: UpdatePipelineNotificationsRequest): UpdatePipelineNotificationsResponse {
        val op = SdkHttpOperation.build<UpdatePipelineNotificationsRequest, UpdatePipelineNotificationsResponse> {
            serializer = UpdatePipelineNotificationsOperationSerializer()
            deserializer = UpdatePipelineNotificationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipelineNotifications"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
     *
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
     */
    override suspend fun updatePipelineStatus(input: UpdatePipelineStatusRequest): UpdatePipelineStatusResponse {
        val op = SdkHttpOperation.build<UpdatePipelineStatusRequest, UpdatePipelineStatusResponse> {
            serializer = UpdatePipelineStatusOperationSerializer()
            deserializer = UpdatePipelineStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePipelineStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "elastictranscoder"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "elastictranscoder")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
