// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Options associated with your audio codec.
 */
public class AudioCodecOptions private constructor(builder: Builder) {
    /**
     * You can only choose an audio bit depth when you specify `flac` or `pcm` for the value of Audio:Codec.
     *
     * The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.
     *
     * Valid values are `16` and `24`.
     *
     * The most common bit depth is `24`.
     */
    public val bitDepth: kotlin.String? = builder.bitDepth
    /**
     * You can only choose an audio bit order when you specify `pcm` for the value of Audio:Codec.
     *
     * The order the bits of a PCM sample are stored in.
     *
     * The supported value is `LittleEndian`.
     */
    public val bitOrder: kotlin.String? = builder.bitOrder
    /**
     * You can only choose an audio profile when you specify AAC for the value of Audio:Codec.
     *
     * Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
     * + `auto`: If you specify `auto`, Elastic Transcoder selects the profile based on the bit rate selected for the output file.
     * + `AAC-LC`: The most common AAC profile. Use for bit rates larger than 64 kbps.
     * + `HE-AAC`: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.
     * + `HE-AACv2`: Not supported on some players and devices. Use for bit rates less than 48 kbps.
     *
     * All outputs in a `Smooth` playlist must have the same value for `Profile`.
     *
     * If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.
     */
    public val profile: kotlin.String? = builder.profile
    /**
     * You can only choose whether an audio sample is signed when you specify `pcm` for the value of Audio:Codec.
     *
     * Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).
     *
     * The supported value is `Signed`.
     */
    public val signed: kotlin.String? = builder.signed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AudioCodecOptions(")
        append("bitDepth=$bitDepth,")
        append("bitOrder=$bitOrder,")
        append("profile=$profile,")
        append("signed=$signed)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bitDepth?.hashCode() ?: 0
        result = 31 * result + (bitOrder?.hashCode() ?: 0)
        result = 31 * result + (profile?.hashCode() ?: 0)
        result = 31 * result + (signed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AudioCodecOptions

        if (bitDepth != other.bitDepth) return false
        if (bitOrder != other.bitOrder) return false
        if (profile != other.profile) return false
        if (signed != other.signed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * You can only choose an audio bit depth when you specify `flac` or `pcm` for the value of Audio:Codec.
         *
         * The bit depth of a sample is how many bits of information are included in the audio samples. The higher the bit depth, the better the audio, but the larger the file.
         *
         * Valid values are `16` and `24`.
         *
         * The most common bit depth is `24`.
         */
        public var bitDepth: kotlin.String? = null
        /**
         * You can only choose an audio bit order when you specify `pcm` for the value of Audio:Codec.
         *
         * The order the bits of a PCM sample are stored in.
         *
         * The supported value is `LittleEndian`.
         */
        public var bitOrder: kotlin.String? = null
        /**
         * You can only choose an audio profile when you specify AAC for the value of Audio:Codec.
         *
         * Specify the AAC profile for the output file. Elastic Transcoder supports the following profiles:
         * + `auto`: If you specify `auto`, Elastic Transcoder selects the profile based on the bit rate selected for the output file.
         * + `AAC-LC`: The most common AAC profile. Use for bit rates larger than 64 kbps.
         * + `HE-AAC`: Not supported on some older players and devices. Use for bit rates between 40 and 80 kbps.
         * + `HE-AACv2`: Not supported on some players and devices. Use for bit rates less than 48 kbps.
         *
         * All outputs in a `Smooth` playlist must have the same value for `Profile`.
         *
         * If you created any presets before AAC profiles were added, Elastic Transcoder automatically updated your presets to use AAC-LC. You can change the value as required.
         */
        public var profile: kotlin.String? = null
        /**
         * You can only choose whether an audio sample is signed when you specify `pcm` for the value of Audio:Codec.
         *
         * Whether audio samples are represented with negative and positive numbers (signed) or only positive numbers (unsigned).
         *
         * The supported value is `Signed`.
         */
        public var signed: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions) : this() {
            this.bitDepth = x.bitDepth
            this.bitOrder = x.bitOrder
            this.profile = x.profile
            this.signed = x.signed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.AudioCodecOptions = AudioCodecOptions(this)
    }
}
