// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The captions to be created, if any.
 */
public class InputCaptions private constructor(builder: Builder) {
    /**
     * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave `CaptionSources` blank.
     */
    public val captionSources: List<CaptionSource>? = builder.captionSources
    /**
     * A policy that determines how Elastic Transcoder handles the existence of multiple captions.
     * + **MergeOverride:** Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.
     * + **MergeRetain:** Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If `CaptionSources` is empty, Elastic Transcoder omits all sidecar captions from the output files.
     * + **Override:** Elastic Transcoder transcodes only the sidecar captions that you specify in `CaptionSources`.
     *
     * `MergePolicy` cannot be null.
     */
    public val mergePolicy: kotlin.String? = builder.mergePolicy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InputCaptions(")
        append("captionSources=$captionSources,")
        append("mergePolicy=$mergePolicy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = captionSources?.hashCode() ?: 0
        result = 31 * result + (mergePolicy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InputCaptions

        if (captionSources != other.captionSources) return false
        if (mergePolicy != other.mergePolicy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Source files for the input sidecar captions used during the transcoding process. To omit all sidecar captions, leave `CaptionSources` blank.
         */
        public var captionSources: List<CaptionSource>? = null
        /**
         * A policy that determines how Elastic Transcoder handles the existence of multiple captions.
         * + **MergeOverride:** Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the sidecar captions and ignores the embedded captions for that language.
         * + **MergeRetain:** Elastic Transcoder transcodes both embedded and sidecar captions into outputs. If captions for a language are embedded in the input file and also appear in a sidecar file, Elastic Transcoder uses the embedded captions and ignores the sidecar captions for that language. If `CaptionSources` is empty, Elastic Transcoder omits all sidecar captions from the output files.
         * + **Override:** Elastic Transcoder transcodes only the sidecar captions that you specify in `CaptionSources`.
         *
         * `MergePolicy` cannot be null.
         */
        public var mergePolicy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions) : this() {
            this.captionSources = x.captionSources
            this.mergePolicy = x.mergePolicy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.InputCaptions = InputCaptions(this)
    }
}
