// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * A section of the response body that provides information about the job that is created.
 */
public class Job private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A section of the request or response body that provides information about the file that is being transcoded.
     */
    public val input: aws.sdk.kotlin.services.elastictranscoder.model.JobInput? = builder.input
    /**
     * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.
     */
    public val inputs: List<JobInput>? = builder.inputs
    /**
     * If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.
     *
     * Outputs recommended instead.
     *
     * A section of the request or response body that provides information about the transcoded (target) file.
     */
    public val output: aws.sdk.kotlin.services.elastictranscoder.model.JobOutput? = builder.output
    /**
     * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the `OutputKeyPrefix`.
     */
    public val outputKeyPrefix: kotlin.String? = builder.outputKeyPrefix
    /**
     * Information about the output files. We recommend that you use the `Outputs` syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the `Outputs` and `Output` syntaxes in the same request. You can create a maximum of 30 outputs per job.
     *
     * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.
     */
    public val outputs: List<JobOutput>? = builder.outputs
    /**
     * The `Id` of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
     */
    public val pipelineId: kotlin.String? = builder.pipelineId
    /**
     * Outputs in Fragmented MP4 or MPEG-TS format only.
     *
     * If you specify a preset in `PresetId` for which the value of `Container` is fmp4 (Fragmented MP4) or ts (MPEG-TS), `Playlists` contains information about the master playlists that you want Elastic Transcoder to create.
     *
     * The maximum number of master playlists in a job is 30.
     */
    public val playlists: List<Playlist>? = builder.playlists
    /**
     * The status of the job: `Submitted`, `Progressing`, `Complete`, `Canceled`, or `Error`.
     */
    public val status: kotlin.String? = builder.status
    /**
     * Details about the timing of a job.
     */
    public val timing: aws.sdk.kotlin.services.elastictranscoder.model.Timing? = builder.timing
    /**
     * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in `key/value` pairs, and you can add up to 10 `key/value` pairs per job. Elastic Transcoder does not guarantee that `key/value` pairs are returned in the same order in which you specify them.
     *
     * Metadata `keys` and `values` must use characters from the following list:
     * + `0-9`
     * + `A-Z` and `a-z`
     * + `Space`
     * + The following symbols: `_.:/=+-%@`
     */
    public val userMetadata: Map<String, String>? = builder.userMetadata

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Job = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Job(")
        append("arn=$arn,")
        append("id=$id,")
        append("input=$input,")
        append("inputs=$inputs,")
        append("output=$output,")
        append("outputKeyPrefix=$outputKeyPrefix,")
        append("outputs=$outputs,")
        append("pipelineId=$pipelineId,")
        append("playlists=$playlists,")
        append("status=$status,")
        append("timing=$timing,")
        append("userMetadata=$userMetadata)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (input?.hashCode() ?: 0)
        result = 31 * result + (inputs?.hashCode() ?: 0)
        result = 31 * result + (output?.hashCode() ?: 0)
        result = 31 * result + (outputKeyPrefix?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (pipelineId?.hashCode() ?: 0)
        result = 31 * result + (playlists?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (timing?.hashCode() ?: 0)
        result = 31 * result + (userMetadata?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Job

        if (arn != other.arn) return false
        if (id != other.id) return false
        if (input != other.input) return false
        if (inputs != other.inputs) return false
        if (output != other.output) return false
        if (outputKeyPrefix != other.outputKeyPrefix) return false
        if (outputs != other.outputs) return false
        if (pipelineId != other.pipelineId) return false
        if (playlists != other.playlists) return false
        if (status != other.status) return false
        if (timing != other.timing) return false
        if (userMetadata != other.userMetadata) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Job = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the job.
         */
        public var arn: kotlin.String? = null
        /**
         * The identifier that Elastic Transcoder assigned to the job. You use this value to get settings for the job or to delete the job.
         */
        public var id: kotlin.String? = null
        /**
         * A section of the request or response body that provides information about the file that is being transcoded.
         */
        public var input: aws.sdk.kotlin.services.elastictranscoder.model.JobInput? = null
        /**
         * Information about the files that you're transcoding. If you specified multiple files for this job, Elastic Transcoder stitches the files together to make one output.
         */
        public var inputs: List<JobInput>? = null
        /**
         * If you specified one output for a job, information about that output. If you specified multiple outputs for a job, the Output object lists information about the first output. This duplicates the information that is listed for the first output in the Outputs object.
         *
         * Outputs recommended instead.
         *
         * A section of the request or response body that provides information about the transcoded (target) file.
         */
        public var output: aws.sdk.kotlin.services.elastictranscoder.model.JobOutput? = null
        /**
         * The value, if any, that you want Elastic Transcoder to prepend to the names of all files that this job creates, including output files, thumbnails, and playlists. We recommend that you add a / or some other delimiter to the end of the `OutputKeyPrefix`.
         */
        public var outputKeyPrefix: kotlin.String? = null
        /**
         * Information about the output files. We recommend that you use the `Outputs` syntax for all jobs, even when you want Elastic Transcoder to transcode a file into only one format. Do not use both the `Outputs` and `Output` syntaxes in the same request. You can create a maximum of 30 outputs per job.
         *
         * If you specify more than one output for a job, Elastic Transcoder creates the files for each output in the order in which you specify them in the job.
         */
        public var outputs: List<JobOutput>? = null
        /**
         * The `Id` of the pipeline that you want Elastic Transcoder to use for transcoding. The pipeline determines several settings, including the Amazon S3 bucket from which Elastic Transcoder gets the files to transcode and the bucket into which Elastic Transcoder puts the transcoded files.
         */
        public var pipelineId: kotlin.String? = null
        /**
         * Outputs in Fragmented MP4 or MPEG-TS format only.
         *
         * If you specify a preset in `PresetId` for which the value of `Container` is fmp4 (Fragmented MP4) or ts (MPEG-TS), `Playlists` contains information about the master playlists that you want Elastic Transcoder to create.
         *
         * The maximum number of master playlists in a job is 30.
         */
        public var playlists: List<Playlist>? = null
        /**
         * The status of the job: `Submitted`, `Progressing`, `Complete`, `Canceled`, or `Error`.
         */
        public var status: kotlin.String? = null
        /**
         * Details about the timing of a job.
         */
        public var timing: aws.sdk.kotlin.services.elastictranscoder.model.Timing? = null
        /**
         * User-defined metadata that you want to associate with an Elastic Transcoder job. You specify metadata in `key/value` pairs, and you can add up to 10 `key/value` pairs per job. Elastic Transcoder does not guarantee that `key/value` pairs are returned in the same order in which you specify them.
         *
         * Metadata `keys` and `values` must use characters from the following list:
         * + `0-9`
         * + `A-Z` and `a-z`
         * + `Space`
         * + The following symbols: `_.:/=+-%@`
         */
        public var userMetadata: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Job) : this() {
            this.arn = x.arn
            this.id = x.id
            this.input = x.input
            this.inputs = x.inputs
            this.output = x.output
            this.outputKeyPrefix = x.outputKeyPrefix
            this.outputs = x.outputs
            this.pipelineId = x.pipelineId
            this.playlists = x.playlists
            this.status = x.status
            this.timing = x.timing
            this.userMetadata = x.userMetadata
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Job = Job(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.JobInput] inside the given [block]
         */
        public fun input(block: aws.sdk.kotlin.services.elastictranscoder.model.JobInput.Builder.() -> kotlin.Unit) {
            this.input = aws.sdk.kotlin.services.elastictranscoder.model.JobInput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.JobOutput] inside the given [block]
         */
        public fun output(block: aws.sdk.kotlin.services.elastictranscoder.model.JobOutput.Builder.() -> kotlin.Unit) {
            this.output = aws.sdk.kotlin.services.elastictranscoder.model.JobOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Timing] inside the given [block]
         */
        public fun timing(block: aws.sdk.kotlin.services.elastictranscoder.model.Timing.Builder.() -> kotlin.Unit) {
            this.timing = aws.sdk.kotlin.services.elastictranscoder.model.Timing.invoke(block)
        }
    }
}
