// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * Settings for the size, location, and opacity of graphics that you want Elastic Transcoder to overlay over videos that are transcoded using this preset. You can specify settings for up to four watermarks. Watermarks appear in the specified size and location, and with the specified opacity for the duration of the transcoded video.
 *
 * Watermarks can be in .png or .jpg format. If you want to display a watermark that is not rectangular, use the .png format, which supports transparency.
 *
 * When you create a job that uses this preset, you specify the .png or .jpg graphics that you want Elastic Transcoder to include in the transcoded videos. You can specify fewer graphics in the job than you specify watermark settings in the preset, which allows you to use the same preset for up to four watermarks that have different dimensions.
 */
public class PresetWatermark private constructor(builder: Builder) {
    /**
     * The horizontal position of the watermark unless you specify a non-zero value for `HorizontalOffset`:
     * + **Left**: The left edge of the watermark is aligned with the left border of the video.
     * + **Right**: The right edge of the watermark is aligned with the right border of the video.
     * + **Center**: The watermark is centered between the left and right borders.
     */
    public val horizontalAlign: kotlin.String? = builder.horizontalAlign
    /**
     * The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign:
     * + number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
     * + integer percentage (%): The range of valid values is 0 to 100.
     *
     * For example, if you specify Left for `HorizontalAlign` and 5px for `HorizontalOffset`, the left side of the watermark appears 5 pixels from the left border of the output video.
     *
     * `HorizontalOffset` is only valid when the value of `HorizontalAlign` is `Left` or `Right`. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
     *
     * Use the value of `Target` to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.
     */
    public val horizontalOffset: kotlin.String? = builder.horizontalOffset
    /**
     * A unique identifier for the settings for one watermark. The value of `Id` can be up to 40 characters long.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The maximum height of the watermark in one of the following formats:
     * + number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of `MaxHeight`.
     * + integer percentage (%): The range of valid values is 0 to 100. Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.
     *
     * If you specify the value in pixels, it must be less than or equal to the value of `MaxHeight`.
     */
    public val maxHeight: kotlin.String? = builder.maxHeight
    /**
     * The maximum width of the watermark in one of the following formats:
     * + number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of `MaxWidth`.
     * + integer percentage (%): The range of valid values is 0 to 100. Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.If you specify the value in pixels, it must be less than or equal to the value of `MaxWidth`.
     */
    public val maxWidth: kotlin.String? = builder.maxWidth
    /**
     * A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of `Opacity` is float.
     *
     * Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for `Opacity`. The .jpg file format doesn't support transparency.
     */
    public val opacity: kotlin.String? = builder.opacity
    /**
     * A value that controls scaling of the watermark:
     * + **Fit**: Elastic Transcoder scales the watermark so it matches the value that you specified in either `MaxWidth` or `MaxHeight` without exceeding the other value.
     * + **Stretch**: Elastic Transcoder stretches the watermark to match the values that you specified for `MaxWidth` and `MaxHeight`. If the relative proportions of the watermark and the values of `MaxWidth` and `MaxHeight` are different, the watermark will be distorted.
     * + **ShrinkToFit**: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.
     */
    public val sizingPolicy: kotlin.String? = builder.sizingPolicy
    /**
     * A value that determines how Elastic Transcoder interprets values that you specified for `HorizontalOffset`, `VerticalOffset`, `MaxWidth`, and `MaxHeight`:
     * + **Content**: `HorizontalOffset` and `VerticalOffset` values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, `MaxWidth` and `MaxHeight`, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.
     * + **Frame**: `HorizontalOffset` and `VerticalOffset` values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, `MaxWidth` and `MaxHeight`, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.
     */
    public val target: kotlin.String? = builder.target
    /**
     * The vertical position of the watermark unless you specify a non-zero value for `VerticalOffset`:
     * + **Top**: The top edge of the watermark is aligned with the top border of the video.
     * + **Bottom**: The bottom edge of the watermark is aligned with the bottom border of the video.
     * + **Center**: The watermark is centered between the top and bottom borders.
     */
    public val verticalAlign: kotlin.String? = builder.verticalAlign
    /**
     * `VerticalOffset`
     *
     * The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:
     * + number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of `MaxHeight`.
     * + integer percentage (%): The range of valid values is 0 to 100.
     *
     * For example, if you specify `Top` for `VerticalAlign` and `5px` for `VerticalOffset`, the top of the watermark appears 5 pixels from the top border of the output video.
     *
     * `VerticalOffset` is only valid when the value of VerticalAlign is Top or Bottom.
     *
     * If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
     *
     * Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.
     */
    public val verticalOffset: kotlin.String? = builder.verticalOffset

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.PresetWatermark = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PresetWatermark(")
        append("horizontalAlign=$horizontalAlign,")
        append("horizontalOffset=$horizontalOffset,")
        append("id=$id,")
        append("maxHeight=$maxHeight,")
        append("maxWidth=$maxWidth,")
        append("opacity=$opacity,")
        append("sizingPolicy=$sizingPolicy,")
        append("target=$target,")
        append("verticalAlign=$verticalAlign,")
        append("verticalOffset=$verticalOffset)")
    }

    override fun hashCode(): kotlin.Int {
        var result = horizontalAlign?.hashCode() ?: 0
        result = 31 * result + (horizontalOffset?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (maxHeight?.hashCode() ?: 0)
        result = 31 * result + (maxWidth?.hashCode() ?: 0)
        result = 31 * result + (opacity?.hashCode() ?: 0)
        result = 31 * result + (sizingPolicy?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (verticalAlign?.hashCode() ?: 0)
        result = 31 * result + (verticalOffset?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PresetWatermark

        if (horizontalAlign != other.horizontalAlign) return false
        if (horizontalOffset != other.horizontalOffset) return false
        if (id != other.id) return false
        if (maxHeight != other.maxHeight) return false
        if (maxWidth != other.maxWidth) return false
        if (opacity != other.opacity) return false
        if (sizingPolicy != other.sizingPolicy) return false
        if (target != other.target) return false
        if (verticalAlign != other.verticalAlign) return false
        if (verticalOffset != other.verticalOffset) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.PresetWatermark = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The horizontal position of the watermark unless you specify a non-zero value for `HorizontalOffset`:
         * + **Left**: The left edge of the watermark is aligned with the left border of the video.
         * + **Right**: The right edge of the watermark is aligned with the right border of the video.
         * + **Center**: The watermark is centered between the left and right borders.
         */
        public var horizontalAlign: kotlin.String? = null
        /**
         * The amount by which you want the horizontal position of the watermark to be offset from the position specified by HorizontalAlign:
         * + number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of MaxWidth.
         * + integer percentage (%): The range of valid values is 0 to 100.
         *
         * For example, if you specify Left for `HorizontalAlign` and 5px for `HorizontalOffset`, the left side of the watermark appears 5 pixels from the left border of the output video.
         *
         * `HorizontalOffset` is only valid when the value of `HorizontalAlign` is `Left` or `Right`. If you specify an offset that causes the watermark to extend beyond the left or right border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
         *
         * Use the value of `Target` to specify whether you want to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.
         */
        public var horizontalOffset: kotlin.String? = null
        /**
         * A unique identifier for the settings for one watermark. The value of `Id` can be up to 40 characters long.
         */
        public var id: kotlin.String? = null
        /**
         * The maximum height of the watermark in one of the following formats:
         * + number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of `MaxHeight`.
         * + integer percentage (%): The range of valid values is 0 to 100. Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.
         *
         * If you specify the value in pixels, it must be less than or equal to the value of `MaxHeight`.
         */
        public var maxHeight: kotlin.String? = null
        /**
         * The maximum width of the watermark in one of the following formats:
         * + number of pixels (px): The minimum value is 16 pixels, and the maximum value is the value of `MaxWidth`.
         * + integer percentage (%): The range of valid values is 0 to 100. Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the calculation.If you specify the value in pixels, it must be less than or equal to the value of `MaxWidth`.
         */
        public var maxWidth: kotlin.String? = null
        /**
         * A percentage that indicates how much you want a watermark to obscure the video in the location where it appears. Valid values are 0 (the watermark is invisible) to 100 (the watermark completely obscures the video in the specified location). The datatype of `Opacity` is float.
         *
         * Elastic Transcoder supports transparent .png graphics. If you use a transparent .png, the transparent portion of the video appears as if you had specified a value of 0 for `Opacity`. The .jpg file format doesn't support transparency.
         */
        public var opacity: kotlin.String? = null
        /**
         * A value that controls scaling of the watermark:
         * + **Fit**: Elastic Transcoder scales the watermark so it matches the value that you specified in either `MaxWidth` or `MaxHeight` without exceeding the other value.
         * + **Stretch**: Elastic Transcoder stretches the watermark to match the values that you specified for `MaxWidth` and `MaxHeight`. If the relative proportions of the watermark and the values of `MaxWidth` and `MaxHeight` are different, the watermark will be distorted.
         * + **ShrinkToFit**: Elastic Transcoder scales the watermark down so that its dimensions match the values that you specified for at least one of `MaxWidth` and `MaxHeight` without exceeding either value. If you specify this option, Elastic Transcoder does not scale the watermark up.
         */
        public var sizingPolicy: kotlin.String? = null
        /**
         * A value that determines how Elastic Transcoder interprets values that you specified for `HorizontalOffset`, `VerticalOffset`, `MaxWidth`, and `MaxHeight`:
         * + **Content**: `HorizontalOffset` and `VerticalOffset` values are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any. In addition, `MaxWidth` and `MaxHeight`, if specified as a percentage, are calculated based on the borders of the video excluding black bars added by Elastic Transcoder, if any.
         * + **Frame**: `HorizontalOffset` and `VerticalOffset` values are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any. In addition, `MaxWidth` and `MaxHeight`, if specified as a percentage, are calculated based on the borders of the video including black bars added by Elastic Transcoder, if any.
         */
        public var target: kotlin.String? = null
        /**
         * The vertical position of the watermark unless you specify a non-zero value for `VerticalOffset`:
         * + **Top**: The top edge of the watermark is aligned with the top border of the video.
         * + **Bottom**: The bottom edge of the watermark is aligned with the bottom border of the video.
         * + **Center**: The watermark is centered between the top and bottom borders.
         */
        public var verticalAlign: kotlin.String? = null
        /**
         * `VerticalOffset`
         *
         * The amount by which you want the vertical position of the watermark to be offset from the position specified by VerticalAlign:
         * + number of pixels (px): The minimum value is 0 pixels, and the maximum value is the value of `MaxHeight`.
         * + integer percentage (%): The range of valid values is 0 to 100.
         *
         * For example, if you specify `Top` for `VerticalAlign` and `5px` for `VerticalOffset`, the top of the watermark appears 5 pixels from the top border of the output video.
         *
         * `VerticalOffset` is only valid when the value of VerticalAlign is Top or Bottom.
         *
         * If you specify an offset that causes the watermark to extend beyond the top or bottom border and Elastic Transcoder has not added black bars, the watermark is cropped. If Elastic Transcoder has added black bars, the watermark extends into the black bars. If the watermark extends beyond the black bars, it is cropped.
         *
         * Use the value of `Target` to specify whether you want Elastic Transcoder to include the black bars that are added by Elastic Transcoder, if any, in the offset calculation.
         */
        public var verticalOffset: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.PresetWatermark) : this() {
            this.horizontalAlign = x.horizontalAlign
            this.horizontalOffset = x.horizontalOffset
            this.id = x.id
            this.maxHeight = x.maxHeight
            this.maxWidth = x.maxWidth
            this.opacity = x.opacity
            this.sizingPolicy = x.sizingPolicy
            this.target = x.target
            this.verticalAlign = x.verticalAlign
            this.verticalOffset = x.verticalOffset
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.PresetWatermark = PresetWatermark(this)
    }
}
