// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The `UpdatePipelineRequest` structure.
 */
public class UpdatePipelineRequest private constructor(builder: Builder) {
    /**
     * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
     *
     * If you use either `s3` or `s3-aws-kms` as your `Encryption:Mode`, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an `Encryption:Mode` of `aes-cbc-pkcs7`, `aes-ctr`, or `aes-gcm`.
     */
    public val awsKmsKeyArn: kotlin.String? = builder.awsKmsKeyArn
    /**
     * The optional `ContentConfig` object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.
     *
     * If you specify values for `ContentConfig`, you must also specify values for `ThumbnailConfig`.
     *
     * If you specify values for `ContentConfig` and `ThumbnailConfig`, omit the `OutputBucket` object.
     * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
     * + **Permissions** (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     * + **Grantee Type**: Specify the type of value that appears in the `Grantee` object:
     *    + **Canonical**: The value in the `Grantee` object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.A canonical user ID is not the same as an AWS account number.
     *    + **Email**: The value in the `Grantee` object is the registered email address of an AWS account.
     *    + **Group**: The value in the `Grantee` object is one of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
     * + **Grantee**: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group
     * + **Access**: The permission that you want to give to the AWS user that you specified in `Grantee`. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include:
     *    + `READ`: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `READ_ACP`: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `WRITE_ACP`: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
     * + **StorageClass**: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
     */
    public val contentConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = builder.contentConfig
    /**
     * The ID of the pipeline that you want to update.
     */
    public val id: kotlin.String? = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
     */
    public val inputBucket: kotlin.String? = builder.inputBucket
    /**
     * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.
     *
     * Constraints: Maximum 40 characters
     */
    public val name: kotlin.String? = builder.name
    /**
     * The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
     *
     * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
     *
     * + **Progressing**: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.
     * + **Complete**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
     * + **Warning**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
     * + **Error**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
     */
    public val notifications: aws.sdk.kotlin.services.elastictranscoder.model.Notifications? = builder.notifications
    /**
     * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
     */
    public val role: kotlin.String? = builder.role
    /**
     * The `ThumbnailConfig` object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.
     *
     * If you specify values for `ContentConfig`, you must also specify values for `ThumbnailConfig` even if you don't want to create thumbnails.
     *
     * If you specify values for `ContentConfig` and `ThumbnailConfig`, omit the `OutputBucket` object.
     * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
     * + **Permissions** (Optional): The `Permissions` object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
     * + **GranteeType**: Specify the type of value that appears in the Grantee object:
     *    + **Canonical**: The value in the `Grantee` object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
     *    + **Email**: The value in the `Grantee` object is the registered email address of an AWS account.
     *    + **Group**: The value in the `Grantee` object is one of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
     * + **Grantee**: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
     * + **Access**: The permission that you want to give to the AWS user that you specified in `Grantee`. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include:
     *    + `READ`: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     *    + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
     * + **StorageClass**: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
     */
    public val thumbnailConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = builder.thumbnailConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePipelineRequest(")
        append("awsKmsKeyArn=$awsKmsKeyArn,")
        append("contentConfig=$contentConfig,")
        append("id=$id,")
        append("inputBucket=$inputBucket,")
        append("name=$name,")
        append("notifications=$notifications,")
        append("role=$role,")
        append("thumbnailConfig=$thumbnailConfig)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsKmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (contentConfig?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inputBucket?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        result = 31 * result + (role?.hashCode() ?: 0)
        result = 31 * result + (thumbnailConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePipelineRequest

        if (awsKmsKeyArn != other.awsKmsKeyArn) return false
        if (contentConfig != other.contentConfig) return false
        if (id != other.id) return false
        if (inputBucket != other.inputBucket) return false
        if (name != other.name) return false
        if (notifications != other.notifications) return false
        if (role != other.role) return false
        if (thumbnailConfig != other.thumbnailConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AWS Key Management Service (AWS KMS) key that you want to use with this pipeline.
         *
         * If you use either `s3` or `s3-aws-kms` as your `Encryption:Mode`, you don't need to provide a key with your job because a default key, known as an AWS-KMS key, is created for you automatically. You need to provide an AWS-KMS key only if you want to use a non-default AWS-KMS key, or if you are using an `Encryption:Mode` of `aes-cbc-pkcs7`, `aes-ctr`, or `aes-gcm`.
         */
        public var awsKmsKeyArn: kotlin.String? = null
        /**
         * The optional `ContentConfig` object specifies information about the Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists: which bucket to use, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.
         *
         * If you specify values for `ContentConfig`, you must also specify values for `ThumbnailConfig`.
         *
         * If you specify values for `ContentConfig` and `ThumbnailConfig`, omit the `OutputBucket` object.
         * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save transcoded files and playlists.
         * + **Permissions** (Optional): The Permissions object specifies which users you want to have access to transcoded files and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * + **Grantee Type**: Specify the type of value that appears in the `Grantee` object:
         *    + **Canonical**: The value in the `Grantee` object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution. For more information about canonical user IDs, see Access Control List (ACL) Overview in the Amazon Simple Storage Service Developer Guide. For more information about using CloudFront origin access identities to require that users use CloudFront URLs instead of Amazon S3 URLs, see Using an Origin Access Identity to Restrict Access to Your Amazon S3 Content.A canonical user ID is not the same as an AWS account number.
         *    + **Email**: The value in the `Grantee` object is the registered email address of an AWS account.
         *    + **Group**: The value in the `Grantee` object is one of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
         * + **Grantee**: The AWS user or group that you want to have access to transcoded files and playlists. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group
         * + **Access**: The permission that you want to give to the AWS user that you specified in `Grantee`. Permissions are granted on the files that Elastic Transcoder adds to the bucket, including playlists and video files. Valid values include:
         *    + `READ`: The grantee can read the objects and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `READ_ACP`: The grantee can read the object ACL for objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `WRITE_ACP`: The grantee can write the ACL for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the objects that Elastic Transcoder adds to the Amazon S3 bucket.
         * + **StorageClass**: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the video files and playlists that it stores in your Amazon S3 bucket.
         */
        public var contentConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = null
        /**
         * The ID of the pipeline that you want to update.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon S3 bucket in which you saved the media files that you want to transcode and the graphics that you want to use as watermarks.
         */
        public var inputBucket: kotlin.String? = null
        /**
         * The name of the pipeline. We recommend that the name be unique within the AWS account, but uniqueness is not enforced.
         *
         * Constraints: Maximum 40 characters
         */
        public var name: kotlin.String? = null
        /**
         * The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify to report job status.
         *
         * To receive notifications, you must also subscribe to the new topic in the Amazon SNS console.
         *
         * + **Progressing**: The topic ARN for the Amazon Simple Notification Service (Amazon SNS) topic that you want to notify when Elastic Transcoder has started to process jobs that are added to this pipeline. This is the ARN that Amazon SNS returned when you created the topic.
         * + **Complete**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder has finished processing a job. This is the ARN that Amazon SNS returned when you created the topic.
         * + **Warning**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters a warning condition. This is the ARN that Amazon SNS returned when you created the topic.
         * + **Error**: The topic ARN for the Amazon SNS topic that you want to notify when Elastic Transcoder encounters an error condition. This is the ARN that Amazon SNS returned when you created the topic.
         */
        public var notifications: aws.sdk.kotlin.services.elastictranscoder.model.Notifications? = null
        /**
         * The IAM Amazon Resource Name (ARN) for the role that you want Elastic Transcoder to use to transcode jobs for this pipeline.
         */
        public var role: kotlin.String? = null
        /**
         * The `ThumbnailConfig` object specifies several values, including the Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files, which users you want to have access to the files, the type of access you want users to have, and the storage class that you want to assign to the files.
         *
         * If you specify values for `ContentConfig`, you must also specify values for `ThumbnailConfig` even if you don't want to create thumbnails.
         *
         * If you specify values for `ContentConfig` and `ThumbnailConfig`, omit the `OutputBucket` object.
         * + **Bucket**: The Amazon S3 bucket in which you want Elastic Transcoder to save thumbnail files.
         * + **Permissions** (Optional): The `Permissions` object specifies which users and/or predefined Amazon S3 groups you want to have access to thumbnail files, and the type of access you want them to have. You can grant permissions to a maximum of 30 users and/or predefined Amazon S3 groups.
         * + **GranteeType**: Specify the type of value that appears in the Grantee object:
         *    + **Canonical**: The value in the `Grantee` object is either the canonical user ID for an AWS account or an origin access identity for an Amazon CloudFront distribution.A canonical user ID is not the same as an AWS account number.
         *    + **Email**: The value in the `Grantee` object is the registered email address of an AWS account.
         *    + **Group**: The value in the `Grantee` object is one of the following predefined Amazon S3 groups: `AllUsers`, `AuthenticatedUsers`, or `LogDelivery`.
         * + **Grantee**: The AWS user or group that you want to have access to thumbnail files. To identify the user or group, you can specify the canonical user ID for an AWS account, an origin access identity for a CloudFront distribution, the registered email address of an AWS account, or a predefined Amazon S3 group.
         * + **Access**: The permission that you want to give to the AWS user that you specified in `Grantee`. Permissions are granted on the thumbnail files that Elastic Transcoder adds to the bucket. Valid values include:
         *    + `READ`: The grantee can read the thumbnails and metadata for objects that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `READ_ACP`: The grantee can read the object ACL for thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `WRITE_ACP`: The grantee can write the ACL for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         *    + `FULL_CONTROL`: The grantee has `READ`, `READ_ACP`, and `WRITE_ACP` permissions for the thumbnails that Elastic Transcoder adds to the Amazon S3 bucket.
         * + **StorageClass**: The Amazon S3 storage class, `Standard` or `ReducedRedundancy`, that you want Elastic Transcoder to assign to the thumbnails that it stores in your Amazon S3 bucket.
         */
        public var thumbnailConfig: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest) : this() {
            this.awsKmsKeyArn = x.awsKmsKeyArn
            this.contentConfig = x.contentConfig
            this.id = x.id
            this.inputBucket = x.inputBucket
            this.name = x.name
            this.notifications = x.notifications
            this.role = x.role
            this.thumbnailConfig = x.thumbnailConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest = UpdatePipelineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig] inside the given [block]
         */
        public fun contentConfig(block: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.Builder.() -> kotlin.Unit) {
            this.contentConfig = aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.Notifications] inside the given [block]
         */
        public fun notifications(block: aws.sdk.kotlin.services.elastictranscoder.model.Notifications.Builder.() -> kotlin.Unit) {
            this.notifications = aws.sdk.kotlin.services.elastictranscoder.model.Notifications.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig] inside the given [block]
         */
        public fun thumbnailConfig(block: aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.Builder.() -> kotlin.Unit) {
            this.thumbnailConfig = aws.sdk.kotlin.services.elastictranscoder.model.PipelineOutputConfig.invoke(block)
        }
    }
}
