// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.elastictranscoder.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.elastictranscoder.model.*
import aws.sdk.kotlin.services.elastictranscoder.model.CancelJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CancelJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreateJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreateJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.CreatePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.DeletePresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByPipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListJobsByStatusResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPipelinesResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ListPresetsResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadJobResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPresetRequest
import aws.sdk.kotlin.services.elastictranscoder.model.ReadPresetResponse
import aws.sdk.kotlin.services.elastictranscoder.model.TestRoleRequest
import aws.sdk.kotlin.services.elastictranscoder.model.TestRoleResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineNotificationsRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineNotificationsResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineResponse
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineStatusRequest
import aws.sdk.kotlin.services.elastictranscoder.model.UpdatePipelineStatusResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * # AWS Elastic Transcoder Service
 * The AWS Elastic Transcoder Service.
 */
public interface ElasticTranscoderClient : SdkClient {

    override val serviceName: String
        get() = "Elastic Transcoder"
    /**
     * ElasticTranscoderClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): ElasticTranscoderClient {
            val config = Config.Builder().apply(block).build()
            return DefaultElasticTranscoderClient(config)
        }

        public operator fun invoke(config: Config): ElasticTranscoderClient = DefaultElasticTranscoderClient(config)

        /**
         * Construct a [ElasticTranscoderClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): ElasticTranscoderClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultElasticTranscoderClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * The CancelJob operation cancels an unfinished job.
     *
     * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
     */
    public suspend fun cancelJob(input: CancelJobRequest): CancelJobResponse

    /**
     * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
     *
     * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
     */
    public suspend fun createJob(input: CreateJobRequest): CreateJobResponse

    /**
     * The CreatePipeline operation creates a pipeline with settings that you specify.
     */
    public suspend fun createPipeline(input: CreatePipelineRequest): CreatePipelineResponse

    /**
     * The CreatePreset operation creates a preset with settings that you specify.
     *
     * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
     *
     * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
     */
    public suspend fun createPreset(input: CreatePresetRequest): CreatePresetResponse

    /**
     * The DeletePipeline operation removes a pipeline.
     *
     *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
     */
    public suspend fun deletePipeline(input: DeletePipelineRequest): DeletePipelineResponse

    /**
     * The DeletePreset operation removes a preset that you've added in an AWS region.
     *
     * You can't delete the default presets that are included with Elastic Transcoder.
     */
    public suspend fun deletePreset(input: DeletePresetRequest): DeletePresetResponse

    /**
     * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
     *
     * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
     */
    public suspend fun listJobsByPipeline(input: ListJobsByPipelineRequest): ListJobsByPipelineResponse

    /**
     * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
     */
    public suspend fun listJobsByStatus(input: ListJobsByStatusRequest): ListJobsByStatusResponse

    /**
     * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
     */
    public suspend fun listPipelines(input: ListPipelinesRequest = ListPipelinesRequest {}): ListPipelinesResponse

    /**
     * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
     */
    public suspend fun listPresets(input: ListPresetsRequest = ListPresetsRequest {}): ListPresetsResponse

    /**
     * The ReadJob operation returns detailed information about a job.
     */
    public suspend fun readJob(input: ReadJobRequest): ReadJobResponse

    /**
     * The ReadPipeline operation gets detailed information about a pipeline.
     */
    public suspend fun readPipeline(input: ReadPipelineRequest): ReadPipelineResponse

    /**
     * The ReadPreset operation gets detailed information about a preset.
     */
    public suspend fun readPreset(input: ReadPresetRequest): ReadPresetResponse

    /**
     * The TestRole operation tests the IAM role used to create the pipeline.
     *
     * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public suspend fun testRole(input: TestRoleRequest): TestRoleResponse

    /**
     * Use the `UpdatePipeline` operation to update settings for a pipeline.
     *
     * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
     */
    public suspend fun updatePipeline(input: UpdatePipelineRequest): UpdatePipelineResponse

    /**
     * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
     *
     * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
     */
    public suspend fun updatePipelineNotifications(input: UpdatePipelineNotificationsRequest): UpdatePipelineNotificationsResponse

    /**
     * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
     *
     * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
     */
    public suspend fun updatePipelineStatus(input: UpdatePipelineStatusRequest): UpdatePipelineStatusResponse
}

/**
 * The CancelJob operation cancels an unfinished job.
 *
 * You can only cancel a job that has a status of `Submitted`. To prevent a pipeline from starting to process a job while you're getting the job identifier, use UpdatePipelineStatus to temporarily pause the pipeline.
 */
public suspend inline fun ElasticTranscoderClient.cancelJob(crossinline block: CancelJobRequest.Builder.() -> Unit): CancelJobResponse = cancelJob(CancelJobRequest.Builder().apply(block).build())

/**
 * When you create a job, Elastic Transcoder returns JSON data that includes the values that you specified plus information about the job that is created.
 *
 * If you have specified more than one output for your jobs (for example, one output for the Kindle Fire and another output for the Apple iPhone 4s), you currently must use the Elastic Transcoder API to list the jobs (as opposed to the AWS Console).
 */
public suspend inline fun ElasticTranscoderClient.createJob(crossinline block: CreateJobRequest.Builder.() -> Unit): CreateJobResponse = createJob(CreateJobRequest.Builder().apply(block).build())

/**
 * The CreatePipeline operation creates a pipeline with settings that you specify.
 */
public suspend inline fun ElasticTranscoderClient.createPipeline(crossinline block: CreatePipelineRequest.Builder.() -> Unit): CreatePipelineResponse = createPipeline(CreatePipelineRequest.Builder().apply(block).build())

/**
 * The CreatePreset operation creates a preset with settings that you specify.
 *
 * Elastic Transcoder checks the CreatePreset settings to ensure that they meet Elastic Transcoder requirements and to determine whether they comply with H.264 standards. If your settings are not valid for Elastic Transcoder, Elastic Transcoder returns an HTTP 400 response (`ValidationException`) and does not create the preset. If the settings are valid for Elastic Transcoder but aren't strictly compliant with the H.264 standard, Elastic Transcoder creates the preset and returns a warning message in the response. This helps you determine whether your settings comply with the H.264 standard while giving you greater flexibility with respect to the video that Elastic Transcoder produces.
 *
 * Elastic Transcoder uses the H.264 video-compression format. For more information, see the International Telecommunication Union publication *Recommendation ITU-T H.264: Advanced video coding for generic audiovisual services*.
 */
public suspend inline fun ElasticTranscoderClient.createPreset(crossinline block: CreatePresetRequest.Builder.() -> Unit): CreatePresetResponse = createPreset(CreatePresetRequest.Builder().apply(block).build())

/**
 * The DeletePipeline operation removes a pipeline.
 *
 *  You can only delete a pipeline that has never been used or that is not currently in use (doesn't contain any active jobs). If the pipeline is currently in use, `DeletePipeline` returns an error.
 */
public suspend inline fun ElasticTranscoderClient.deletePipeline(crossinline block: DeletePipelineRequest.Builder.() -> Unit): DeletePipelineResponse = deletePipeline(DeletePipelineRequest.Builder().apply(block).build())

/**
 * The DeletePreset operation removes a preset that you've added in an AWS region.
 *
 * You can't delete the default presets that are included with Elastic Transcoder.
 */
public suspend inline fun ElasticTranscoderClient.deletePreset(crossinline block: DeletePresetRequest.Builder.() -> Unit): DeletePresetResponse = deletePreset(DeletePresetRequest.Builder().apply(block).build())

/**
 * The ListJobsByPipeline operation gets a list of the jobs currently in a pipeline.
 *
 * Elastic Transcoder returns all of the jobs currently in the specified pipeline. The response body contains one element for each job that satisfies the search criteria.
 */
public suspend inline fun ElasticTranscoderClient.listJobsByPipeline(crossinline block: ListJobsByPipelineRequest.Builder.() -> Unit): ListJobsByPipelineResponse = listJobsByPipeline(ListJobsByPipelineRequest.Builder().apply(block).build())

/**
 * The ListJobsByStatus operation gets a list of jobs that have a specified status. The response body contains one element for each job that satisfies the search criteria.
 */
public suspend inline fun ElasticTranscoderClient.listJobsByStatus(crossinline block: ListJobsByStatusRequest.Builder.() -> Unit): ListJobsByStatusResponse = listJobsByStatus(ListJobsByStatusRequest.Builder().apply(block).build())

/**
 * The ListPipelines operation gets a list of the pipelines associated with the current AWS account.
 */
public suspend inline fun ElasticTranscoderClient.listPipelines(crossinline block: ListPipelinesRequest.Builder.() -> Unit): ListPipelinesResponse = listPipelines(ListPipelinesRequest.Builder().apply(block).build())

/**
 * The ListPresets operation gets a list of the default presets included with Elastic Transcoder and the presets that you've added in an AWS region.
 */
public suspend inline fun ElasticTranscoderClient.listPresets(crossinline block: ListPresetsRequest.Builder.() -> Unit): ListPresetsResponse = listPresets(ListPresetsRequest.Builder().apply(block).build())

/**
 * The ReadJob operation returns detailed information about a job.
 */
public suspend inline fun ElasticTranscoderClient.readJob(crossinline block: ReadJobRequest.Builder.() -> Unit): ReadJobResponse = readJob(ReadJobRequest.Builder().apply(block).build())

/**
 * The ReadPipeline operation gets detailed information about a pipeline.
 */
public suspend inline fun ElasticTranscoderClient.readPipeline(crossinline block: ReadPipelineRequest.Builder.() -> Unit): ReadPipelineResponse = readPipeline(ReadPipelineRequest.Builder().apply(block).build())

/**
 * The ReadPreset operation gets detailed information about a preset.
 */
public suspend inline fun ElasticTranscoderClient.readPreset(crossinline block: ReadPresetRequest.Builder.() -> Unit): ReadPresetResponse = readPreset(ReadPresetRequest.Builder().apply(block).build())

/**
 * The TestRole operation tests the IAM role used to create the pipeline.
 *
 * The `TestRole` action lets you determine whether the IAM role you are using has sufficient permissions to let Elastic Transcoder perform tasks associated with the transcoding process. The action attempts to assume the specified IAM role, checks read access to the input and output buckets, and tries to send a test notification to Amazon SNS topics that you specify.
 */
@Deprecated("No longer recommended for use. See AWS API documentation for more details.")
public suspend inline fun ElasticTranscoderClient.testRole(crossinline block: TestRoleRequest.Builder.() -> Unit): TestRoleResponse = testRole(TestRoleRequest.Builder().apply(block).build())

/**
 * Use the `UpdatePipeline` operation to update settings for a pipeline.
 *
 * When you change pipeline settings, your changes take effect immediately. Jobs that you have already submitted and that Elastic Transcoder has not started to process are affected in addition to jobs that you submit after you change settings.
 */
public suspend inline fun ElasticTranscoderClient.updatePipeline(crossinline block: UpdatePipelineRequest.Builder.() -> Unit): UpdatePipelineResponse = updatePipeline(UpdatePipelineRequest.Builder().apply(block).build())

/**
 * With the UpdatePipelineNotifications operation, you can update Amazon Simple Notification Service (Amazon SNS) notifications for a pipeline.
 *
 * When you update notifications for a pipeline, Elastic Transcoder returns the values that you specified in the request.
 */
public suspend inline fun ElasticTranscoderClient.updatePipelineNotifications(crossinline block: UpdatePipelineNotificationsRequest.Builder.() -> Unit): UpdatePipelineNotificationsResponse = updatePipelineNotifications(UpdatePipelineNotificationsRequest.Builder().apply(block).build())

/**
 * The UpdatePipelineStatus operation pauses or reactivates a pipeline, so that the pipeline stops or restarts the processing of jobs.
 *
 * Changing the pipeline status is useful if you want to cancel one or more jobs. You can't cancel jobs after Elastic Transcoder has started processing them; if you pause the pipeline to which you submitted the jobs, you have more time to get the job IDs for the jobs that you want to cancel, and to send a CancelJob request.
 */
public suspend inline fun ElasticTranscoderClient.updatePipelineStatus(crossinline block: UpdatePipelineStatusRequest.Builder.() -> Unit): UpdatePipelineStatusResponse = updatePipelineStatus(UpdatePipelineStatusRequest.Builder().apply(block).build())
