// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.elastictranscoder.model



/**
 * The encryption settings, if any, that are used for decrypting your input files or encrypting your output files. If your input file is encrypted, you must specify the mode that Elastic Transcoder uses to decrypt your file, otherwise you must specify the mode you want Elastic Transcoder to use to encrypt your output files.
 */
public class Encryption private constructor(builder: Builder) {
    /**
     * The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.
     */
    public val initializationVector: kotlin.String? = builder.initializationVector
    /**
     * The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:
     *
     * `128`, `192`, or `256`.
     *
     * The key must also be encrypted by using the Amazon Key Management Service.
     */
    public val key: kotlin.String? = builder.key
    /**
     * The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.
     */
    public val keyMd5: kotlin.String? = builder.keyMd5
    /**
     * The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:
     * + **s3:** Amazon S3 creates and manages the keys used for encrypting your files.
     * + **s3-aws-kms:** Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify `s3-aws-kms` and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.
     * + **aes-cbc-pkcs7:** A padded cipher-block mode of operation originally used for HLS files.
     * + **aes-ctr:** AES Counter Mode.
     * + **aes-gcm:** AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.
     *
     * For all three AES options, you must provide the following settings, which must be base64-encoded:
     * + **Key**
     * + **Key MD5**
     * + **Initialization Vector**
     *
     * For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.
     */
    public val mode: kotlin.String? = builder.mode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.elastictranscoder.model.Encryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Encryption(")
        append("initializationVector=$initializationVector,")
        append("key=$key,")
        append("keyMd5=$keyMd5,")
        append("mode=$mode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = initializationVector?.hashCode() ?: 0
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (keyMd5?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Encryption

        if (initializationVector != other.initializationVector) return false
        if (key != other.key) return false
        if (keyMd5 != other.keyMd5) return false
        if (mode != other.mode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.elastictranscoder.model.Encryption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The series of random bits created by a random bit generator, unique for every encryption operation, that you used to encrypt your input files or that you want Elastic Transcoder to use to encrypt your output files. The initialization vector must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.
         */
        public var initializationVector: kotlin.String? = null
        /**
         * The data encryption key that you want Elastic Transcoder to use to encrypt your output file, or that was used to encrypt your input file. The key must be base64-encoded and it must be one of the following bit lengths before being base64-encoded:
         *
         * `128`, `192`, or `256`.
         *
         * The key must also be encrypted by using the Amazon Key Management Service.
         */
        public var key: kotlin.String? = null
        /**
         * The MD5 digest of the key that you used to encrypt your input file, or that you want Elastic Transcoder to use to encrypt your output file. Elastic Transcoder uses the key digest as a checksum to make sure your key was not corrupted in transit. The key MD5 must be base64-encoded, and it must be exactly 16 bytes long before being base64-encoded.
         */
        public var keyMd5: kotlin.String? = null
        /**
         * The specific server-side encryption mode that you want Elastic Transcoder to use when decrypting your input files or encrypting your output files. Elastic Transcoder supports the following options:
         * + **s3:** Amazon S3 creates and manages the keys used for encrypting your files.
         * + **s3-aws-kms:** Amazon S3 calls the Amazon Key Management Service, which creates and manages the keys that are used for encrypting your files. If you specify `s3-aws-kms` and you don't want to use the default key, you must add the AWS-KMS key that you want to use to your pipeline.
         * + **aes-cbc-pkcs7:** A padded cipher-block mode of operation originally used for HLS files.
         * + **aes-ctr:** AES Counter Mode.
         * + **aes-gcm:** AES Galois Counter Mode, a mode of operation that is an authenticated encryption format, meaning that a file, key, or initialization vector that has been tampered with fails the decryption process.
         *
         * For all three AES options, you must provide the following settings, which must be base64-encoded:
         * + **Key**
         * + **Key MD5**
         * + **Initialization Vector**
         *
         * For the AES modes, your private encryption keys and your unencrypted data are never stored by AWS; therefore, it is important that you safely manage your encryption keys. If you lose them, you won't be able to unencrypt your data.
         */
        public var mode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.elastictranscoder.model.Encryption) : this() {
            this.initializationVector = x.initializationVector
            this.key = x.key
            this.keyMd5 = x.keyMd5
            this.mode = x.mode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.elastictranscoder.model.Encryption = Encryption(this)
    }
}
