// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.emr.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.emr.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.delay.StandardRetryTokenBucketOptions

/**
 * Amazon EMR is a web service that makes it easier to process large amounts of data
 * efficiently. Amazon EMR uses Hadoop processing combined with several Amazon Web Services services to do
 * tasks such as web indexing, data mining, log file analysis, machine learning, scientific
 * simulation, and data warehouse management.
 */
interface EmrClient : SdkClient {

    override val serviceName: String
        get() = "EMR"
    /**
     * EmrClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): EmrClient {
            val config = Config.Builder().apply(block).build()
            return DefaultEmrClient(config)
        }

        operator fun invoke(config: Config): EmrClient = DefaultEmrClient(config)

        /**
         * Construct a [EmrClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): EmrClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultEmrClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds an instance fleet to a running cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x.
     */
    suspend fun addInstanceFleet(input: AddInstanceFleetRequest): AddInstanceFleetResponse

    /**
     * Adds an instance fleet to a running cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x.
     */
    suspend fun addInstanceFleet(block: AddInstanceFleetRequest.Builder.() -> Unit) = addInstanceFleet(AddInstanceFleetRequest.Builder().apply(block).build())

    /**
     * Adds one or more instance groups to a running cluster.
     */
    suspend fun addInstanceGroups(input: AddInstanceGroupsRequest): AddInstanceGroupsResponse

    /**
     * Adds one or more instance groups to a running cluster.
     */
    suspend fun addInstanceGroups(block: AddInstanceGroupsRequest.Builder.() -> Unit) = addInstanceGroups(AddInstanceGroupsRequest.Builder().apply(block).build())

    /**
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed
     * in each job flow.
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may
     * require more than 256 steps to process your data. You can bypass the 256-step limitation in
     * various ways, including using SSH to connect to the master node and submitting queries
     * directly to the software running on the master node, such as Hive and Hadoop. For more
     * information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a
     * Cluster in the Amazon EMR Management Guide.
     * A step specifies the location of a JAR file stored either on the master node of the
     * cluster or in Amazon S3. Each step is performed by the main function of the main class of
     * the JAR file. The main class can be specified either in the manifest of the JAR or by using
     * the MainFunction parameter of the step.
     * Amazon EMR executes each step in the order listed. For a step to be considered complete,
     * the main function must exit with a zero exit code and all Hadoop jobs started while the
     * step was running must have completed and run successfully.
     * You can only add steps to a cluster that is in one of the following states: STARTING,
     * BOOTSTRAPPING, RUNNING, or WAITING.
     *
     * The string values passed into HadoopJarStep object cannot exceed a total of 10240 characters.
     */
    suspend fun addJobFlowSteps(input: AddJobFlowStepsRequest): AddJobFlowStepsResponse

    /**
     * AddJobFlowSteps adds new steps to a running cluster. A maximum of 256 steps are allowed
     * in each job flow.
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may
     * require more than 256 steps to process your data. You can bypass the 256-step limitation in
     * various ways, including using SSH to connect to the master node and submitting queries
     * directly to the software running on the master node, such as Hive and Hadoop. For more
     * information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a
     * Cluster in the Amazon EMR Management Guide.
     * A step specifies the location of a JAR file stored either on the master node of the
     * cluster or in Amazon S3. Each step is performed by the main function of the main class of
     * the JAR file. The main class can be specified either in the manifest of the JAR or by using
     * the MainFunction parameter of the step.
     * Amazon EMR executes each step in the order listed. For a step to be considered complete,
     * the main function must exit with a zero exit code and all Hadoop jobs started while the
     * step was running must have completed and run successfully.
     * You can only add steps to a cluster that is in one of the following states: STARTING,
     * BOOTSTRAPPING, RUNNING, or WAITING.
     *
     * The string values passed into HadoopJarStep object cannot exceed a total of 10240 characters.
     */
    suspend fun addJobFlowSteps(block: AddJobFlowStepsRequest.Builder.() -> Unit) = addJobFlowSteps(AddJobFlowStepsRequest.Builder().apply(block).build())

    /**
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in
     * various ways, such as grouping clusters to track your Amazon EMR resource allocation costs.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters.
     */
    suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Adds tags to an Amazon EMR resource, such as a cluster or an Amazon EMR Studio. Tags make it easier to associate resources in
     * various ways, such as grouping clusters to track your Amazon EMR resource allocation costs.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters.
     */
    suspend fun addTags(block: AddTagsRequest.Builder.() -> Unit) = addTags(AddTagsRequest.Builder().apply(block).build())

    /**
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR
     * versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in
     * each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee
     * that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a PENDING or RUNNING state. In earlier versions of Amazon EMR, you can only cancel steps that are in a PENDING state.
     */
    suspend fun cancelSteps(input: CancelStepsRequest): CancelStepsResponse

    /**
     * Cancels a pending step or steps in a running cluster. Available only in Amazon EMR
     * versions 4.8.0 and later, excluding version 5.0.0. A maximum of 256 steps are allowed in
     * each CancelSteps request. CancelSteps is idempotent but asynchronous; it does not guarantee
     * that a step will be canceled, even if the request is successfully submitted. When you use Amazon EMR versions 5.28.0 and later, you can cancel steps that are in a PENDING or RUNNING state. In earlier versions of Amazon EMR, you can only cancel steps that are in a PENDING state.
     */
    suspend fun cancelSteps(block: CancelStepsRequest.Builder.() -> Unit) = cancelSteps(CancelStepsRequest.Builder().apply(block).build())

    /**
     * Creates a security configuration, which is stored in the service and can be specified
     * when a cluster is created.
     */
    suspend fun createSecurityConfiguration(input: CreateSecurityConfigurationRequest): CreateSecurityConfigurationResponse

    /**
     * Creates a security configuration, which is stored in the service and can be specified
     * when a cluster is created.
     */
    suspend fun createSecurityConfiguration(block: CreateSecurityConfigurationRequest.Builder.() -> Unit) = createSecurityConfiguration(CreateSecurityConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates a new Amazon EMR Studio.
     */
    suspend fun createStudio(input: CreateStudioRequest): CreateStudioResponse

    /**
     * Creates a new Amazon EMR Studio.
     */
    suspend fun createStudio(block: CreateStudioRequest.Builder.() -> Unit) = createStudio(CreateStudioRequest.Builder().apply(block).build())

    /**
     * Maps a user or group to the Amazon EMR Studio specified by StudioId, and
     * applies a session policy to refine Studio permissions for that user or group. Use CreateStudioSessionMapping to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups">Assign a user or group to your EMR Studio.
     */
    suspend fun createStudioSessionMapping(input: CreateStudioSessionMappingRequest): CreateStudioSessionMappingResponse

    /**
     * Maps a user or group to the Amazon EMR Studio specified by StudioId, and
     * applies a session policy to refine Studio permissions for that user or group. Use CreateStudioSessionMapping to assign users to a Studio when you use Amazon Web Services SSO authentication. For instructions on how to assign users to a Studio when you use IAM authentication, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-studio-manage-users.html#emr-studio-assign-users-groups">Assign a user or group to your EMR Studio.
     */
    suspend fun createStudioSessionMapping(block: CreateStudioSessionMappingRequest.Builder.() -> Unit) = createStudioSessionMapping(CreateStudioSessionMappingRequest.Builder().apply(block).build())

    /**
     * Deletes a security configuration.
     */
    suspend fun deleteSecurityConfiguration(input: DeleteSecurityConfigurationRequest): DeleteSecurityConfigurationResponse

    /**
     * Deletes a security configuration.
     */
    suspend fun deleteSecurityConfiguration(block: DeleteSecurityConfigurationRequest.Builder.() -> Unit) = deleteSecurityConfiguration(DeleteSecurityConfigurationRequest.Builder().apply(block).build())

    /**
     * Removes an Amazon EMR Studio from the Studio metadata store.
     */
    suspend fun deleteStudio(input: DeleteStudioRequest): DeleteStudioResponse

    /**
     * Removes an Amazon EMR Studio from the Studio metadata store.
     */
    suspend fun deleteStudio(block: DeleteStudioRequest.Builder.() -> Unit) = deleteStudio(DeleteStudioRequest.Builder().apply(block).build())

    /**
     * Removes a user or group from an Amazon EMR Studio.
     */
    suspend fun deleteStudioSessionMapping(input: DeleteStudioSessionMappingRequest): DeleteStudioSessionMappingResponse

    /**
     * Removes a user or group from an Amazon EMR Studio.
     */
    suspend fun deleteStudioSessionMapping(block: DeleteStudioSessionMappingRequest.Builder.() -> Unit) = deleteStudioSessionMapping(DeleteStudioSessionMappingRequest.Builder().apply(block).build())

    /**
     * Provides cluster-level details including status, hardware and software configuration,
     * VPC settings, and so on.
     */
    suspend fun describeCluster(input: DescribeClusterRequest): DescribeClusterResponse

    /**
     * Provides cluster-level details including status, hardware and software configuration,
     * VPC settings, and so on.
     */
    suspend fun describeCluster(block: DescribeClusterRequest.Builder.() -> Unit) = describeCluster(DescribeClusterRequest.Builder().apply(block).build())

    /**
     * This API is no longer supported and will eventually be removed. We recommend you use
     * ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions instead.
     * DescribeJobFlows returns a list of job flows that match all of the supplied parameters.
     * The parameters can include a list of job flow IDs, job flow states, and restrictions on job
     * flow creation date and time.
     * Regardless of supplied parameters, only job flows created within the last two months are
     * returned.
     * If no parameters are supplied, then job flows matching either of the following criteria
     * are returned:
     *
     *
     * Job flows created and completed in the last two weeks
     *
     * Job flows created within the last two months that are in one of the following
     * states: RUNNING, WAITING, SHUTTING_DOWN,
     * STARTING
     *
     *
     *
     * Amazon EMR can return a maximum of 512 job flow descriptions.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeJobFlows(input: DescribeJobFlowsRequest): DescribeJobFlowsResponse

    /**
     * This API is no longer supported and will eventually be removed. We recommend you use
     * ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions instead.
     * DescribeJobFlows returns a list of job flows that match all of the supplied parameters.
     * The parameters can include a list of job flow IDs, job flow states, and restrictions on job
     * flow creation date and time.
     * Regardless of supplied parameters, only job flows created within the last two months are
     * returned.
     * If no parameters are supplied, then job flows matching either of the following criteria
     * are returned:
     *
     *
     * Job flows created and completed in the last two weeks
     *
     * Job flows created within the last two months that are in one of the following
     * states: RUNNING, WAITING, SHUTTING_DOWN,
     * STARTING
     *
     *
     *
     * Amazon EMR can return a maximum of 512 job flow descriptions.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    suspend fun describeJobFlows(block: DescribeJobFlowsRequest.Builder.() -> Unit) = describeJobFlows(DescribeJobFlowsRequest.Builder().apply(block).build())

    /**
     * Provides details of a notebook execution.
     */
    suspend fun describeNotebookExecution(input: DescribeNotebookExecutionRequest): DescribeNotebookExecutionResponse

    /**
     * Provides details of a notebook execution.
     */
    suspend fun describeNotebookExecution(block: DescribeNotebookExecutionRequest.Builder.() -> Unit) = describeNotebookExecution(DescribeNotebookExecutionRequest.Builder().apply(block).build())

    /**
     * Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
     */
    suspend fun describeReleaseLabel(input: DescribeReleaseLabelRequest): DescribeReleaseLabelResponse

    /**
     * Provides EMR release label details, such as releases available the region where the API request is run, and the available applications for a specific EMR release label. Can also list EMR release versions that support a specified version of Spark.
     */
    suspend fun describeReleaseLabel(block: DescribeReleaseLabelRequest.Builder.() -> Unit) = describeReleaseLabel(DescribeReleaseLabelRequest.Builder().apply(block).build())

    /**
     * Provides the details of a security configuration by returning the configuration
     * JSON.
     */
    suspend fun describeSecurityConfiguration(input: DescribeSecurityConfigurationRequest): DescribeSecurityConfigurationResponse

    /**
     * Provides the details of a security configuration by returning the configuration
     * JSON.
     */
    suspend fun describeSecurityConfiguration(block: DescribeSecurityConfigurationRequest.Builder.() -> Unit) = describeSecurityConfiguration(DescribeSecurityConfigurationRequest.Builder().apply(block).build())

    /**
     * Provides more detail about the cluster step.
     */
    suspend fun describeStep(input: DescribeStepRequest): DescribeStepResponse

    /**
     * Provides more detail about the cluster step.
     */
    suspend fun describeStep(block: DescribeStepRequest.Builder.() -> Unit) = describeStep(DescribeStepRequest.Builder().apply(block).build())

    /**
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio
     * access URL, and so on.
     */
    suspend fun describeStudio(input: DescribeStudioRequest): DescribeStudioResponse

    /**
     * Returns details for the specified Amazon EMR Studio including ID, Name, VPC, Studio
     * access URL, and so on.
     */
    suspend fun describeStudio(block: DescribeStudioRequest.Builder.() -> Unit) = describeStudio(DescribeStudioRequest.Builder().apply(block).build())

    /**
     * Returns the auto-termination policy for an Amazon EMR cluster.
     */
    suspend fun getAutoTerminationPolicy(input: GetAutoTerminationPolicyRequest): GetAutoTerminationPolicyResponse

    /**
     * Returns the auto-termination policy for an Amazon EMR cluster.
     */
    suspend fun getAutoTerminationPolicy(block: GetAutoTerminationPolicyRequest.Builder.() -> Unit) = getAutoTerminationPolicy(GetAutoTerminationPolicyRequest.Builder().apply(block).build())

    /**
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the
     * current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR in the Amazon EMR Management
     * Guide.
     */
    suspend fun getBlockPublicAccessConfiguration(input: GetBlockPublicAccessConfigurationRequest): GetBlockPublicAccessConfigurationResponse

    /**
     * Returns the Amazon EMR block public access configuration for your Amazon Web Services account in the
     * current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR in the Amazon EMR Management
     * Guide.
     */
    suspend fun getBlockPublicAccessConfiguration(block: GetBlockPublicAccessConfigurationRequest.Builder.() -> Unit) = getBlockPublicAccessConfiguration(GetBlockPublicAccessConfigurationRequest.Builder().apply(block).build())

    /**
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     */
    suspend fun getManagedScalingPolicy(input: GetManagedScalingPolicyRequest): GetManagedScalingPolicyResponse

    /**
     * Fetches the attached managed scaling policy for an Amazon EMR cluster.
     */
    suspend fun getManagedScalingPolicy(block: GetManagedScalingPolicyRequest.Builder.() -> Unit) = getManagedScalingPolicy(GetManagedScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or
     * group).
     */
    suspend fun getStudioSessionMapping(input: GetStudioSessionMappingRequest): GetStudioSessionMappingResponse

    /**
     * Fetches mapping details for the specified Amazon EMR Studio and identity (user or
     * group).
     */
    suspend fun getStudioSessionMapping(block: GetStudioSessionMappingRequest.Builder.() -> Unit) = getStudioSessionMapping(GetStudioSessionMappingRequest.Builder().apply(block).build())

    /**
     * Provides information about the bootstrap actions associated with a cluster.
     */
    suspend fun listBootstrapActions(input: ListBootstrapActionsRequest): ListBootstrapActionsResponse

    /**
     * Provides information about the bootstrap actions associated with a cluster.
     */
    suspend fun listBootstrapActions(block: ListBootstrapActionsRequest.Builder.() -> Unit) = listBootstrapActions(ListBootstrapActionsRequest.Builder().apply(block).build())

    /**
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter
     * the list of clusters based on certain criteria; for example, filtering by cluster creation
     * date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but
     * returns a marker to track the paging of the cluster list across multiple ListClusters
     * calls.
     */
    suspend fun listClusters(input: ListClustersRequest): ListClustersResponse

    /**
     * Provides the status of all clusters visible to this Amazon Web Services account. Allows you to filter
     * the list of clusters based on certain criteria; for example, filtering by cluster creation
     * date and time or by status. This call returns a maximum of 50 clusters in unsorted order per call, but
     * returns a marker to track the paging of the cluster list across multiple ListClusters
     * calls.
     */
    suspend fun listClusters(block: ListClustersRequest.Builder.() -> Unit) = listClusters(ListClustersRequest.Builder().apply(block).build())

    /**
     * Lists all available details about the instance fleets in a cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions.
     */
    suspend fun listInstanceFleets(input: ListInstanceFleetsRequest): ListInstanceFleetsResponse

    /**
     * Lists all available details about the instance fleets in a cluster.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions.
     */
    suspend fun listInstanceFleets(block: ListInstanceFleetsRequest.Builder.() -> Unit) = listInstanceFleets(ListInstanceFleetsRequest.Builder().apply(block).build())

    /**
     * Provides all available details about the instance groups in a cluster.
     */
    suspend fun listInstanceGroups(input: ListInstanceGroupsRequest): ListInstanceGroupsResponse

    /**
     * Provides all available details about the instance groups in a cluster.
     */
    suspend fun listInstanceGroups(block: ListInstanceGroupsRequest.Builder.() -> Unit) = listInstanceGroups(ListInstanceGroupsRequest.Builder().apply(block).build())

    /**
     * Provides information for all active EC2 instances and EC2 instances terminated in the
     * last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are
     * considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
     */
    suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse

    /**
     * Provides information for all active EC2 instances and EC2 instances terminated in the
     * last 30 days, up to a maximum of 2,000. EC2 instances in any of the following states are
     * considered active: AWAITING_FULFILLMENT, PROVISIONING, BOOTSTRAPPING, RUNNING.
     */
    suspend fun listInstances(block: ListInstancesRequest.Builder.() -> Unit) = listInstances(ListInstancesRequest.Builder().apply(block).build())

    /**
     * Provides summaries of all notebook executions. You can filter the list based on multiple
     * criteria such as status, time range, and editor id. Returns a maximum of 50 notebook
     * executions and a marker to track the paging of a longer notebook execution list across
     * multiple ListNotebookExecution calls.
     */
    suspend fun listNotebookExecutions(input: ListNotebookExecutionsRequest): ListNotebookExecutionsResponse

    /**
     * Provides summaries of all notebook executions. You can filter the list based on multiple
     * criteria such as status, time range, and editor id. Returns a maximum of 50 notebook
     * executions and a marker to track the paging of a longer notebook execution list across
     * multiple ListNotebookExecution calls.
     */
    suspend fun listNotebookExecutions(block: ListNotebookExecutionsRequest.Builder.() -> Unit) = listNotebookExecutions(ListNotebookExecutionsRequest.Builder().apply(block).build())

    /**
     * Retrieves release labels of EMR services in the region where the API is called.
     */
    suspend fun listReleaseLabels(input: ListReleaseLabelsRequest): ListReleaseLabelsResponse

    /**
     * Retrieves release labels of EMR services in the region where the API is called.
     */
    suspend fun listReleaseLabels(block: ListReleaseLabelsRequest.Builder.() -> Unit) = listReleaseLabels(ListReleaseLabelsRequest.Builder().apply(block).build())

    /**
     * Lists all the security configurations visible to this account, providing their creation
     * dates and times, and their names. This call returns a maximum of 50 clusters per call, but
     * returns a marker to track the paging of the cluster list across multiple
     * ListSecurityConfigurations calls.
     */
    suspend fun listSecurityConfigurations(input: ListSecurityConfigurationsRequest): ListSecurityConfigurationsResponse

    /**
     * Lists all the security configurations visible to this account, providing their creation
     * dates and times, and their names. This call returns a maximum of 50 clusters per call, but
     * returns a marker to track the paging of the cluster list across multiple
     * ListSecurityConfigurations calls.
     */
    suspend fun listSecurityConfigurations(block: ListSecurityConfigurationsRequest.Builder.() -> Unit) = listSecurityConfigurations(ListSecurityConfigurationsRequest.Builder().apply(block).build())

    /**
     * Provides a list of steps for the cluster in reverse order unless you specify
     * stepIds with the request or filter by StepStates. You can
     * specify a maximum of 10 stepIDs. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a Marker, which is a pagination token that indicates the next set of steps to retrieve.
     */
    suspend fun listSteps(input: ListStepsRequest): ListStepsResponse

    /**
     * Provides a list of steps for the cluster in reverse order unless you specify
     * stepIds with the request or filter by StepStates. You can
     * specify a maximum of 10 stepIDs. The CLI automatically paginates results to return a list greater than 50 steps. To return more than 50 steps using the CLI, specify a Marker, which is a pagination token that indicates the next set of steps to retrieve.
     */
    suspend fun listSteps(block: ListStepsRequest.Builder.() -> Unit) = listSteps(ListStepsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by
     * StudioId.
     */
    suspend fun listStudioSessionMappings(input: ListStudioSessionMappingsRequest): ListStudioSessionMappingsResponse

    /**
     * Returns a list of all user or group session mappings for the Amazon EMR Studio specified by
     * StudioId.
     */
    suspend fun listStudioSessionMappings(block: ListStudioSessionMappingsRequest.Builder.() -> Unit) = listStudioSessionMappings(ListStudioSessionMappingsRequest.Builder().apply(block).build())

    /**
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list
     * includes details such as ID, Studio Access URL, and creation time for each Studio.
     */
    suspend fun listStudios(input: ListStudiosRequest): ListStudiosResponse

    /**
     * Returns a list of all Amazon EMR Studios associated with the Amazon Web Services account. The list
     * includes details such as ID, Studio Access URL, and creation time for each Studio.
     */
    suspend fun listStudios(block: ListStudiosRequest.Builder.() -> Unit) = listStudios(ListStudiosRequest.Builder().apply(block).build())

    /**
     * Modifies the number of steps that can be executed concurrently for the cluster specified
     * using ClusterID.
     */
    suspend fun modifyCluster(input: ModifyClusterRequest): ModifyClusterResponse

    /**
     * Modifies the number of steps that can be executed concurrently for the cluster specified
     * using ClusterID.
     */
    suspend fun modifyCluster(block: ModifyClusterRequest.Builder.() -> Unit) = modifyCluster(ModifyClusterRequest.Builder().apply(block).build())

    /**
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the
     * specified InstanceFleetID within the cluster specified using ClusterID. The call either
     * succeeds or fails atomically.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions.
     */
    suspend fun modifyInstanceFleet(input: ModifyInstanceFleetRequest): ModifyInstanceFleetResponse

    /**
     * Modifies the target On-Demand and target Spot capacities for the instance fleet with the
     * specified InstanceFleetID within the cluster specified using ClusterID. The call either
     * succeeds or fails atomically.
     *
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions.
     */
    suspend fun modifyInstanceFleet(block: ModifyInstanceFleetRequest.Builder.() -> Unit) = modifyInstanceFleet(ModifyInstanceFleetRequest.Builder().apply(block).build())

    /**
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an
     * instance group. The input parameters include the new target instance count for the group
     * and the instance group ID. The call will either succeed or fail atomically.
     */
    suspend fun modifyInstanceGroups(input: ModifyInstanceGroupsRequest): ModifyInstanceGroupsResponse

    /**
     * ModifyInstanceGroups modifies the number of nodes and configuration settings of an
     * instance group. The input parameters include the new target instance count for the group
     * and the instance group ID. The call will either succeed or fail atomically.
     */
    suspend fun modifyInstanceGroups(block: ModifyInstanceGroupsRequest.Builder.() -> Unit) = modifyInstanceGroups(ModifyInstanceGroupsRequest.Builder().apply(block).build())

    /**
     * Creates or updates an automatic scaling policy for a core instance group or task
     * instance group in an Amazon EMR cluster. The automatic scaling policy defines how an
     * instance group dynamically adds and terminates EC2 instances in response to the value of a
     * CloudWatch metric.
     */
    suspend fun putAutoScalingPolicy(input: PutAutoScalingPolicyRequest): PutAutoScalingPolicyResponse

    /**
     * Creates or updates an automatic scaling policy for a core instance group or task
     * instance group in an Amazon EMR cluster. The automatic scaling policy defines how an
     * instance group dynamically adds and terminates EC2 instances in response to the value of a
     * CloudWatch metric.
     */
    suspend fun putAutoScalingPolicy(block: PutAutoScalingPolicyRequest.Builder.() -> Unit) = putAutoScalingPolicy(PutAutoScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an auto-termination policy.
     *
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination.
     */
    suspend fun putAutoTerminationPolicy(input: PutAutoTerminationPolicyRequest): PutAutoTerminationPolicyResponse

    /**
     * Auto-termination is supported in Amazon EMR versions 5.30.0 and 6.1.0 and later. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-auto-termination-policy.html">Using an auto-termination policy.
     *
     * Creates or updates an auto-termination policy for an Amazon EMR cluster. An auto-termination policy defines the amount of idle time in seconds after which a cluster automatically terminates. For alternative cluster termination options, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-termination.html">Control cluster termination.
     */
    suspend fun putAutoTerminationPolicy(block: PutAutoTerminationPolicyRequest.Builder.() -> Unit) = putAutoTerminationPolicy(PutAutoTerminationPolicyRequest.Builder().apply(block).build())

    /**
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account
     * in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR in the Amazon EMR Management
     * Guide.
     */
    suspend fun putBlockPublicAccessConfiguration(input: PutBlockPublicAccessConfigurationRequest): PutBlockPublicAccessConfigurationResponse

    /**
     * Creates or updates an Amazon EMR block public access configuration for your Amazon Web Services account
     * in the current Region. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/configure-block-public-access.html">Configure Block
     * Public Access for Amazon EMR in the Amazon EMR Management
     * Guide.
     */
    suspend fun putBlockPublicAccessConfiguration(block: PutBlockPublicAccessConfigurationRequest.Builder.() -> Unit) = putBlockPublicAccessConfiguration(PutBlockPublicAccessConfigurationRequest.Builder().apply(block).build())

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed
     * scaling policy defines the limits for resources, such as EC2 instances that can be added or
     * terminated from a cluster. The policy only applies to the core and task nodes. The master
     * node cannot be scaled after initial configuration.
     */
    suspend fun putManagedScalingPolicy(input: PutManagedScalingPolicyRequest): PutManagedScalingPolicyResponse

    /**
     * Creates or updates a managed scaling policy for an Amazon EMR cluster. The managed
     * scaling policy defines the limits for resources, such as EC2 instances that can be added or
     * terminated from a cluster. The policy only applies to the core and task nodes. The master
     * node cannot be scaled after initial configuration.
     */
    suspend fun putManagedScalingPolicy(block: PutManagedScalingPolicyRequest.Builder.() -> Unit) = putManagedScalingPolicy(PutManagedScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Removes an automatic scaling policy from a specified instance group within an EMR
     * cluster.
     */
    suspend fun removeAutoScalingPolicy(input: RemoveAutoScalingPolicyRequest): RemoveAutoScalingPolicyResponse

    /**
     * Removes an automatic scaling policy from a specified instance group within an EMR
     * cluster.
     */
    suspend fun removeAutoScalingPolicy(block: RemoveAutoScalingPolicyRequest.Builder.() -> Unit) = removeAutoScalingPolicy(RemoveAutoScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Removes an auto-termination policy from an Amazon EMR cluster.
     */
    suspend fun removeAutoTerminationPolicy(input: RemoveAutoTerminationPolicyRequest): RemoveAutoTerminationPolicyResponse

    /**
     * Removes an auto-termination policy from an Amazon EMR cluster.
     */
    suspend fun removeAutoTerminationPolicy(block: RemoveAutoTerminationPolicyRequest.Builder.() -> Unit) = removeAutoTerminationPolicy(RemoveAutoTerminationPolicyRequest.Builder().apply(block).build())

    /**
     * Removes a managed scaling policy from a specified EMR cluster.
     */
    suspend fun removeManagedScalingPolicy(input: RemoveManagedScalingPolicyRequest): RemoveManagedScalingPolicyResponse

    /**
     * Removes a managed scaling policy from a specified EMR cluster.
     */
    suspend fun removeManagedScalingPolicy(block: RemoveManagedScalingPolicyRequest.Builder.() -> Unit) = removeManagedScalingPolicy(RemoveManagedScalingPolicyRequest.Builder().apply(block).build())

    /**
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in
     * various ways, such as grouping clusters to track your Amazon EMR resource allocation costs.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters.
     * The following example removes the stack tag with value Prod from a cluster:
     */
    suspend fun removeTags(input: RemoveTagsRequest): RemoveTagsResponse

    /**
     * Removes tags from an Amazon EMR resource, such as a cluster or Amazon EMR Studio. Tags make it easier to associate resources in
     * various ways, such as grouping clusters to track your Amazon EMR resource allocation costs.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-tags.html">Tag Clusters.
     * The following example removes the stack tag with value Prod from a cluster:
     */
    suspend fun removeTags(block: RemoveTagsRequest.Builder.() -> Unit) = removeTags(RemoveTagsRequest.Builder().apply(block).build())

    /**
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the
     * steps specified. After the steps complete, the cluster stops and the HDFS partition is
     * lost. To prevent loss of data, configure the last step of the job flow to store results in
     * Amazon S3. If the JobFlowInstancesConfig
     * KeepJobFlowAliveWhenNoSteps parameter is set to TRUE, the cluster
     * transitions to the WAITING state rather than shutting down after the steps have completed.
     * For additional protection, you can set the JobFlowInstancesConfig
     * TerminationProtected parameter to TRUE to lock the cluster and
     * prevent it from being terminated by API call, user intervention, or in the event of a job
     * flow error.
     * A maximum of 256 steps are allowed in each job flow.
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may
     * require more than 256 steps to process your data. You can bypass the 256-step limitation in
     * various ways, including using the SSH shell to connect to the master node and submitting
     * queries directly to the software running on the master node, such as Hive and Hadoop. For
     * more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a
     * Cluster in the Amazon EMR Management Guide.
     * For long running clusters, we recommend that you periodically store your results.
     *
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets
     * parameters or InstanceGroups parameters, but not both.
     */
    suspend fun runJobFlow(input: RunJobFlowRequest): RunJobFlowResponse

    /**
     * RunJobFlow creates and starts running a new cluster (job flow). The cluster runs the
     * steps specified. After the steps complete, the cluster stops and the HDFS partition is
     * lost. To prevent loss of data, configure the last step of the job flow to store results in
     * Amazon S3. If the JobFlowInstancesConfig
     * KeepJobFlowAliveWhenNoSteps parameter is set to TRUE, the cluster
     * transitions to the WAITING state rather than shutting down after the steps have completed.
     * For additional protection, you can set the JobFlowInstancesConfig
     * TerminationProtected parameter to TRUE to lock the cluster and
     * prevent it from being terminated by API call, user intervention, or in the event of a job
     * flow error.
     * A maximum of 256 steps are allowed in each job flow.
     * If your cluster is long-running (such as a Hive data warehouse) or complex, you may
     * require more than 256 steps to process your data. You can bypass the 256-step limitation in
     * various ways, including using the SSH shell to connect to the master node and submitting
     * queries directly to the software running on the master node, such as Hive and Hadoop. For
     * more information on how to do this, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/AddMoreThan256Steps.html">Add More than 256 Steps to a
     * Cluster in the Amazon EMR Management Guide.
     * For long running clusters, we recommend that you periodically store your results.
     *
     * The instance fleets configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions. The RunJobFlow request can contain InstanceFleets
     * parameters or InstanceGroups parameters, but not both.
     */
    suspend fun runJobFlow(block: RunJobFlowRequest.Builder.() -> Unit) = runJobFlow(RunJobFlowRequest.Builder().apply(block).build())

    /**
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster
     * cannot be terminated by user intervention, an API call, or in the event of a job-flow
     * error. The cluster still terminates upon successful completion of the job flow. Calling
     * SetTerminationProtection on a cluster is similar to calling the Amazon EC2
     * DisableAPITermination API on all EC2 instances in a cluster.
     *
     * SetTerminationProtection is used to prevent accidental termination of a
     * cluster and to ensure that in the event of an error, the instances persist so that you can
     * recover any data stored in their ephemeral instance storage.
     * To terminate a cluster that has been locked by setting
     * SetTerminationProtection to true, you must first unlock the
     * job flow by a subsequent call to SetTerminationProtection in which you set the
     * value to false.
     * For more information, see<a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing Cluster
     * Termination in the Amazon EMR Management Guide.
     */
    suspend fun setTerminationProtection(input: SetTerminationProtectionRequest): SetTerminationProtectionResponse

    /**
     * SetTerminationProtection locks a cluster (job flow) so the EC2 instances in the cluster
     * cannot be terminated by user intervention, an API call, or in the event of a job-flow
     * error. The cluster still terminates upon successful completion of the job flow. Calling
     * SetTerminationProtection on a cluster is similar to calling the Amazon EC2
     * DisableAPITermination API on all EC2 instances in a cluster.
     *
     * SetTerminationProtection is used to prevent accidental termination of a
     * cluster and to ensure that in the event of an error, the instances persist so that you can
     * recover any data stored in their ephemeral instance storage.
     * To terminate a cluster that has been locked by setting
     * SetTerminationProtection to true, you must first unlock the
     * job flow by a subsequent call to SetTerminationProtection in which you set the
     * value to false.
     * For more information, see<a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/UsingEMR_TerminationProtection.html">Managing Cluster
     * Termination in the Amazon EMR Management Guide.
     */
    suspend fun setTerminationProtection(block: SetTerminationProtectionRequest.Builder.() -> Unit) = setTerminationProtection(SetTerminationProtectionRequest.Builder().apply(block).build())

    /**
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account.
     * To restrict cluster access using an IAM policy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access Management for EMR.
     *
     *
     * Sets the Cluster$VisibleToAllUsers value for an EMR cluster. When true, IAM principals in the
     * Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     * This action works on running clusters. When you create a cluster, use the RunJobFlowInput$VisibleToAllUsers parameter.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting in the Amazon EMRManagement Guide.
     */
    suspend fun setVisibleToAllUsers(input: SetVisibleToAllUsersRequest): SetVisibleToAllUsersResponse

    /**
     * The SetVisibleToAllUsers parameter is no longer supported. Your cluster may be visible to all users in your account.
     * To restrict cluster access using an IAM policy, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-plan-access-iam.html">Identity and Access Management for EMR.
     *
     *
     * Sets the Cluster$VisibleToAllUsers value for an EMR cluster. When true, IAM principals in the
     * Amazon Web Services account can perform EMR cluster actions that their IAM policies allow. When false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions on the cluster, regardless of IAM permissions policies attached to other IAM principals.
     * This action works on running clusters. When you create a cluster, use the RunJobFlowInput$VisibleToAllUsers parameter.
     * For more information, see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/security_iam_emr-with-iam.html#security_set_visible_to_all_users">Understanding the EMR Cluster VisibleToAllUsers Setting in the Amazon EMRManagement Guide.
     */
    suspend fun setVisibleToAllUsers(block: SetVisibleToAllUsersRequest.Builder.() -> Unit) = setVisibleToAllUsers(SetVisibleToAllUsersRequest.Builder().apply(block).build())

    /**
     * Starts a notebook execution.
     */
    suspend fun startNotebookExecution(input: StartNotebookExecutionRequest): StartNotebookExecutionResponse

    /**
     * Starts a notebook execution.
     */
    suspend fun startNotebookExecution(block: StartNotebookExecutionRequest.Builder.() -> Unit) = startNotebookExecution(StartNotebookExecutionRequest.Builder().apply(block).build())

    /**
     * Stops a notebook execution.
     */
    suspend fun stopNotebookExecution(input: StopNotebookExecutionRequest): StopNotebookExecutionResponse

    /**
     * Stops a notebook execution.
     */
    suspend fun stopNotebookExecution(block: StopNotebookExecutionRequest.Builder.() -> Unit) = stopNotebookExecution(StopNotebookExecutionRequest.Builder().apply(block).build())

    /**
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut
     * down, any step not yet completed is canceled and the EC2 instances on which the cluster is
     * running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri
     * was specified when the cluster was created.
     * The maximum number of clusters allowed is 10. The call to TerminateJobFlows
     * is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5
     * minutes for the cluster to completely terminate and release allocated resources, such as
     * Amazon EC2 instances.
     */
    suspend fun terminateJobFlows(input: TerminateJobFlowsRequest): TerminateJobFlowsResponse

    /**
     * TerminateJobFlows shuts a list of clusters (job flows) down. When a job flow is shut
     * down, any step not yet completed is canceled and the EC2 instances on which the cluster is
     * running are stopped. Any log files not already saved are uploaded to Amazon S3 if a LogUri
     * was specified when the cluster was created.
     * The maximum number of clusters allowed is 10. The call to TerminateJobFlows
     * is asynchronous. Depending on the configuration of the cluster, it may take up to 1-5
     * minutes for the cluster to completely terminate and release allocated resources, such as
     * Amazon EC2 instances.
     */
    suspend fun terminateJobFlows(block: TerminateJobFlowsRequest.Builder.() -> Unit) = terminateJobFlows(TerminateJobFlowsRequest.Builder().apply(block).build())

    /**
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     */
    suspend fun updateStudio(input: UpdateStudioRequest): UpdateStudioResponse

    /**
     * Updates an Amazon EMR Studio configuration, including attributes such as name, description, and subnets.
     */
    suspend fun updateStudio(block: UpdateStudioRequest.Builder.() -> Unit) = updateStudio(UpdateStudioRequest.Builder().apply(block).build())

    /**
     * Updates the session policy attached to the user or group for the specified Amazon EMR
     * Studio.
     */
    suspend fun updateStudioSessionMapping(input: UpdateStudioSessionMappingRequest): UpdateStudioSessionMappingResponse

    /**
     * Updates the session policy attached to the user or group for the specified Amazon EMR
     * Studio.
     */
    suspend fun updateStudioSessionMapping(block: UpdateStudioSessionMappingRequest.Builder.() -> Unit) = updateStudioSessionMapping(UpdateStudioSessionMappingRequest.Builder().apply(block).build())
}
