// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * An automatic scaling policy for a core instance group or task instance group in an
 * Amazon EMR cluster. The automatic scaling policy defines how an instance group dynamically
 * adds and terminates EC2 instances in response to the value of a CloudWatch metric. See
 * PutAutoScalingPolicy.
 */
class AutoScalingPolicyDescription private constructor(builder: Builder) {
    /**
     * The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
     * scaling activity will not cause an instance group to grow above or below these
     * limits.
     */
    val constraints: aws.sdk.kotlin.services.emr.model.ScalingConstraints? = builder.constraints
    /**
     * The scale-in and scale-out rules that comprise the automatic scaling policy.
     */
    val rules: List<ScalingRule>? = builder.rules
    /**
     * The status of an automatic scaling policy.
     */
    val status: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoScalingPolicyDescription(")
        append("constraints=$constraints,")
        append("rules=$rules,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = constraints?.hashCode() ?: 0
        result = 31 * result + (rules?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoScalingPolicyDescription

        if (constraints != other.constraints) return false
        if (rules != other.rules) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * The upper and lower EC2 instance limits for an automatic scaling policy. Automatic
         * scaling activity will not cause an instance group to grow above or below these
         * limits.
         */
        var constraints: aws.sdk.kotlin.services.emr.model.ScalingConstraints? = null
        /**
         * The scale-in and scale-out rules that comprise the automatic scaling policy.
         */
        var rules: List<ScalingRule>? = null
        /**
         * The status of an automatic scaling policy.
         */
        var status: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription) : this() {
            this.constraints = x.constraints
            this.rules = x.rules
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.AutoScalingPolicyDescription = AutoScalingPolicyDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ScalingConstraints] inside the given [block]
         */
        fun constraints(block: aws.sdk.kotlin.services.emr.model.ScalingConstraints.Builder.() -> kotlin.Unit) {
            this.constraints = aws.sdk.kotlin.services.emr.model.ScalingConstraints.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.AutoScalingPolicyStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.emr.model.AutoScalingPolicyStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.AutoScalingPolicyStatus.invoke(block)
        }
    }
}
