// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * The detailed description of the cluster.
 */
class Cluster private constructor(builder: Builder) {
    /**
     * The applications installed on this cluster.
     */
    val applications: List<Application>? = builder.applications
    /**
     * An IAM role for automatic scaling policies. The default role is
     * EMR_AutoScaling_DefaultRole. The IAM role provides permissions that the
     * automatic scaling feature requires to launch and terminate EC2 instances in an instance
     * group.
     */
    val autoScalingRole: kotlin.String? = builder.autoScalingRole
    /**
     * Specifies whether the cluster should terminate after completing all steps.
     */
    val autoTerminate: kotlin.Boolean = builder.autoTerminate
    /**
     * The Amazon Resource Name of the cluster.
     */
    val clusterArn: kotlin.String? = builder.clusterArn
    /**
     * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied
     * to the EMR cluster.
     */
    val configurations: List<Configuration>? = builder.configurations
    /**
     * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
     * EBS-backed Linux AMI if the cluster uses a custom AMI.
     */
    val customAmiId: kotlin.String? = builder.customAmiId
    /**
     * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
     * each EC2 instance. Available in Amazon EMR version 4.x and later.
     */
    val ebsRootVolumeSize: kotlin.Int? = builder.ebsRootVolumeSize
    /**
     * Provides information about the EC2 instances in a cluster grouped by category. For
     * example, key name, subnet ID, IAM instance profile, and so on.
     */
    val ec2InstanceAttributes: aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes? = builder.ec2InstanceAttributes
    /**
     * The unique identifier for the cluster.
     */
    val id: kotlin.String? = builder.id
    /**
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
     * later, excluding 5.0.x versions.
     *
     * The instance group configuration of the cluster. A value of INSTANCE_GROUP
     * indicates a uniform instance group configuration. A value of INSTANCE_FLEET
     * indicates an instance fleets configuration.
     */
    val instanceCollectionType: aws.sdk.kotlin.services.emr.model.InstanceCollectionType? = builder.instanceCollectionType
    /**
     * Attributes for Kerberos configuration when Kerberos authentication is enabled using a
     * security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication
     * in the Amazon EMR Management Guide.
     */
    val kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = builder.kerberosAttributes
    /**
     * The KMS key used for encrypting log files. This attribute is
     * only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
     */
    val logEncryptionKmsKeyId: kotlin.String? = builder.logEncryptionKmsKeyId
    /**
     * The path to the Amazon S3 location where logs for this cluster are stored.
     */
    val logUri: kotlin.String? = builder.logUri
    /**
     * The DNS name of the master node. If the cluster is on a private subnet, this is the
     * private DNS name. On a public subnet, this is the public DNS name.
     */
    val masterPublicDnsName: kotlin.String? = builder.masterPublicDnsName
    /**
     * The name of the cluster.
     */
    val name: kotlin.String? = builder.name
    /**
     * An approximation of the cost of the cluster, represented in m1.small/hours. This value
     * is incremented one time for every hour an m1.small instance runs. Larger instances are
     * weighted more, so an EC2 instance that is roughly four times more expensive would result in
     * the normalized instance hours being incremented by four. This result is only an
     * approximation and does not reflect the actual billing rate.
     */
    val normalizedInstanceHours: kotlin.Int? = builder.normalizedInstanceHours
    /**
     * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * Placement group configured for an Amazon EMR cluster.
     */
    val placementGroups: List<PlacementGroupConfig>? = builder.placementGroups
    /**
     * The Amazon EMR release label, which determines the version of open-source application
     * packages installed on the cluster. Release labels are in the form emr-x.x.x,
     * where x.x.x is an Amazon EMR release version such as emr-5.14.0. For more
     * information about Amazon EMR release versions and included application versions and
     * features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/. The release
     * label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
     * AmiVersion.
     */
    val releaseLabel: kotlin.String? = builder.releaseLabel
    /**
     * Applies only when CustomAmiID is used. Specifies the type of updates that
     * are applied from the Amazon Linux AMI package repositories when an instance boots using the
     * AMI.
     */
    val repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = builder.repoUpgradeOnBoot
    /**
     * The AMI version requested for this cluster.
     */
    val requestedAmiVersion: kotlin.String? = builder.requestedAmiVersion
    /**
     * The AMI version running on this cluster.
     */
    val runningAmiVersion: kotlin.String? = builder.runningAmiVersion
    /**
     * The way that individual Amazon EC2 instances terminate when an automatic scale-in
     * activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
     * indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
     * when the request to terminate the instance was submitted. This option is only available
     * with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
     * TERMINATE_AT_TASK_COMPLETION indicates that Amazon EMR adds nodes to a deny
     * list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
     * the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
     * first and blocks instance termination if it could lead to HDFS corruption.
     * TERMINATE_AT_TASK_COMPLETION is available only in Amazon EMR version 4.1.0
     * and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
     */
    val scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = builder.scaleDownBehavior
    /**
     * The name of the security configuration applied to the cluster.
     */
    val securityConfiguration: kotlin.String? = builder.securityConfiguration
    /**
     * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
     * your behalf.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * The current status details about the cluster.
     */
    val status: aws.sdk.kotlin.services.emr.model.ClusterStatus? = builder.status
    /**
     * Specifies the number of steps that can be executed concurrently.
     */
    val stepConcurrencyLevel: kotlin.Int? = builder.stepConcurrencyLevel
    /**
     * A list of tags associated with a cluster.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from
     * being terminated by an API call or user intervention, or in the event of a cluster
     * error.
     */
    val terminationProtected: kotlin.Boolean = builder.terminationProtected
    /**
     * Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
     * with the cluster. When true, IAM principals in the
     * Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.
     * The default value is true if a value is not provided when creating a
     * cluster using the EMR API RunJobFlow command, the CLI
     * <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster command, or the Amazon Web Services Management Console.
     */
    val visibleToAllUsers: kotlin.Boolean = builder.visibleToAllUsers

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("applications=$applications,")
        append("autoScalingRole=$autoScalingRole,")
        append("autoTerminate=$autoTerminate,")
        append("clusterArn=$clusterArn,")
        append("configurations=$configurations,")
        append("customAmiId=$customAmiId,")
        append("ebsRootVolumeSize=$ebsRootVolumeSize,")
        append("ec2InstanceAttributes=$ec2InstanceAttributes,")
        append("id=$id,")
        append("instanceCollectionType=$instanceCollectionType,")
        append("kerberosAttributes=$kerberosAttributes,")
        append("logEncryptionKmsKeyId=$logEncryptionKmsKeyId,")
        append("logUri=$logUri,")
        append("masterPublicDnsName=$masterPublicDnsName,")
        append("name=$name,")
        append("normalizedInstanceHours=$normalizedInstanceHours,")
        append("outpostArn=$outpostArn,")
        append("placementGroups=$placementGroups,")
        append("releaseLabel=$releaseLabel,")
        append("repoUpgradeOnBoot=$repoUpgradeOnBoot,")
        append("requestedAmiVersion=$requestedAmiVersion,")
        append("runningAmiVersion=$runningAmiVersion,")
        append("scaleDownBehavior=$scaleDownBehavior,")
        append("securityConfiguration=$securityConfiguration,")
        append("serviceRole=$serviceRole,")
        append("status=$status,")
        append("stepConcurrencyLevel=$stepConcurrencyLevel,")
        append("tags=$tags,")
        append("terminationProtected=$terminationProtected,")
        append("visibleToAllUsers=$visibleToAllUsers)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applications?.hashCode() ?: 0
        result = 31 * result + (autoScalingRole?.hashCode() ?: 0)
        result = 31 * result + (autoTerminate.hashCode())
        result = 31 * result + (clusterArn?.hashCode() ?: 0)
        result = 31 * result + (configurations?.hashCode() ?: 0)
        result = 31 * result + (customAmiId?.hashCode() ?: 0)
        result = 31 * result + (ebsRootVolumeSize ?: 0)
        result = 31 * result + (ec2InstanceAttributes?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (instanceCollectionType?.hashCode() ?: 0)
        result = 31 * result + (kerberosAttributes?.hashCode() ?: 0)
        result = 31 * result + (logEncryptionKmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (masterPublicDnsName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (normalizedInstanceHours ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (placementGroups?.hashCode() ?: 0)
        result = 31 * result + (releaseLabel?.hashCode() ?: 0)
        result = 31 * result + (repoUpgradeOnBoot?.hashCode() ?: 0)
        result = 31 * result + (requestedAmiVersion?.hashCode() ?: 0)
        result = 31 * result + (runningAmiVersion?.hashCode() ?: 0)
        result = 31 * result + (scaleDownBehavior?.hashCode() ?: 0)
        result = 31 * result + (securityConfiguration?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (stepConcurrencyLevel ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (terminationProtected.hashCode())
        result = 31 * result + (visibleToAllUsers.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (applications != other.applications) return false
        if (autoScalingRole != other.autoScalingRole) return false
        if (autoTerminate != other.autoTerminate) return false
        if (clusterArn != other.clusterArn) return false
        if (configurations != other.configurations) return false
        if (customAmiId != other.customAmiId) return false
        if (ebsRootVolumeSize != other.ebsRootVolumeSize) return false
        if (ec2InstanceAttributes != other.ec2InstanceAttributes) return false
        if (id != other.id) return false
        if (instanceCollectionType != other.instanceCollectionType) return false
        if (kerberosAttributes != other.kerberosAttributes) return false
        if (logEncryptionKmsKeyId != other.logEncryptionKmsKeyId) return false
        if (logUri != other.logUri) return false
        if (masterPublicDnsName != other.masterPublicDnsName) return false
        if (name != other.name) return false
        if (normalizedInstanceHours != other.normalizedInstanceHours) return false
        if (outpostArn != other.outpostArn) return false
        if (placementGroups != other.placementGroups) return false
        if (releaseLabel != other.releaseLabel) return false
        if (repoUpgradeOnBoot != other.repoUpgradeOnBoot) return false
        if (requestedAmiVersion != other.requestedAmiVersion) return false
        if (runningAmiVersion != other.runningAmiVersion) return false
        if (scaleDownBehavior != other.scaleDownBehavior) return false
        if (securityConfiguration != other.securityConfiguration) return false
        if (serviceRole != other.serviceRole) return false
        if (status != other.status) return false
        if (stepConcurrencyLevel != other.stepConcurrencyLevel) return false
        if (tags != other.tags) return false
        if (terminationProtected != other.terminationProtected) return false
        if (visibleToAllUsers != other.visibleToAllUsers) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.Cluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * The applications installed on this cluster.
         */
        var applications: List<Application>? = null
        /**
         * An IAM role for automatic scaling policies. The default role is
         * EMR_AutoScaling_DefaultRole. The IAM role provides permissions that the
         * automatic scaling feature requires to launch and terminate EC2 instances in an instance
         * group.
         */
        var autoScalingRole: kotlin.String? = null
        /**
         * Specifies whether the cluster should terminate after completing all steps.
         */
        var autoTerminate: kotlin.Boolean = false
        /**
         * The Amazon Resource Name of the cluster.
         */
        var clusterArn: kotlin.String? = null
        /**
         * Applies only to Amazon EMR releases 4.x and later. The list of Configurations supplied
         * to the EMR cluster.
         */
        var configurations: List<Configuration>? = null
        /**
         * Available only in Amazon EMR version 5.7.0 and later. The ID of a custom Amazon
         * EBS-backed Linux AMI if the cluster uses a custom AMI.
         */
        var customAmiId: kotlin.String? = null
        /**
         * The size, in GiB, of the Amazon EBS root device volume of the Linux AMI that is used for
         * each EC2 instance. Available in Amazon EMR version 4.x and later.
         */
        var ebsRootVolumeSize: kotlin.Int? = null
        /**
         * Provides information about the EC2 instances in a cluster grouped by category. For
         * example, key name, subnet ID, IAM instance profile, and so on.
         */
        var ec2InstanceAttributes: aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes? = null
        /**
         * The unique identifier for the cluster.
         */
        var id: kotlin.String? = null
        /**
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and
         * later, excluding 5.0.x versions.
         *
         * The instance group configuration of the cluster. A value of INSTANCE_GROUP
         * indicates a uniform instance group configuration. A value of INSTANCE_FLEET
         * indicates an instance fleets configuration.
         */
        var instanceCollectionType: aws.sdk.kotlin.services.emr.model.InstanceCollectionType? = null
        /**
         * Attributes for Kerberos configuration when Kerberos authentication is enabled using a
         * security configuration. For more information see <a href="https://docs.aws.amazon.com/emr/latest/ManagementGuide/emr-kerberos.html">Use Kerberos Authentication
         * in the Amazon EMR Management Guide.
         */
        var kerberosAttributes: aws.sdk.kotlin.services.emr.model.KerberosAttributes? = null
        /**
         * The KMS key used for encrypting log files. This attribute is
         * only available with EMR version 5.30.0 and later, excluding EMR 6.0.0.
         */
        var logEncryptionKmsKeyId: kotlin.String? = null
        /**
         * The path to the Amazon S3 location where logs for this cluster are stored.
         */
        var logUri: kotlin.String? = null
        /**
         * The DNS name of the master node. If the cluster is on a private subnet, this is the
         * private DNS name. On a public subnet, this is the public DNS name.
         */
        var masterPublicDnsName: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        var name: kotlin.String? = null
        /**
         * An approximation of the cost of the cluster, represented in m1.small/hours. This value
         * is incremented one time for every hour an m1.small instance runs. Larger instances are
         * weighted more, so an EC2 instance that is roughly four times more expensive would result in
         * the normalized instance hours being incremented by four. This result is only an
         * approximation and does not reflect the actual billing rate.
         */
        var normalizedInstanceHours: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost where the cluster is launched.
         */
        var outpostArn: kotlin.String? = null
        /**
         * Placement group configured for an Amazon EMR cluster.
         */
        var placementGroups: List<PlacementGroupConfig>? = null
        /**
         * The Amazon EMR release label, which determines the version of open-source application
         * packages installed on the cluster. Release labels are in the form emr-x.x.x,
         * where x.x.x is an Amazon EMR release version such as emr-5.14.0. For more
         * information about Amazon EMR release versions and included application versions and
         * features, see <a href="https://docs.aws.amazon.com/emr/latest/ReleaseGuide/">https://docs.aws.amazon.com/emr/latest/ReleaseGuide/. The release
         * label applies only to Amazon EMR releases version 4.0 and later. Earlier versions use
         * AmiVersion.
         */
        var releaseLabel: kotlin.String? = null
        /**
         * Applies only when CustomAmiID is used. Specifies the type of updates that
         * are applied from the Amazon Linux AMI package repositories when an instance boots using the
         * AMI.
         */
        var repoUpgradeOnBoot: aws.sdk.kotlin.services.emr.model.RepoUpgradeOnBoot? = null
        /**
         * The AMI version requested for this cluster.
         */
        var requestedAmiVersion: kotlin.String? = null
        /**
         * The AMI version running on this cluster.
         */
        var runningAmiVersion: kotlin.String? = null
        /**
         * The way that individual Amazon EC2 instances terminate when an automatic scale-in
         * activity occurs or an instance group is resized. TERMINATE_AT_INSTANCE_HOUR
         * indicates that Amazon EMR terminates nodes at the instance-hour boundary, regardless of
         * when the request to terminate the instance was submitted. This option is only available
         * with Amazon EMR 5.1.0 and later and is the default for clusters created using that version.
         * TERMINATE_AT_TASK_COMPLETION indicates that Amazon EMR adds nodes to a deny
         * list and drains tasks from nodes before terminating the Amazon EC2 instances, regardless of
         * the instance-hour boundary. With either behavior, Amazon EMR removes the least active nodes
         * first and blocks instance termination if it could lead to HDFS corruption.
         * TERMINATE_AT_TASK_COMPLETION is available only in Amazon EMR version 4.1.0
         * and later, and is the default for versions of Amazon EMR earlier than 5.1.0.
         */
        var scaleDownBehavior: aws.sdk.kotlin.services.emr.model.ScaleDownBehavior? = null
        /**
         * The name of the security configuration applied to the cluster.
         */
        var securityConfiguration: kotlin.String? = null
        /**
         * The IAM role that Amazon EMR assumes in order to access Amazon Web Services resources on
         * your behalf.
         */
        var serviceRole: kotlin.String? = null
        /**
         * The current status details about the cluster.
         */
        var status: aws.sdk.kotlin.services.emr.model.ClusterStatus? = null
        /**
         * Specifies the number of steps that can be executed concurrently.
         */
        var stepConcurrencyLevel: kotlin.Int? = null
        /**
         * A list of tags associated with a cluster.
         */
        var tags: List<Tag>? = null
        /**
         * Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances from
         * being terminated by an API call or user intervention, or in the event of a cluster
         * error.
         */
        var terminationProtected: kotlin.Boolean = false
        /**
         * Indicates whether the cluster is visible to IAM principals in the Amazon Web Services account associated
         * with the cluster. When true, IAM principals in the
         * Amazon Web Services account can perform EMR cluster actions on the cluster that their IAM policies allow. When false, only the IAM principal that created the cluster and the Amazon Web Services account root user can perform EMR actions, regardless of IAM permissions policies attached to other IAM principals.
         * The default value is true if a value is not provided when creating a
         * cluster using the EMR API RunJobFlow command, the CLI
         * <a href="https://docs.aws.amazon.com/cli/latest/reference/emr/create-cluster.html">create-cluster command, or the Amazon Web Services Management Console.
         */
        var visibleToAllUsers: kotlin.Boolean = false

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.Cluster) : this() {
            this.applications = x.applications
            this.autoScalingRole = x.autoScalingRole
            this.autoTerminate = x.autoTerminate
            this.clusterArn = x.clusterArn
            this.configurations = x.configurations
            this.customAmiId = x.customAmiId
            this.ebsRootVolumeSize = x.ebsRootVolumeSize
            this.ec2InstanceAttributes = x.ec2InstanceAttributes
            this.id = x.id
            this.instanceCollectionType = x.instanceCollectionType
            this.kerberosAttributes = x.kerberosAttributes
            this.logEncryptionKmsKeyId = x.logEncryptionKmsKeyId
            this.logUri = x.logUri
            this.masterPublicDnsName = x.masterPublicDnsName
            this.name = x.name
            this.normalizedInstanceHours = x.normalizedInstanceHours
            this.outpostArn = x.outpostArn
            this.placementGroups = x.placementGroups
            this.releaseLabel = x.releaseLabel
            this.repoUpgradeOnBoot = x.repoUpgradeOnBoot
            this.requestedAmiVersion = x.requestedAmiVersion
            this.runningAmiVersion = x.runningAmiVersion
            this.scaleDownBehavior = x.scaleDownBehavior
            this.securityConfiguration = x.securityConfiguration
            this.serviceRole = x.serviceRole
            this.status = x.status
            this.stepConcurrencyLevel = x.stepConcurrencyLevel
            this.tags = x.tags
            this.terminationProtected = x.terminationProtected
            this.visibleToAllUsers = x.visibleToAllUsers
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes] inside the given [block]
         */
        fun ec2InstanceAttributes(block: aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes.Builder.() -> kotlin.Unit) {
            this.ec2InstanceAttributes = aws.sdk.kotlin.services.emr.model.Ec2InstanceAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.KerberosAttributes] inside the given [block]
         */
        fun kerberosAttributes(block: aws.sdk.kotlin.services.emr.model.KerberosAttributes.Builder.() -> kotlin.Unit) {
            this.kerberosAttributes = aws.sdk.kotlin.services.emr.model.KerberosAttributes.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.ClusterStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.emr.model.ClusterStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.emr.model.ClusterStatus.invoke(block)
        }
    }
}
