// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



class CreateStudioRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
     */
    val authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = builder.authMode
    /**
     * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    val defaultS3Location: kotlin.String? = builder.defaultS3Location
    /**
     * A detailed description of the Amazon EMR Studio.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
     * inbound network traffic from the Workspace security group, and it must be in the same VPC
     * specified by VpcId.
     */
    val engineSecurityGroupId: kotlin.String? = builder.engineSecurityGroupId
    /**
     * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
     */
    val idpAuthUrl: kotlin.String? = builder.idpAuthUrl
    /**
     * The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
     */
    val idpRelayStateParameterName: kotlin.String? = builder.idpRelayStateParameterName
    /**
     * A descriptive name for the Amazon EMR Studio.
     */
    val name: kotlin.String? = builder.name
    /**
     * The IAM role that the Amazon EMR Studio assumes. The service role provides a
     * way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
     */
    val serviceRole: kotlin.String? = builder.serviceRole
    /**
     * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
     * specified by VpcId. Studio users can create a Workspace in any of the
     * specified subnets.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
     * consist of a required key string with a maximum of 128 characters, and an optional value
     * string with a maximum of 256 characters.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a UserRole when you use Amazon Web Services SSO authentication. The
     * permissions attached to the UserRole can be scoped down for each user or group using
     * session policies.
     */
    val userRole: kotlin.String? = builder.userRole
    /**
     * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
     * Studio.
     */
    val vpcId: kotlin.String? = builder.vpcId
    /**
     * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
     * allows outbound network traffic to resources in the Engine security group, and it must be
     * in the same VPC specified by VpcId.
     */
    val workspaceSecurityGroupId: kotlin.String? = builder.workspaceSecurityGroupId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStudioRequest(")
        append("authMode=$authMode,")
        append("defaultS3Location=$defaultS3Location,")
        append("description=$description,")
        append("engineSecurityGroupId=$engineSecurityGroupId,")
        append("idpAuthUrl=$idpAuthUrl,")
        append("idpRelayStateParameterName=$idpRelayStateParameterName,")
        append("name=$name,")
        append("serviceRole=$serviceRole,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("userRole=$userRole,")
        append("vpcId=$vpcId,")
        append("workspaceSecurityGroupId=$workspaceSecurityGroupId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = authMode?.hashCode() ?: 0
        result = 31 * result + (defaultS3Location?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (engineSecurityGroupId?.hashCode() ?: 0)
        result = 31 * result + (idpAuthUrl?.hashCode() ?: 0)
        result = 31 * result + (idpRelayStateParameterName?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (serviceRole?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userRole?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (workspaceSecurityGroupId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStudioRequest

        if (authMode != other.authMode) return false
        if (defaultS3Location != other.defaultS3Location) return false
        if (description != other.description) return false
        if (engineSecurityGroupId != other.engineSecurityGroupId) return false
        if (idpAuthUrl != other.idpAuthUrl) return false
        if (idpRelayStateParameterName != other.idpRelayStateParameterName) return false
        if (name != other.name) return false
        if (serviceRole != other.serviceRole) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (userRole != other.userRole) return false
        if (vpcId != other.vpcId) return false
        if (workspaceSecurityGroupId != other.workspaceSecurityGroupId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Specifies whether the Studio authenticates users using IAM or Amazon Web Services SSO.
         */
        var authMode: aws.sdk.kotlin.services.emr.model.AuthMode? = null
        /**
         * The Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         */
        var defaultS3Location: kotlin.String? = null
        /**
         * A detailed description of the Amazon EMR Studio.
         */
        var description: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio Engine security group. The Engine security group allows
         * inbound network traffic from the Workspace security group, and it must be in the same VPC
         * specified by VpcId.
         */
        var engineSecurityGroupId: kotlin.String? = null
        /**
         * The authentication endpoint of your identity provider (IdP). Specify this value when you use IAM authentication and want to let federated users log in to a Studio with the Studio URL and credentials from your IdP. Amazon EMR Studio redirects users to this endpoint to enter credentials.
         */
        var idpAuthUrl: kotlin.String? = null
        /**
         * The name that your identity provider (IdP) uses for its RelayState parameter. For example, RelayState or TargetSource. Specify this value when you use IAM authentication and want to let federated users log in to a Studio using the Studio URL. The RelayState parameter differs by IdP.
         */
        var idpRelayStateParameterName: kotlin.String? = null
        /**
         * A descriptive name for the Amazon EMR Studio.
         */
        var name: kotlin.String? = null
        /**
         * The IAM role that the Amazon EMR Studio assumes. The service role provides a
         * way for Amazon EMR Studio to interoperate with other Amazon Web Services services.
         */
        var serviceRole: kotlin.String? = null
        /**
         * A list of subnet IDs to associate with the Amazon EMR Studio. A Studio can have a maximum of 5 subnets. The subnets must belong to the VPC
         * specified by VpcId. Studio users can create a Workspace in any of the
         * specified subnets.
         */
        var subnetIds: List<String>? = null
        /**
         * A list of tags to associate with the Amazon EMR Studio. Tags are user-defined key-value pairs that
         * consist of a required key string with a maximum of 128 characters, and an optional value
         * string with a maximum of 256 characters.
         */
        var tags: List<Tag>? = null
        /**
         * The IAM user role that users and groups assume when logged in to an Amazon EMR Studio. Only specify a UserRole when you use Amazon Web Services SSO authentication. The
         * permissions attached to the UserRole can be scoped down for each user or group using
         * session policies.
         */
        var userRole: kotlin.String? = null
        /**
         * The ID of the Amazon Virtual Private Cloud (Amazon VPC) to associate with the
         * Studio.
         */
        var vpcId: kotlin.String? = null
        /**
         * The ID of the Amazon EMR Studio Workspace security group. The Workspace security group
         * allows outbound network traffic to resources in the Engine security group, and it must be
         * in the same VPC specified by VpcId.
         */
        var workspaceSecurityGroupId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.CreateStudioRequest) : this() {
            this.authMode = x.authMode
            this.defaultS3Location = x.defaultS3Location
            this.description = x.description
            this.engineSecurityGroupId = x.engineSecurityGroupId
            this.idpAuthUrl = x.idpAuthUrl
            this.idpRelayStateParameterName = x.idpRelayStateParameterName
            this.name = x.name
            this.serviceRole = x.serviceRole
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.userRole = x.userRole
            this.vpcId = x.vpcId
            this.workspaceSecurityGroupId = x.workspaceSecurityGroupId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.CreateStudioRequest = CreateStudioRequest(this)
    }
}
