// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Configuration of requested EBS block device associated with the instance group.
 */
class EbsBlockDevice private constructor(builder: Builder) {
    /**
     * The device name that is exposed to the instance, such as /dev/sdh.
     */
    val device: kotlin.String? = builder.device
    /**
     * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
     * requested for the EBS volume attached to an EC2 instance in the cluster.
     */
    val volumeSpecification: aws.sdk.kotlin.services.emr.model.VolumeSpecification? = builder.volumeSpecification

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.EbsBlockDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsBlockDevice(")
        append("device=$device,")
        append("volumeSpecification=$volumeSpecification)")
    }

    override fun hashCode(): kotlin.Int {
        var result = device?.hashCode() ?: 0
        result = 31 * result + (volumeSpecification?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsBlockDevice

        if (device != other.device) return false
        if (volumeSpecification != other.volumeSpecification) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.EbsBlockDevice = Builder(this).apply(block).build()

    class Builder {
        /**
         * The device name that is exposed to the instance, such as /dev/sdh.
         */
        var device: kotlin.String? = null
        /**
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
         * requested for the EBS volume attached to an EC2 instance in the cluster.
         */
        var volumeSpecification: aws.sdk.kotlin.services.emr.model.VolumeSpecification? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.EbsBlockDevice) : this() {
            this.device = x.device
            this.volumeSpecification = x.volumeSpecification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.EbsBlockDevice = EbsBlockDevice(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.VolumeSpecification] inside the given [block]
         */
        fun volumeSpecification(block: aws.sdk.kotlin.services.emr.model.VolumeSpecification.Builder.() -> kotlin.Unit) {
            this.volumeSpecification = aws.sdk.kotlin.services.emr.model.VolumeSpecification.invoke(block)
        }
    }
}
