// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.emr.model



/**
 * Configuration of requested EBS block device associated with the instance group with
 * count of volumes that will be associated to every instance.
 */
class EbsBlockDeviceConfig private constructor(builder: Builder) {
    /**
     * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
     * requested for the EBS volume attached to an EC2 instance in the cluster.
     */
    val volumeSpecification: aws.sdk.kotlin.services.emr.model.VolumeSpecification? = builder.volumeSpecification
    /**
     * Number of EBS volumes with a specific volume configuration that will be associated with
     * every instance in the instance group
     */
    val volumesPerInstance: kotlin.Int? = builder.volumesPerInstance

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.emr.model.EbsBlockDeviceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EbsBlockDeviceConfig(")
        append("volumeSpecification=$volumeSpecification,")
        append("volumesPerInstance=$volumesPerInstance)")
    }

    override fun hashCode(): kotlin.Int {
        var result = volumeSpecification?.hashCode() ?: 0
        result = 31 * result + (volumesPerInstance ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EbsBlockDeviceConfig

        if (volumeSpecification != other.volumeSpecification) return false
        if (volumesPerInstance != other.volumesPerInstance) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.emr.model.EbsBlockDeviceConfig = Builder(this).apply(block).build()

    class Builder {
        /**
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be
         * requested for the EBS volume attached to an EC2 instance in the cluster.
         */
        var volumeSpecification: aws.sdk.kotlin.services.emr.model.VolumeSpecification? = null
        /**
         * Number of EBS volumes with a specific volume configuration that will be associated with
         * every instance in the instance group
         */
        var volumesPerInstance: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.emr.model.EbsBlockDeviceConfig) : this() {
            this.volumeSpecification = x.volumeSpecification
            this.volumesPerInstance = x.volumesPerInstance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.emr.model.EbsBlockDeviceConfig = EbsBlockDeviceConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.emr.model.VolumeSpecification] inside the given [block]
         */
        fun volumeSpecification(block: aws.sdk.kotlin.services.emr.model.VolumeSpecification.Builder.() -> kotlin.Unit) {
            this.volumeSpecification = aws.sdk.kotlin.services.emr.model.VolumeSpecification.invoke(block)
        }
    }
}
